/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.device;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.GroupEntity;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.NameConflictStrategy;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.security.DeviceCredentials;
import org.thingsboard.server.dao.device.ClaimDevicesService;
import org.thingsboard.server.dao.device.DeviceCredentialsService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.device.claim.ClaimResponse;
import org.thingsboard.server.dao.device.claim.ClaimResult;
import org.thingsboard.server.dao.device.claim.ReclaimResult;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.device.TbDeviceService;
import org.thingsboard.server.service.security.permission.OwnersCacheService;

@TbCoreComponent
@Service
public class DefaultTbDeviceService
extends AbstractTbEntityService
implements TbDeviceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbDeviceService.class);
    private final DeviceService deviceService;
    private final DeviceCredentialsService deviceCredentialsService;
    private final ClaimDevicesService claimDevicesService;
    private final OwnersCacheService ownersCacheService;

    public Device save(Device device, EntityGroup entityGroup) throws Exception {
        return this.save(device, null, entityGroup, null);
    }

    public Device save(Device device, String accessToken, EntityGroup entityGroup, User user) throws Exception {
        return this.save(device, accessToken, entityGroup != null ? Collections.singletonList(entityGroup) : null, user);
    }

    public Device save(Device device, String accessToken, List<EntityGroup> entityGroups, User user) throws Exception {
        return this.save(device, accessToken, entityGroups, NameConflictStrategy.DEFAULT, user);
    }

    public Device save(Device device, String accessToken, List<EntityGroup> entityGroups, NameConflictStrategy nameConflictStrategy, User user) throws Exception {
        ActionType actionType = device.getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        TenantId tenantId = device.getTenantId();
        Device savedDevice = (Device)this.checkNotNull((Object)this.deviceService.saveDeviceWithAccessToken(device, accessToken, nameConflictStrategy));
        this.autoCommit(user, (EntityId)savedDevice.getId());
        this.createOrUpdateGroupEntity(tenantId, (GroupEntity)savedDevice, entityGroups, actionType, user);
        return savedDevice;
    }

    public Device saveDeviceWithCredentials(Device device, DeviceCredentials credentials, EntityGroup entityGroup, User user) throws ThingsboardException {
        return this.saveDeviceWithCredentials(device, credentials, entityGroup != null ? Collections.singletonList(entityGroup) : null, user);
    }

    public Device saveDeviceWithCredentials(Device device, DeviceCredentials credentials, List<EntityGroup> entityGroups, User user) throws ThingsboardException {
        return this.saveDeviceWithCredentials(device, credentials, entityGroups, NameConflictStrategy.DEFAULT, user);
    }

    public Device saveDeviceWithCredentials(Device device, DeviceCredentials credentials, List<EntityGroup> entityGroups, NameConflictStrategy nameConflictStrategy, User user) throws ThingsboardException {
        boolean isCreate = device.getId() == null;
        ActionType actionType = isCreate ? ActionType.ADDED : ActionType.UPDATED;
        TenantId tenantId = device.getTenantId();
        try {
            Device savedDevice = (Device)this.checkNotNull((Object)this.deviceService.saveDeviceWithCredentials(device, credentials, nameConflictStrategy));
            this.createOrUpdateGroupEntity(tenantId, (GroupEntity)savedDevice, entityGroups, actionType, user);
            return savedDevice;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.DEVICE), (HasName)device, actionType, user, e, new Object[0]);
            throw e;
        }
    }

    @Transactional
    public void delete(Device device, User user) {
        ActionType actionType = ActionType.DELETED;
        TenantId tenantId = device.getTenantId();
        DeviceId deviceId = device.getId();
        try {
            this.deviceService.deleteDevice(tenantId, deviceId);
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)deviceId, (HasName)device, device.getCustomerId(), actionType, user, new Object[]{deviceId.toString()});
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.DEVICE), actionType, user, e, new Object[]{deviceId.toString()});
            throw e;
        }
    }

    public void delete(DeviceId deviceId, User user) {
        Device device = this.deviceService.findDeviceById(user.getTenantId(), deviceId);
        this.delete(device, user);
    }

    public DeviceCredentials getDeviceCredentialsByDeviceId(Device device, User user) throws ThingsboardException {
        TenantId tenantId = device.getTenantId();
        DeviceId deviceId = device.getId();
        try {
            DeviceCredentials deviceCredentials = (DeviceCredentials)this.checkNotNull((Object)this.deviceCredentialsService.findDeviceCredentialsByDeviceId(tenantId, deviceId));
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)deviceId, (HasName)device, device.getCustomerId(), ActionType.CREDENTIALS_READ, user, new Object[]{deviceId.toString()});
            return deviceCredentials;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.DEVICE), ActionType.CREDENTIALS_READ, user, e, new Object[]{deviceId.toString()});
            throw e;
        }
    }

    public DeviceCredentials updateDeviceCredentials(Device device, DeviceCredentials deviceCredentials, User user) throws ThingsboardException {
        ActionType actionType = ActionType.CREDENTIALS_UPDATED;
        TenantId tenantId = device.getTenantId();
        DeviceId deviceId = device.getId();
        try {
            DeviceCredentials result = (DeviceCredentials)this.checkNotNull((Object)this.deviceCredentialsService.updateDeviceCredentials(tenantId, deviceCredentials));
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)deviceId, (HasName)device, device.getCustomerId(), actionType, user, new Object[]{result});
            return result;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.DEVICE), actionType, user, e, new Object[]{deviceCredentials});
            throw e;
        }
    }

    public ListenableFuture<ClaimResult> claimDevice(TenantId tenantId, Device device, CustomerId customerId, String secretKey, User user) {
        ListenableFuture future = this.claimDevicesService.claimDevice(device, customerId, secretKey);
        return Futures.transform((ListenableFuture)future, result -> {
            if (result != null && result.getResponse().equals((Object)ClaimResponse.SUCCESS)) {
                this.logEntityActionService.logEntityAction(tenantId, (EntityId)device.getId(), (HasName)result.getDevice(), customerId, ActionType.ASSIGNED_TO_CUSTOMER, user, new Object[]{device.getId().toString(), customerId.toString(), this.customerService.findCustomerById(tenantId, customerId).getName()});
            }
            return result;
        }, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<ReclaimResult> reclaimDevice(TenantId tenantId, Device device, User user) {
        ListenableFuture future = this.claimDevicesService.reClaimDevice(tenantId, device);
        return Futures.transform((ListenableFuture)future, result -> {
            Customer unassignedCustomer = result.getUnassignedCustomer();
            if (unassignedCustomer != null) {
                this.logEntityActionService.logEntityAction(tenantId, (EntityId)device.getId(), (HasName)device, device.getCustomerId(), ActionType.UNASSIGNED_FROM_CUSTOMER, user, new Object[]{device.getId().toString(), unassignedCustomer.getId().toString(), unassignedCustomer.getName()});
            }
            return result;
        }, (Executor)MoreExecutors.directExecutor());
    }

    public Device assignDeviceToTenant(Device device, Tenant newTenant, User user) {
        ActionType actionType = ActionType.ASSIGNED_TO_TENANT;
        TenantId tenantId = device.getTenantId();
        TenantId newTenantId = newTenant.getId();
        DeviceId deviceId = device.getId();
        try {
            Device assignedDevice = this.deviceService.assignDeviceToTenant(newTenantId, device);
            this.ownersCacheService.clearOwners((EntityId)deviceId);
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)deviceId, (HasName)assignedDevice, assignedDevice.getCustomerId(), actionType, user, new Object[]{newTenantId.toString(), newTenant.getName()});
            return assignedDevice;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.DEVICE), actionType, user, e, new Object[]{deviceId.toString()});
            throw e;
        }
    }

    @ConstructorProperties(value={"deviceService", "deviceCredentialsService", "claimDevicesService", "ownersCacheService"})
    @Generated
    public DefaultTbDeviceService(DeviceService deviceService, DeviceCredentialsService deviceCredentialsService, ClaimDevicesService claimDevicesService, OwnersCacheService ownersCacheService) {
        this.deviceService = deviceService;
        this.deviceCredentialsService = deviceCredentialsService;
        this.claimDevicesService = claimDevicesService;
        this.ownersCacheService = ownersCacheService;
    }
}

