/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.dashboard;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.Dashboard;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.GroupEntity;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.dashboard.DashboardService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.dashboard.TbDashboardService;
import org.thingsboard.server.service.resource.TbResourceService;
import org.thingsboard.server.service.security.model.SecurityUser;

@Service
@TbCoreComponent
public class DefaultTbDashboardService
extends AbstractTbEntityService
implements TbDashboardService {
    private final DashboardService dashboardService;
    private final TbResourceService tbResourceService;

    public Dashboard save(Dashboard dashboard, List<EntityGroup> entityGroups, SecurityUser user) throws Exception {
        ActionType actionType = dashboard.getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        TenantId tenantId = dashboard.getTenantId();
        if (CollectionUtils.isNotEmpty((Collection)dashboard.getResources())) {
            this.tbResourceService.importResources(dashboard.getResources(), user);
        }
        try {
            Dashboard savedDashboard = (Dashboard)this.checkNotNull((Object)this.dashboardService.saveDashboard(dashboard));
            this.autoCommit((User)user, (EntityId)savedDashboard.getId());
            this.createOrUpdateGroupEntity(tenantId, (GroupEntity)savedDashboard, entityGroups, actionType, (User)user);
            return savedDashboard;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.DASHBOARD), (HasName)dashboard, actionType, (User)user, e, new Object[0]);
            throw e;
        }
    }

    public void delete(Dashboard dashboard, User user) {
        ActionType actionType = ActionType.DELETED;
        DashboardId dashboardId = dashboard.getId();
        TenantId tenantId = dashboard.getTenantId();
        try {
            this.dashboardService.deleteDashboard(tenantId, dashboardId);
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)dashboardId, (HasName)dashboard, null, actionType, user, new Object[]{dashboardId.toString()});
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.DASHBOARD), actionType, user, e, new Object[]{dashboardId.toString()});
            throw e;
        }
    }

    @ConstructorProperties(value={"dashboardService", "tbResourceService"})
    @Generated
    public DefaultTbDashboardService(DashboardService dashboardService, TbResourceService tbResourceService) {
        this.dashboardService = dashboardService;
        this.tbResourceService = tbResourceService;
    }
}

