/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.converter;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.converter.Converter;
import org.thingsboard.server.common.data.id.ConverterId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.converter.ConverterService;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.converter.TbConverterService;

@Service
public class DefaultTbConverterService
extends AbstractTbEntityService
implements TbConverterService {
    private final ConverterService converterService;

    public Converter save(Converter converter, User user) throws Exception {
        ActionType actionType = converter.getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        TenantId tenantId = converter.getTenantId();
        try {
            Converter savedConverter = (Converter)this.checkNotNull((Object)this.converterService.saveConverter(converter));
            this.autoCommit(user, (EntityId)savedConverter.getId());
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)savedConverter.getId(), (HasName)savedConverter, null, actionType, user, new Object[0]);
            return savedConverter;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.CONVERTER), (HasName)converter, actionType, user, e, new Object[0]);
            throw e;
        }
    }

    public void delete(Converter converter, User user) {
        ActionType actionType = ActionType.DELETED;
        TenantId tenantId = converter.getTenantId();
        ConverterId converterId = converter.getId();
        try {
            this.converterService.deleteConverter(tenantId, converterId);
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)converter.getId(), (HasName)converter, null, actionType, user, new Object[]{converter.getId().toString()});
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.CONVERTER), actionType, user, e, new Object[]{converterId.getId().toString()});
            throw e;
        }
    }

    @ConstructorProperties(value={"converterService"})
    @Generated
    public DefaultTbConverterService(ConverterService converterService) {
        this.converterService = converterService;
    }
}

