/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.cf;

import java.beans.ConstructorProperties;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.cf.CalculatedFieldService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.cf.CalculatedFieldReprocessingValidator;
import org.thingsboard.server.service.entitiy.cf.TbCalculatedFieldService;
import org.thingsboard.server.service.security.model.SecurityUser;

@TbCoreComponent
@Service
public class DefaultTbCalculatedFieldService
extends AbstractTbEntityService
implements TbCalculatedFieldService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbCalculatedFieldService.class);
    private final CalculatedFieldService calculatedFieldService;
    private final CalculatedFieldReprocessingValidator cfReprocessingValidator;

    public CalculatedField save(CalculatedField calculatedField, SecurityUser user) throws ThingsboardException {
        ActionType actionType = calculatedField.getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        TenantId tenantId = calculatedField.getTenantId();
        try {
            if (ActionType.UPDATED.equals((Object)actionType)) {
                CalculatedField existingCf = this.calculatedFieldService.findById(tenantId, calculatedField.getId());
                this.checkForEntityChange(existingCf, calculatedField);
            }
            this.checkEntity(tenantId, calculatedField.getEntityId(), calculatedField.getType());
            CalculatedField savedCalculatedField = (CalculatedField)this.checkNotNull((Object)this.calculatedFieldService.save(calculatedField));
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)savedCalculatedField.getId(), (HasName)savedCalculatedField, actionType, (User)user, new Object[0]);
            return savedCalculatedField;
        }
        catch (ThingsboardException e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.CALCULATED_FIELD), (HasName)calculatedField, actionType, (User)user, (Exception)((Object)e), new Object[0]);
            throw e;
        }
    }

    public CalculatedField findById(CalculatedFieldId calculatedFieldId, SecurityUser user) {
        return this.calculatedFieldService.findById(user.getTenantId(), calculatedFieldId);
    }

    public PageData<CalculatedField> findByTenantIdAndEntityId(TenantId tenantId, EntityId entityId, CalculatedFieldType type, PageLink pageLink) {
        this.checkEntity(tenantId, entityId, type);
        return this.calculatedFieldService.findCalculatedFieldsByEntityId(tenantId, entityId, type, pageLink);
    }

    @Transactional
    public void delete(CalculatedField calculatedField, User user) {
        ActionType actionType = ActionType.DELETED;
        TenantId tenantId = calculatedField.getTenantId();
        CalculatedFieldId calculatedFieldId = calculatedField.getId();
        try {
            this.calculatedFieldService.deleteCalculatedField(tenantId, calculatedFieldId);
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)calculatedFieldId, (HasName)calculatedField, actionType, user, new Object[]{calculatedFieldId.toString()});
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.CALCULATED_FIELD), actionType, user, e, new Object[]{calculatedFieldId.toString()});
            throw e;
        }
    }

    public void delete(CalculatedFieldId calculatedFieldId, User user) {
        CalculatedField calculatedField = this.calculatedFieldService.findById(user.getTenantId(), calculatedFieldId);
        this.delete(calculatedField, user);
    }

    public CalculatedFieldReprocessingValidator.CfReprocessingValidationResult validateForReprocessing(CalculatedField calculatedField) {
        return this.cfReprocessingValidator.validate(calculatedField);
    }

    private void checkForEntityChange(CalculatedField oldCalculatedField, CalculatedField newCalculatedField) {
        if (!oldCalculatedField.getEntityId().equals(newCalculatedField.getEntityId())) {
            throw new IllegalArgumentException("Changing the calculated field target entity after initialization is prohibited.");
        }
    }

    private void checkEntity(TenantId tenantId, EntityId entityId, CalculatedFieldType type) {
        EntityType entityType = entityId.getEntityType();
        Set supportedTypes = (Set)CalculatedField.SUPPORTED_ENTITIES.get(entityType);
        if (supportedTypes == null || supportedTypes.isEmpty()) {
            throw new IllegalArgumentException("Entity type '" + String.valueOf(entityType) + "' does not support calculated fields");
        }
        if (type != null && !supportedTypes.contains(type)) {
            throw new IllegalArgumentException("Entity type '" + String.valueOf(entityType) + "' does not support '" + String.valueOf(type) + "' calculated fields");
        }
        if (this.entityService.fetchEntity(tenantId, entityId).isEmpty()) {
            throw new IllegalArgumentException(entityType.getNormalName() + " with id [" + String.valueOf(entityId.getId()) + "] does not exist.");
        }
    }

    @ConstructorProperties(value={"calculatedFieldService", "cfReprocessingValidator"})
    @Generated
    public DefaultTbCalculatedFieldService(CalculatedFieldService calculatedFieldService, CalculatedFieldReprocessingValidator cfReprocessingValidator) {
        this.calculatedFieldService = calculatedFieldService;
        this.cfReprocessingValidator = cfReprocessingValidator;
    }
}

