/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.ai;

import java.beans.ConstructorProperties;
import java.util.Objects;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.ai.AiModel;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.id.AiModelId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.ai.AiModelService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.ai.TbAiModelService;

@Service
@TbCoreComponent
class DefaultTbAiModelService
extends AbstractTbEntityService
implements TbAiModelService {
    private final AiModelService aiModelService;

    public AiModel save(AiModel model, User user) {
        AiModel savedModel;
        ActionType actionType = model.getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        TenantId tenantId = user.getTenantId();
        model.setTenantId(tenantId);
        try {
            savedModel = this.aiModelService.save(model);
            this.autoCommit(user, (EntityId)savedModel.getId());
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)Objects.requireNonNullElseGet((AiModelId)model.getId(), () -> (AiModelId)this.emptyId(EntityType.AI_MODEL)), (HasName)model, actionType, user, e, new Object[0]);
            throw e;
        }
        this.logEntityActionService.logEntityAction(tenantId, (EntityId)((AiModelId)savedModel.getId()), (HasName)savedModel, actionType, user, new Object[0]);
        return savedModel;
    }

    public boolean delete(AiModel model, User user) {
        boolean deleted;
        ActionType actionType = ActionType.DELETED;
        TenantId tenantId = user.getTenantId();
        AiModelId modelId = (AiModelId)model.getId();
        try {
            deleted = this.aiModelService.deleteByTenantIdAndId(tenantId, modelId);
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)modelId, (HasName)model, actionType, user, e, new Object[]{modelId.toString()});
            throw e;
        }
        if (deleted) {
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)modelId, (HasName)model, actionType, user, new Object[]{modelId.toString()});
        }
        return deleted;
    }

    @ConstructorProperties(value={"aiModelService"})
    @Generated
    public DefaultTbAiModelService(AiModelService aiModelService) {
        this.aiModelService = aiModelService;
    }
}

