/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.user;

import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.util.Pair;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.HasVersion;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.id.UserCredentialsId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.security.UserCredentials;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.dao.service.DataValidator;
import org.thingsboard.server.gen.edge.v1.UserCredentialsUpdateMsg;
import org.thingsboard.server.gen.edge.v1.UserUpdateMsg;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;
import org.thingsboard.server.service.security.permission.UserPermissionsService;

public abstract class BaseUserProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseUserProcessor.class);
    @Autowired
    private UserPermissionsService userPermissionsService;
    @Autowired
    private DataValidator<User> userValidator;

    protected Pair<Boolean, Boolean> saveOrUpdateUser(TenantId tenantId, UserId userId, UserUpdateMsg userUpdateMsg) {
        boolean isCreated = false;
        boolean userEmailUpdated = false;
        try {
            User user = (User)JacksonUtil.fromString((String)userUpdateMsg.getEntity(), User.class, (boolean)true);
            if (user == null) {
                throw new IllegalArgumentException(String.format("[%s] Failed to parse User from UserUpdateMsg: %s", tenantId, userUpdateMsg));
            }
            User userById = this.edgeCtx.getUserService().findUserById(tenantId, userId);
            if (userById == null) {
                isCreated = true;
                user.setId(null);
            } else {
                this.changeOwnerIfRequired(tenantId, user.getCustomerId(), (EntityId)userById.getId());
                user.setId((UUIDBased)userId);
            }
            if (this.isSaveRequired((HasVersion)userById, (HasVersion)user)) {
                userEmailUpdated = this.updateUserEmailIfDuplicateExists(tenantId, userId, user);
                this.setCustomerId(tenantId, isCreated ? null : userById.getCustomerId(), user, userUpdateMsg);
                this.userValidator.validate((BaseData)user, User::getTenantId);
                if (isCreated) {
                    user.setId((UUIDBased)userId);
                }
                User savedUser = this.edgeCtx.getUserService().saveUser(tenantId, user, false);
                if (isCreated) {
                    this.edgeCtx.getEntityGroupService().addEntityToEntityGroupAll(savedUser.getTenantId(), savedUser.getOwnerId(), (EntityId)savedUser.getId());
                }
                this.userPermissionsService.onUserUpdatedOrRemoved(savedUser);
            }
            this.safeAddToEntityGroup(tenantId, userUpdateMsg, userId);
        }
        catch (Exception e) {
            log.error("[{}] Failed to process user update msg [{}]", new Object[]{tenantId, userUpdateMsg, e});
            throw new RuntimeException(e);
        }
        return Pair.of((Object)isCreated, (Object)userEmailUpdated);
    }

    private void safeAddToEntityGroup(TenantId tenantId, UserUpdateMsg userUpdateMsg, UserId userId) {
        if (userUpdateMsg.hasEntityGroupIdMSB() && userUpdateMsg.hasEntityGroupIdLSB()) {
            UUID entityGroupUUID = this.safeGetUUID(userUpdateMsg.getEntityGroupIdMSB(), userUpdateMsg.getEntityGroupIdLSB());
            this.safeAddEntityToGroup(tenantId, new EntityGroupId(entityGroupUUID), (EntityId)userId);
        }
    }

    private boolean updateUserEmailIfDuplicateExists(TenantId tenantId, UserId userId, User user) {
        String email = user.getEmail();
        User userByEmail = this.edgeCtx.getUserService().findUserByTenantIdAndEmail(tenantId, email);
        if (userByEmail != null && !userByEmail.getId().equals((Object)user.getId())) {
            String[] splitEmail = email.split("@");
            String newEmail = splitEmail[0] + "_" + StringUtils.randomAlphanumeric((int)15) + "@" + splitEmail[1];
            log.warn("[{}] User with email {} already exists. Renaming User email to {}", new Object[]{tenantId, user.getEmail(), newEmail});
            user.setEmail(newEmail);
            return true;
        }
        return false;
    }

    protected void deleteUserAndPushEntityDeletedEventToRuleEngine(TenantId tenantId, UserId userId) throws ThingsboardException {
        this.deleteUserAndPushEntityDeletedEventToRuleEngine(tenantId, userId, null);
    }

    protected void deleteUserAndPushEntityDeletedEventToRuleEngine(TenantId tenantId, UserId userId, Edge edge) throws ThingsboardException {
        User removedUser = this.deleteUser(tenantId, userId);
        if (removedUser == null) {
            return;
        }
        CustomerId userCustomerId = removedUser.getCustomerId();
        String userAsString = JacksonUtil.toString((Object)removedUser);
        TbMsgMetaData msgMetaData = edge == null ? new TbMsgMetaData() : this.getEdgeActionTbMsgMetaData(edge, userCustomerId);
        this.addRemovedUserMetadata(msgMetaData, removedUser);
        this.pushEntityEventToRuleEngine(tenantId, (EntityId)userId, userCustomerId, TbMsgType.ENTITY_DELETED, userAsString, msgMetaData);
    }

    private User deleteUser(TenantId tenantId, UserId userId) throws ThingsboardException {
        User userById = this.edgeCtx.getUserService().findUserById(tenantId, userId);
        if (userById == null) {
            log.trace("[{}] User with id {} does not exist", (Object)tenantId, (Object)userId);
            return null;
        }
        this.edgeCtx.getUserService().deleteUser(tenantId, userById);
        this.userPermissionsService.onUserUpdatedOrRemoved(userById);
        return userById;
    }

    protected void updateUserCredentials(TenantId tenantId, UserCredentialsUpdateMsg updateMsg) {
        UserCredentials userCredentials = (UserCredentials)JacksonUtil.fromString((String)updateMsg.getEntity(), UserCredentials.class, (boolean)true);
        if (userCredentials == null) {
            throw new IllegalArgumentException(String.format("[%s] Failed to parse UserCredentials from updateMsg: %s", tenantId, updateMsg));
        }
        User user = this.edgeCtx.getUserService().findUserById(tenantId, userCredentials.getUserId());
        if (user == null) {
            log.warn("[{}] Can't find user by id [{}] skipping credentials update. UserCredentialsUpdateMsg [{}]", new Object[]{tenantId, userCredentials.getUserId(), updateMsg});
            return;
        }
        log.debug("[{}] Updating user credentials for user [{}]. New credentials Id [{}], enabled [{}]", new Object[]{tenantId, user.getName(), userCredentials.getId(), userCredentials.isEnabled()});
        try {
            UserCredentials userCredentialsByUserId = this.edgeCtx.getUserService().findUserCredentialsByUserId(tenantId, user.getId());
            if (userCredentialsByUserId != null && !((UserCredentialsId)userCredentialsByUserId.getId()).equals((Object)userCredentials.getId())) {
                this.edgeCtx.getUserService().deleteUserCredentials(tenantId, userCredentialsByUserId);
            }
            this.edgeCtx.getUserService().saveUserCredentials(tenantId, userCredentials, false);
        }
        catch (Exception e) {
            log.error("[{}] Can't update user credentials for user [{}], userCredentialsUpdateMsg [{}]", new Object[]{tenantId, user.getName(), updateMsg, e});
            throw new RuntimeException(e);
        }
    }

    private void addRemovedUserMetadata(TbMsgMetaData metaData, User removedUser) {
        metaData.putValue("userId", removedUser.getId().toString());
        metaData.putValue("userName", removedUser.getName());
        metaData.putValue("userEmail", removedUser.getEmail());
        if (removedUser.getFirstName() != null) {
            metaData.putValue("userFirstName", removedUser.getFirstName());
        }
        if (removedUser.getLastName() != null) {
            metaData.putValue("userLastName", removedUser.getLastName());
        }
    }

    protected abstract void setCustomerId(TenantId var1, CustomerId var2, User var3, UserUpdateMsg var4);
}

