/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.telemetry;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.notification.rule.trigger.EdgeCommunicationFailureTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.NotificationRuleTrigger;
import org.thingsboard.server.common.msg.notification.NotificationRuleProcessor;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EntityDataProto;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.rpc.processor.telemetry.BaseTelemetryProcessor;

@Component
@TbCoreComponent
public class TelemetryEdgeProcessor
extends BaseTelemetryProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TelemetryEdgeProcessor.class);
    @Value(value="${edges.rpc.max_telemetry_message_size:0}")
    private int maxTelemetryMessageSize;
    @Lazy
    @Autowired
    private NotificationRuleProcessor notificationRuleProcessor;

    protected String getMsgSourceKey() {
        return "edge";
    }

    public DownlinkMsg convertTelemetryEventToDownlink(Edge edge, EdgeEvent edgeEvent) {
        if (edgeEvent.getBody() != null) {
            String bodyStr = edgeEvent.getBody().toString();
            if (this.maxTelemetryMessageSize > 0 && bodyStr.length() > this.maxTelemetryMessageSize) {
                String error = "Conversion to a DownlinkMsg telemetry event failed due to a size limit violation.";
                String message = String.format("%s Current size is %s, but the limit is %s", error, bodyStr.length(), this.maxTelemetryMessageSize);
                log.debug("[{}][{}][{}] {}. {}", new Object[]{edgeEvent.getTenantId(), edgeEvent.getEdgeId(), edgeEvent.getEntityId(), message, StringUtils.truncate((String)bodyStr, (int)100)});
                this.notificationRuleProcessor.process((NotificationRuleTrigger)EdgeCommunicationFailureTrigger.builder().tenantId(edgeEvent.getTenantId()).edgeId(edgeEvent.getEdgeId()).customerId(edge.getCustomerId()).edgeName(edge.getName()).failureMsg(message).error(error).build());
                return null;
            }
        }
        EntityType entityType = EntityType.valueOf((String)edgeEvent.getType().name());
        EntityDataProto entityDataProto = this.convertTelemetryEventToEntityDataProto(edgeEvent.getTenantId(), entityType, edgeEvent.getEntityId(), edgeEvent.getAction(), edgeEvent.getBody());
        return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addEntityData(entityDataProto).build();
    }
}

