/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.scheduler;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.SchedulerEventId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.scheduler.SchedulerEvent;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.exception.DataValidationException;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.SchedulerEventUpdateMsg;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.scheduler.BaseSchedulerEventProcessor;
import org.thingsboard.server.service.edge.rpc.processor.scheduler.SchedulerEventEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.scheduler.SchedulerEventProcessor;

@Component
@TbCoreComponent
public class SchedulerEventEdgeProcessor
extends BaseSchedulerEventProcessor
implements SchedulerEventProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchedulerEventEdgeProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> processSchedulerEventMsgFromEdge(TenantId tenantId, Edge edge, SchedulerEventUpdateMsg schedulerEventUpdateMsg) {
        log.trace("[{}] executing processSchedulerEventMsgFromEdge [{}] from edge [{}]", new Object[]{tenantId, schedulerEventUpdateMsg, edge.getId()});
        SchedulerEventId schedulerEventId = new SchedulerEventId(new UUID(schedulerEventUpdateMsg.getIdMSB(), schedulerEventUpdateMsg.getIdLSB()));
        try {
            ListenableFuture schedulerEventToDelete;
            this.edgeSynchronizationManager.getEdgeId().set(edge.getId());
            schedulerEventToDelete = switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[schedulerEventUpdateMsg.getMsgType().ordinal()]) {
                case 1, 2 -> {
                    this.saveOrUpdateSchedulerEvent(tenantId, schedulerEventId, schedulerEventUpdateMsg, edge);
                    yield Futures.immediateFuture(null);
                }
                case 3 -> {
                    schedulerEventToDelete = this.edgeCtx.getSchedulerEventService().findSchedulerEventById(tenantId, schedulerEventId);
                    if (schedulerEventToDelete != null) {
                        this.edgeCtx.getSchedulerEventService().unassignSchedulerEventFromEdge(tenantId, schedulerEventId, edge.getId());
                    }
                    yield Futures.immediateFuture(null);
                }
                default -> this.handleUnsupportedMsgType(schedulerEventUpdateMsg.getMsgType());
            };
            return schedulerEventToDelete;
        }
        catch (DataValidationException e) {
            log.warn("[{}] Failed to process SchedulerEventUpdateMsg from Edge [{}]", new Object[]{tenantId, schedulerEventUpdateMsg, e});
            ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)e);
            return listenableFuture;
        }
        finally {
            this.edgeSynchronizationManager.getEdgeId().remove();
        }
    }

    private void saveOrUpdateSchedulerEvent(TenantId tenantId, SchedulerEventId schedulerEventId, SchedulerEventUpdateMsg schedulerEventUpdateMsg, Edge edge) {
        Boolean created = super.saveOrUpdateSchedulerEvent(tenantId, schedulerEventId, schedulerEventUpdateMsg);
        if (created.booleanValue()) {
            this.createRelationFromEdge(tenantId, edge.getId(), (EntityId)schedulerEventId);
            this.pushSchedulerEventCreatedEventToRuleEngine(tenantId, edge, schedulerEventId);
            this.edgeCtx.getSchedulerEventService().assignSchedulerEventToEdge(tenantId, schedulerEventId, edge.getId());
        }
    }

    private void pushSchedulerEventCreatedEventToRuleEngine(TenantId tenantId, Edge edge, SchedulerEventId schedulerEventId) {
        try {
            SchedulerEvent schedulerEvent = this.edgeCtx.getSchedulerEventService().findSchedulerEventById(tenantId, schedulerEventId);
            String schedulerEventAsString = JacksonUtil.toString((Object)schedulerEvent);
            TbMsgMetaData msgMetaData = this.getEdgeActionTbMsgMetaData(edge, null);
            this.pushEntityEventToRuleEngine(tenantId, (EntityId)schedulerEventId, null, TbMsgType.ENTITY_CREATED, schedulerEventAsString, msgMetaData);
        }
        catch (Exception e) {
            log.warn("[{}][{}] Failed to push scheduler event action to rule engine: {}", new Object[]{tenantId, schedulerEventId, TbMsgType.ENTITY_CREATED.name(), e});
        }
    }

    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        SchedulerEventId schedulerEventId = new SchedulerEventId(edgeEvent.getEntityId());
        switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[edgeEvent.getAction().ordinal()]) {
            case 1: 
            case 2: {
                SchedulerEvent schedulerEvent = this.edgeCtx.getSchedulerEventService().findSchedulerEventById(edgeEvent.getTenantId(), schedulerEventId);
                if (schedulerEvent == null) break;
                UpdateMsgType msgType = this.getUpdateMsgType(edgeEvent.getAction());
                SchedulerEventUpdateMsg schedulerEventUpdateMsg = EdgeMsgConstructorUtils.constructSchedulerEventUpdatedMsg((UpdateMsgType)msgType, (SchedulerEvent)schedulerEvent);
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addSchedulerEventUpdateMsg(schedulerEventUpdateMsg).build();
            }
            case 3: 
            case 4: {
                SchedulerEventUpdateMsg schedulerEventUpdateMsg = EdgeMsgConstructorUtils.constructSchedulerEventDeleteMsg((SchedulerEventId)schedulerEventId);
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addSchedulerEventUpdateMsg(schedulerEventUpdateMsg).build();
            }
        }
        return null;
    }

    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.SCHEDULER_EVENT;
    }

    protected boolean isEnabledDuringCreation() {
        return false;
    }

    protected void setCustomerId(TenantId tenantId, CustomerId customerId, SchedulerEvent schedulerEvent) {
    }
}

