/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.report;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.ReportTemplateId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.report.BaseReportTemplate;
import org.thingsboard.server.common.data.report.ReportTemplate;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.dao.service.DataValidator;
import org.thingsboard.server.gen.edge.v1.ReportTemplateUpdateMsg;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

public abstract class BaseReportTemplateProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseReportTemplateProcessor.class);
    @Autowired
    private DataValidator<ReportTemplate> reportTemplateDataValidator;

    protected Boolean saveOrUpdateReportTemplate(TenantId tenantId, ReportTemplateId reportTemplateId, ReportTemplateUpdateMsg reportTemplateUpdateMsg) {
        boolean created = false;
        try {
            ReportTemplate reportTemplate = (ReportTemplate)JacksonUtil.fromString((String)reportTemplateUpdateMsg.getEntity(), ReportTemplate.class, (boolean)true);
            if (reportTemplate == null) {
                throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] reportTemplateUpdateMsg {" + String.valueOf(reportTemplateUpdateMsg) + "} cannot be converted to report template");
            }
            ReportTemplate reportTemplateById = this.edgeCtx.getReportTemplateService().findReportTemplateById(tenantId, reportTemplateId);
            if (reportTemplateById == null) {
                created = true;
                reportTemplate.setId(null);
            }
            this.reportTemplateDataValidator.validate((BaseData)reportTemplate, BaseReportTemplate::getTenantId);
            if (created) {
                reportTemplate.setId((UUIDBased)reportTemplateId);
            }
            this.edgeCtx.getReportTemplateService().saveReportTemplate(reportTemplate, false);
        }
        catch (Exception e) {
            log.error("[{}] Failed to process report template update msg [{}]", new Object[]{tenantId, reportTemplateUpdateMsg, e});
            throw e;
        }
        return created;
    }

    protected void deleteReportTemplate(TenantId tenantId, ReportTemplateId reportTemplateId) {
        ReportTemplate reportTemplateToDelete = this.edgeCtx.getReportTemplateService().findReportTemplateById(tenantId, reportTemplateId);
        if (reportTemplateToDelete != null) {
            this.edgeCtx.getReportTemplateService().deleteReportTemplate(tenantId, reportTemplateId);
            this.pushReportTemplateDeletedEventToRuleEngine(tenantId, reportTemplateToDelete);
        }
    }

    protected void pushReportTemplateDeletedEventToRuleEngine(TenantId tenantId, ReportTemplate reportTemplate) {
        this.pushReportTemplateEventToRuleEngine(tenantId, reportTemplate, TbMsgType.ENTITY_DELETED);
    }

    protected void pushReportTemplateEventToRuleEngine(TenantId tenantId, ReportTemplate reportTemplate, TbMsgType msgType) {
        this.pushReportTemplateEventToRuleEngine(tenantId, null, reportTemplate, msgType);
    }

    protected void pushReportTemplateEventToRuleEngine(TenantId tenantId, Edge edge, ReportTemplate reportTemplate, TbMsgType msgType) {
        try {
            CustomerId customerId = reportTemplate.getCustomerId();
            String reportTemplateAsString = JacksonUtil.toString((Object)reportTemplate);
            TbMsgMetaData tbMsgMetaData = edge == null ? new TbMsgMetaData() : this.getEdgeActionTbMsgMetaData(edge, customerId);
            this.pushEntityEventToRuleEngine(tenantId, (EntityId)reportTemplate.getId(), customerId, msgType, reportTemplateAsString, tbMsgMetaData);
        }
        catch (Exception e) {
            log.warn("[{}][{}] Failed to push report template action to rule engine: {}", new Object[]{tenantId, reportTemplate.getId(), msgType.name(), e});
        }
    }
}

