/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.relation;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.RelationUpdateMsg;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.relation.BaseRelationProcessor;
import org.thingsboard.server.service.edge.rpc.processor.relation.RelationProcessor;

@Component
@TbCoreComponent
public class RelationEdgeProcessor
extends BaseRelationProcessor
implements RelationProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RelationEdgeProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> processRelationMsgFromEdge(TenantId tenantId, Edge edge, RelationUpdateMsg relationUpdateMsg) {
        log.trace("[{}] executing processRelationMsgFromEdge [{}] from edge [{}]", new Object[]{tenantId, relationUpdateMsg, edge.getId()});
        try {
            this.edgeSynchronizationManager.getEdgeId().set(edge.getId());
            ListenableFuture listenableFuture = this.processRelationMsg(tenantId, relationUpdateMsg);
            return listenableFuture;
        }
        finally {
            this.edgeSynchronizationManager.getEdgeId().remove();
        }
    }

    public ListenableFuture<Void> processEntityNotification(TenantId tenantId, TransportProtos.EdgeNotificationMsgProto edgeNotificationMsg) {
        EntityRelation relation = (EntityRelation)JacksonUtil.fromString((String)edgeNotificationMsg.getBody(), EntityRelation.class);
        if (relation == null) {
            return Futures.immediateFuture(null);
        }
        EdgeId originatorEdgeId = this.safeGetEdgeId(edgeNotificationMsg.getOriginatorEdgeIdMSB(), edgeNotificationMsg.getOriginatorEdgeIdLSB());
        HashSet uniqueEdgeIds = new HashSet();
        uniqueEdgeIds.addAll(this.edgeCtx.getEdgeService().findAllRelatedEdgeIds(tenantId, relation.getTo()));
        uniqueEdgeIds.addAll(this.edgeCtx.getEdgeService().findAllRelatedEdgeIds(tenantId, relation.getFrom()));
        uniqueEdgeIds.remove(originatorEdgeId);
        if (uniqueEdgeIds.isEmpty()) {
            return Futures.immediateFuture(null);
        }
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        for (EdgeId edgeId : uniqueEdgeIds) {
            futures.add(this.saveEdgeEvent(tenantId, edgeId, EdgeEventType.RELATION, EdgeEventActionType.valueOf((String)edgeNotificationMsg.getAction()), null, JacksonUtil.valueToTree((Object)relation)));
        }
        return Futures.transform((ListenableFuture)Futures.allAsList(futures), voids -> null, (Executor)this.dbCallbackExecutorService);
    }

    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        EntityRelation entityRelation = (EntityRelation)JacksonUtil.convertValue((Object)edgeEvent.getBody(), EntityRelation.class);
        UpdateMsgType msgType = this.getUpdateMsgType(edgeEvent.getAction());
        RelationUpdateMsg relationUpdateMsg = EdgeMsgConstructorUtils.constructRelationUpdatedMsg((UpdateMsgType)msgType, (EntityRelation)entityRelation);
        return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addRelationUpdateMsg(relationUpdateMsg).build();
    }

    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.RELATION;
    }
}

