/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.menu;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.EntityInfo;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.menu.CustomMenu;
import org.thingsboard.server.common.data.menu.CustomMenuInfo;
import org.thingsboard.server.dao.menu.CustomMenuService;
import org.thingsboard.server.gen.edge.v1.CustomMenuProto;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.menu.CustomMenuEdgeProcessor;

@Component
@TbCoreComponent
public class CustomMenuEdgeProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomMenuEdgeProcessor.class);
    @Autowired
    private CustomMenuService customMenuService;

    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        CustomMenu customMenu = (CustomMenu)JacksonUtil.convertValue((Object)edgeEvent.getBody(), CustomMenu.class);
        if (customMenu == null) {
            return null;
        }
        try {
            UpdateMsgType msgType = this.getUpdateMsgType(edgeEvent.getAction());
            CustomMenuProto customMenuProto = null;
            switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[edgeEvent.getAction().ordinal()]) {
                case 1: 
                case 2: {
                    List<EntityId> entityIds = this.customMenuService.findCustomMenuAssigneeList((CustomMenuInfo)customMenu).stream().map(EntityInfo::getId).toList();
                    customMenuProto = EdgeMsgConstructorUtils.constructCustomMenuMsg((UpdateMsgType)msgType, (CustomMenu)customMenu, entityIds);
                    break;
                }
                case 3: {
                    customMenuProto = EdgeMsgConstructorUtils.constructCustomMenuMsg((UpdateMsgType)msgType, (CustomMenu)customMenu, null);
                }
            }
            return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).setCustomMenuProto(customMenuProto).build();
        }
        catch (Exception e) {
            log.error("Error processing custom menu for edgeEvent [{}]", (Object)edgeEvent, (Object)e);
            return null;
        }
    }

    public ListenableFuture<Void> processEntityNotification(TenantId tenantId, TransportProtos.EdgeNotificationMsgProto edgeNotificationMsg) {
        EdgeEventType type = EdgeEventType.valueOf((String)edgeNotificationMsg.getType());
        EntityId entityId = EntityIdFactory.getByEdgeEventTypeAndUuid((EdgeEventType)EdgeEventType.valueOf((String)edgeNotificationMsg.getEntityType()), (UUID)new UUID(edgeNotificationMsg.getEntityIdMSB(), edgeNotificationMsg.getEntityIdLSB()));
        EdgeId sourceEdgeId = this.safeGetEdgeId(edgeNotificationMsg.getOriginatorEdgeIdMSB(), edgeNotificationMsg.getOriginatorEdgeIdLSB());
        EdgeEventActionType actionType = EdgeEventActionType.valueOf((String)edgeNotificationMsg.getAction());
        return this.processActionForAllEdges(tenantId, type, actionType, entityId, JacksonUtil.toJsonNode((String)edgeNotificationMsg.getBody()), sourceEdgeId);
    }

    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.CUSTOM_MENU;
    }
}

