/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.group;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.GroupPermissionId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.common.data.permission.GroupPermission;
import org.thingsboard.server.dao.grouppermission.GroupPermissionService;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.group.GroupPermissionsEdgeProcessor;

@Component
@TbCoreComponent
public class GroupPermissionsEdgeProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GroupPermissionsEdgeProcessor.class);
    @Autowired
    protected GroupPermissionService groupPermissionService;

    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        GroupPermissionId groupPermissionId = new GroupPermissionId(edgeEvent.getEntityId());
        DownlinkMsg downlinkMsg = null;
        UpdateMsgType msgType = this.getUpdateMsgType(edgeEvent.getAction());
        switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[msgType.ordinal()]) {
            case 1: 
            case 2: {
                GroupPermission groupPermission = this.groupPermissionService.findGroupPermissionById(edgeEvent.getTenantId(), groupPermissionId);
                if (groupPermission == null) break;
                downlinkMsg = DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addGroupPermissionMsg(EdgeMsgConstructorUtils.constructGroupPermissionProto((UpdateMsgType)msgType, (GroupPermission)groupPermission)).build();
                break;
            }
            case 3: {
                downlinkMsg = DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addGroupPermissionMsg(EdgeMsgConstructorUtils.constructGroupPermissionDeleteMsg((GroupPermissionId)groupPermissionId)).build();
            }
        }
        return downlinkMsg;
    }

    public ListenableFuture<Void> processEntityNotification(TenantId tenantId, TransportProtos.EdgeNotificationMsgProto edgeNotificationMsg) {
        EdgeEventActionType actionType = EdgeEventActionType.valueOf((String)edgeNotificationMsg.getAction());
        EdgeEventType type = EdgeEventType.valueOf((String)edgeNotificationMsg.getType());
        EntityId entityId = EntityIdFactory.getByEdgeEventTypeAndUuid((EdgeEventType)type, (UUID)new UUID(edgeNotificationMsg.getEntityIdMSB(), edgeNotificationMsg.getEntityIdLSB()));
        EdgeId originatorEdgeId = this.safeGetEdgeId(edgeNotificationMsg.getOriginatorEdgeIdMSB(), edgeNotificationMsg.getOriginatorEdgeIdLSB());
        return switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[actionType.ordinal()]) {
            case 1, 2 -> {
                ListenableFuture gpFuture = this.groupPermissionService.findGroupPermissionByIdAsync(tenantId, new GroupPermissionId(entityId.getId()));
                yield Futures.transformAsync((ListenableFuture)gpFuture, groupPermission -> {
                    if (groupPermission == null) {
                        return Futures.immediateFuture(null);
                    }
                    ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
                    PageDataIterable edgeIds = new PageDataIterable(link -> this.edgeCtx.getEdgeService().findRelatedEdgeIdsByEntityId(tenantId, (EntityId)groupPermission.getUserGroupId(), EntityType.USER, link), 1024);
                    for (EdgeId edgeId : edgeIds) {
                        EntityType entityGroupType = groupPermission.getEntityGroupType();
                        EntityGroupId targetGroupId = entityGroupType == null ? groupPermission.getUserGroupId() : groupPermission.getEntityGroupId();
                        EntityType targetGroupType = entityGroupType == null ? EntityType.USER : entityGroupType;
                        ListenableFuture checkFuture = this.edgeCtx.getEntityGroupService().checkEntityGroupAssignedToEdgeAsync(tenantId, edgeId, targetGroupId, targetGroupType);
                        futures.add(Futures.transformAsync((ListenableFuture)checkFuture, exists -> {
                            if (Boolean.TRUE.equals(exists)) {
                                return this.saveEdgeEvent(tenantId, edgeId, type, actionType, entityId, null);
                            }
                            return Futures.immediateFuture(null);
                        }, (Executor)this.dbCallbackExecutorService));
                    }
                    return Futures.transform((ListenableFuture)Futures.allAsList(futures), voids -> null, (Executor)this.dbCallbackExecutorService);
                }, (Executor)this.dbCallbackExecutorService);
            }
            case 3 -> this.processActionForAllEdges(tenantId, type, actionType, entityId, null, originatorEdgeId);
            default -> Futures.immediateFuture(null);
        };
    }

    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.GROUP_PERMISSION;
    }
}

