/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.entityview;

import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.util.Pair;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.EntityView;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasVersion;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityViewId;
import org.thingsboard.server.common.data.id.HasId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.dao.service.DataValidator;
import org.thingsboard.server.gen.edge.v1.EntityViewUpdateMsg;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

public abstract class BaseEntityViewProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseEntityViewProcessor.class);
    @Autowired
    private DataValidator<EntityView> entityViewValidator;

    protected Pair<Boolean, Boolean> saveOrUpdateEntityView(TenantId tenantId, EntityViewId entityViewId, EntityViewUpdateMsg entityViewUpdateMsg) throws ThingsboardException {
        boolean created = false;
        boolean entityViewNameUpdated = false;
        EntityView entityView = (EntityView)JacksonUtil.fromString((String)entityViewUpdateMsg.getEntity(), EntityView.class, (boolean)true);
        if (entityView == null) {
            throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] entityViewUpdateMsg {" + String.valueOf(entityViewUpdateMsg) + "} cannot be converted to entity view");
        }
        EntityView entityViewById = this.edgeCtx.getEntityViewService().findEntityViewById(tenantId, entityViewId);
        if (entityViewById == null) {
            created = true;
            entityView.setId(null);
        } else {
            entityView.setId((UUIDBased)entityViewId);
            this.changeOwnerIfRequired(tenantId, entityViewById.getCustomerId(), (EntityId)entityViewId);
        }
        if (this.isSaveRequired((HasVersion)entityViewById, (HasVersion)entityView)) {
            entityViewNameUpdated = this.updateEntityViewNameIfDuplicateExists(tenantId, entityViewId, entityView);
            this.setCustomerId(tenantId, created ? null : entityViewById.getCustomerId(), entityView, entityViewUpdateMsg);
            this.entityViewValidator.validate((BaseData)entityView, EntityView::getTenantId);
            if (created) {
                entityView.setId((UUIDBased)entityViewId);
            }
            EntityView savedEntityView = this.edgeCtx.getEntityViewService().saveEntityView(entityView, false);
            if (created) {
                this.edgeCtx.getEntityGroupService().addEntityToEntityGroupAll(savedEntityView.getTenantId(), savedEntityView.getOwnerId(), (EntityId)savedEntityView.getId());
            }
        }
        this.safeAddToEntityGroup(tenantId, entityViewUpdateMsg, entityViewId);
        return Pair.of((Object)created, (Object)entityViewNameUpdated);
    }

    private void safeAddToEntityGroup(TenantId tenantId, EntityViewUpdateMsg entityViewUpdateMsg, EntityViewId entityViewId) {
        if (entityViewUpdateMsg.hasEntityGroupIdMSB() && entityViewUpdateMsg.hasEntityGroupIdLSB()) {
            UUID entityGroupUUID = this.safeGetUUID(entityViewUpdateMsg.getEntityGroupIdMSB(), entityViewUpdateMsg.getEntityGroupIdLSB());
            this.safeAddEntityToGroup(tenantId, new EntityGroupId(entityGroupUUID), (EntityId)entityViewId);
        }
    }

    private boolean updateEntityViewNameIfDuplicateExists(TenantId tenantId, EntityViewId entityViewId, EntityView entityView) {
        EntityView entityViewByName = this.edgeCtx.getEntityViewService().findEntityViewByTenantIdAndName(tenantId, entityView.getName());
        return this.generateUniqueNameIfDuplicateExists(tenantId, (EntityId)entityViewId, (HasName)entityView, (HasName)entityViewByName).map(uniqueName -> {
            entityView.setName(uniqueName);
            return true;
        }).orElse(false);
    }

    protected abstract void setCustomerId(TenantId var1, CustomerId var2, EntityView var3, EntityViewUpdateMsg var4);

    protected void deleteEntityView(TenantId tenantId, EntityViewId entityViewId) {
        this.deleteEntityView(tenantId, null, entityViewId);
    }

    protected void deleteEntityView(TenantId tenantId, Edge edge, EntityViewId entityViewId) {
        EntityView entityViewById = this.edgeCtx.getEntityViewService().findEntityViewById(tenantId, entityViewId);
        if (entityViewById != null) {
            this.edgeCtx.getEntityViewService().deleteEntityView(tenantId, entityViewId);
            this.pushEntityEventToRuleEngine(tenantId, edge, (HasId)entityViewById, TbMsgType.ENTITY_DELETED);
        }
    }
}

