/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.ek;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.encryptionkey.EncryptionKey;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.EncryptionKeyUpdateMsg;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

@Component
@TbCoreComponent
public class EncryptionKeyEdgeProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EncryptionKeyEdgeProcessor.class);

    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        if (EdgeEventActionType.ADDED.equals((Object)edgeEvent.getAction())) {
            EncryptionKey encryptionKey = this.edgeCtx.getEncryptionService().findByTenantId(edgeEvent.getTenantId());
            if (encryptionKey != null) {
                UpdateMsgType msgType = this.getUpdateMsgType(edgeEvent.getAction());
                EncryptionKeyUpdateMsg encryptionKeyUpdateMsg = EdgeMsgConstructorUtils.constructEncryptionKeyUpdatedMsg((UpdateMsgType)msgType, (EncryptionKey)encryptionKey);
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addEncryptionKeyUpdateMsg(encryptionKeyUpdateMsg).build();
            }
            log.warn("EncryptionKey not found for tenantId: {}", (Object)edgeEvent.getTenantId());
        }
        return null;
    }

    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.ENCRYPTION_KEY;
    }
}

