/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.device;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.edge.rpc.EdgeVersionComparator;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.HasOwnerId;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.HasId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.rpc.RpcError;
import org.thingsboard.server.common.data.security.DeviceCredentials;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgDataType;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.common.msg.ToDeviceActorNotificationMsg;
import org.thingsboard.server.common.msg.rpc.FromDeviceRpcResponse;
import org.thingsboard.server.common.msg.rpc.FromDeviceRpcResponseActorMsg;
import org.thingsboard.server.exception.DataValidationException;
import org.thingsboard.server.gen.edge.v1.DeviceCredentialsUpdateMsg;
import org.thingsboard.server.gen.edge.v1.DeviceRpcCallMsg;
import org.thingsboard.server.gen.edge.v1.DeviceUpdateMsg;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.device.BaseDeviceProcessor;
import org.thingsboard.server.service.edge.rpc.processor.device.DeviceEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.device.DeviceProcessor;

@Component
@TbCoreComponent
public class DeviceEdgeProcessor
extends BaseDeviceProcessor
implements DeviceProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceEdgeProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> processDeviceMsgFromEdge(TenantId tenantId, Edge edge, DeviceUpdateMsg deviceUpdateMsg, EdgeVersion edgeVersion) {
        log.trace("[{}] executing processDeviceMsgFromEdge [{}] from edge [{}]", new Object[]{tenantId, deviceUpdateMsg, edge.getId()});
        DeviceId deviceId = new DeviceId(new UUID(deviceUpdateMsg.getIdMSB(), deviceUpdateMsg.getIdLSB()));
        try {
            ListenableFuture entityGroupId;
            this.edgeSynchronizationManager.getEdgeId().set(edge.getId());
            entityGroupId = switch (3.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[deviceUpdateMsg.getMsgType().ordinal()]) {
                case 1, 2 -> {
                    this.saveOrUpdateDevice(tenantId, deviceId, deviceUpdateMsg, edge);
                    yield Futures.immediateFuture(null);
                }
                case 3 -> {
                    if (deviceUpdateMsg.hasEntityGroupIdMSB() && deviceUpdateMsg.hasEntityGroupIdLSB()) {
                        entityGroupId = new EntityGroupId(new UUID(deviceUpdateMsg.getEntityGroupIdMSB(), deviceUpdateMsg.getEntityGroupIdLSB()));
                        this.edgeCtx.getEntityGroupService().removeEntityFromEntityGroup(tenantId, (EntityGroupId)entityGroupId, (EntityId)deviceId);
                    } else if (EdgeVersionComparator.INSTANCE.compare(edgeVersion, EdgeVersion.V_4_3_0) >= 0) {
                        this.deleteDevice(tenantId, edge, deviceId);
                    } else {
                        this.removeDeviceFromEdgeAllDeviceGroup(tenantId, edge, deviceId);
                    }
                    yield Futures.immediateFuture(null);
                }
                default -> this.handleUnsupportedMsgType(deviceUpdateMsg.getMsgType());
            };
            return entityGroupId;
        }
        catch (ThingsboardException | DataValidationException e) {
            if (e.getMessage().contains("limit reached")) {
                log.warn("[{}] Number of allowed devices violated {}", new Object[]{tenantId, deviceUpdateMsg, e});
                ListenableFuture listenableFuture = Futures.immediateFuture(null);
                return listenableFuture;
            }
            ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)e);
            return listenableFuture;
        }
        finally {
            this.edgeSynchronizationManager.getEdgeId().remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> processDeviceCredentialsMsgFromEdge(TenantId tenantId, EdgeId edgeId, DeviceCredentialsUpdateMsg deviceCredentialsUpdateMsg) {
        log.debug("[{}] Executing processDeviceCredentialsMsgFromEdge, deviceCredentialsUpdateMsg [{}]", (Object)tenantId, (Object)deviceCredentialsUpdateMsg);
        try {
            this.edgeSynchronizationManager.getEdgeId().set(edgeId);
            this.updateDeviceCredentials(tenantId, deviceCredentialsUpdateMsg);
        }
        finally {
            this.edgeSynchronizationManager.getEdgeId().remove();
        }
        return Futures.immediateFuture(null);
    }

    private void removeDeviceFromEdgeAllDeviceGroup(TenantId tenantId, Edge edge, DeviceId deviceId) {
        Device deviceToDelete = this.edgeCtx.getDeviceService().findDeviceById(tenantId, deviceId);
        this.removeEntityFromEdgeAllGroup(tenantId, edge, (HasOwnerId)deviceToDelete);
    }

    private void saveOrUpdateDevice(TenantId tenantId, DeviceId deviceId, DeviceUpdateMsg deviceUpdateMsg, Edge edge) throws ThingsboardException {
        Pair resultPair = super.saveOrUpdateDevice(tenantId, deviceId, deviceUpdateMsg);
        Boolean created = (Boolean)resultPair.getFirst();
        if (created.booleanValue()) {
            this.createRelationFromEdge(tenantId, edge.getId(), (EntityId)deviceId);
            this.pushDeviceCreatedEventToRuleEngine(tenantId, edge, deviceId);
        }
        this.addDeviceToEdgeAllDeviceGroup(tenantId, edge, deviceId);
        Boolean deviceNameUpdated = (Boolean)resultPair.getSecond();
        if (deviceNameUpdated.booleanValue()) {
            this.saveEdgeEvent(tenantId, edge.getId(), EdgeEventType.DEVICE, EdgeEventActionType.UPDATED, (EntityId)deviceId, null);
        }
    }

    private void pushDeviceCreatedEventToRuleEngine(TenantId tenantId, Edge edge, DeviceId deviceId) {
        Device device = this.edgeCtx.getDeviceService().findDeviceById(tenantId, deviceId);
        this.pushEntityEventToRuleEngine(tenantId, edge, (HasId)device, TbMsgType.ENTITY_CREATED);
    }

    private void addDeviceToEdgeAllDeviceGroup(TenantId tenantId, Edge edge, DeviceId deviceId) {
        Device device = this.edgeCtx.getDeviceService().findDeviceById(tenantId, deviceId);
        this.addEntityToEdgeAllGroup(tenantId, edge, (HasOwnerId)device);
    }

    public ListenableFuture<Void> processDeviceRpcCallFromEdge(TenantId tenantId, Edge edge, DeviceRpcCallMsg deviceRpcCallMsg) {
        log.trace("[{}] processDeviceRpcCallFromEdge [{}]", (Object)tenantId, (Object)deviceRpcCallMsg);
        if (deviceRpcCallMsg.hasResponseMsg()) {
            return this.processDeviceRpcResponseFromEdge(tenantId, deviceRpcCallMsg);
        }
        if (deviceRpcCallMsg.hasRequestMsg()) {
            return this.processDeviceRpcRequestFromEdge(tenantId, edge, deviceRpcCallMsg);
        }
        return Futures.immediateFuture(null);
    }

    private ListenableFuture<Void> processDeviceRpcResponseFromEdge(TenantId tenantId, DeviceRpcCallMsg deviceRpcCallMsg) {
        SettableFuture futureToSet = SettableFuture.create();
        UUID requestUuid = new UUID(deviceRpcCallMsg.getRequestUuidMSB(), deviceRpcCallMsg.getRequestUuidLSB());
        DeviceId deviceId = new DeviceId(new UUID(deviceRpcCallMsg.getDeviceIdMSB(), deviceRpcCallMsg.getDeviceIdLSB()));
        FromDeviceRpcResponse response = !StringUtils.isEmpty((String)deviceRpcCallMsg.getResponseMsg().getError()) ? new FromDeviceRpcResponse(requestUuid, null, RpcError.valueOf((String)deviceRpcCallMsg.getResponseMsg().getError())) : new FromDeviceRpcResponse(requestUuid, deviceRpcCallMsg.getResponseMsg().getResponse(), null);
        1 callback = new /* Unavailable Anonymous Inner Class!! */;
        FromDeviceRpcResponseActorMsg msg = new FromDeviceRpcResponseActorMsg(Integer.valueOf(deviceRpcCallMsg.getRequestId()), tenantId, deviceId, response);
        this.edgeCtx.getClusterService().pushMsgToCore((ToDeviceActorNotificationMsg)msg, (TbQueueCallback)callback);
        return futureToSet;
    }

    private ListenableFuture<Void> processDeviceRpcRequestFromEdge(TenantId tenantId, Edge edge, DeviceRpcCallMsg deviceRpcCallMsg) {
        DeviceId deviceId = new DeviceId(new UUID(deviceRpcCallMsg.getDeviceIdMSB(), deviceRpcCallMsg.getDeviceIdLSB()));
        try {
            TbMsgMetaData metaData = new TbMsgMetaData();
            String requestId = Integer.toString(deviceRpcCallMsg.getRequestId());
            metaData.putValue("requestId", requestId);
            metaData.putValue("serviceId", deviceRpcCallMsg.getServiceId());
            metaData.putValue("sessionId", deviceRpcCallMsg.getSessionId());
            metaData.putValue("edgeId", edge.getId().toString());
            Device device = this.edgeCtx.getDeviceService().findDeviceById(tenantId, deviceId);
            if (device != null) {
                metaData.putValue("deviceName", device.getName());
                metaData.putValue("deviceType", device.getType());
                metaData.putValue("deviceId", deviceId.getId().toString());
            }
            ObjectNode data = JacksonUtil.newObjectNode();
            data.put("method", deviceRpcCallMsg.getRequestMsg().getMethod());
            data.put("params", deviceRpcCallMsg.getRequestMsg().getParams());
            TbMsg tbMsg = TbMsg.newMsg().type(TbMsgType.TO_SERVER_RPC_REQUEST).originator((EntityId)deviceId).copyMetaData(metaData).dataType(TbMsgDataType.JSON).data(JacksonUtil.toString((Object)data)).build();
            this.edgeCtx.getClusterService().pushMsgToRuleEngine(tenantId, (EntityId)deviceId, tbMsg, (TbQueueCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}][{}] Failed to push TO_SERVER_RPC_REQUEST to rule engine. deviceRpcCallMsg {}", new Object[]{tenantId, deviceId, deviceRpcCallMsg, e});
        }
        return Futures.immediateFuture(null);
    }

    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        DeviceId deviceId = new DeviceId(edgeEvent.getEntityId());
        switch (3.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[edgeEvent.getAction().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                Device device = this.edgeCtx.getDeviceService().findDeviceById(edgeEvent.getTenantId(), deviceId);
                if (device == null) break;
                EntityGroupId entityGroupId = edgeEvent.getEntityGroupId() != null ? new EntityGroupId(edgeEvent.getEntityGroupId()) : null;
                UpdateMsgType msgType = this.getUpdateMsgType(edgeEvent.getAction());
                DeviceUpdateMsg deviceUpdateMsg = EdgeMsgConstructorUtils.constructDeviceUpdatedMsg((UpdateMsgType)msgType, (Device)device, (EntityGroupId)entityGroupId);
                DownlinkMsg.Builder builder = DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addDeviceUpdateMsg(deviceUpdateMsg);
                DeviceCredentials deviceCredentials = this.edgeCtx.getDeviceCredentialsService().findDeviceCredentialsByDeviceId(edgeEvent.getTenantId(), deviceId);
                if (deviceCredentials != null) {
                    DeviceCredentialsUpdateMsg deviceCredentialsUpdateMsg = EdgeMsgConstructorUtils.constructDeviceCredentialsUpdatedMsg((DeviceCredentials)deviceCredentials);
                    builder.addDeviceCredentialsUpdateMsg(deviceCredentialsUpdateMsg).build();
                }
                if (UpdateMsgType.ENTITY_CREATED_RPC_MESSAGE.equals((Object)msgType)) {
                    DeviceProfile deviceProfile = this.edgeCtx.getDeviceProfileService().findDeviceProfileById(edgeEvent.getTenantId(), device.getDeviceProfileId());
                    builder.addDeviceProfileUpdateMsg(EdgeMsgConstructorUtils.constructDeviceProfileUpdatedMsg((UpdateMsgType)msgType, (DeviceProfile)deviceProfile, (EdgeVersion)edgeVersion));
                }
                return builder.build();
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                EntityGroupId entityGroupId = edgeEvent.getEntityGroupId() != null ? new EntityGroupId(edgeEvent.getEntityGroupId()) : null;
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addDeviceUpdateMsg(EdgeMsgConstructorUtils.constructDeviceDeleteMsg((DeviceId)deviceId, (EntityGroupId)entityGroupId)).build();
            }
            case 9: {
                DeviceCredentials deviceCredentials = this.edgeCtx.getDeviceCredentialsService().findDeviceCredentialsByDeviceId(edgeEvent.getTenantId(), deviceId);
                if (deviceCredentials == null) break;
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addDeviceCredentialsUpdateMsg(EdgeMsgConstructorUtils.constructDeviceCredentialsUpdatedMsg((DeviceCredentials)deviceCredentials)).build();
            }
            case 10: {
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addDeviceRpcCallMsg(EdgeMsgConstructorUtils.constructDeviceRpcCallMsg((UUID)edgeEvent.getEntityId(), (JsonNode)edgeEvent.getBody())).build();
            }
        }
        return null;
    }

    protected void setCustomerId(TenantId tenantId, CustomerId customerId, Device device, DeviceUpdateMsg deviceUpdateMsg) {
        CustomerId customerUUID = device.getCustomerId() != null ? device.getCustomerId() : customerId;
        device.setCustomerId(customerUUID);
    }

    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.DEVICE;
    }
}

