/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.device;

import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.util.Pair;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasVersion;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.HasId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.security.DeviceCredentials;
import org.thingsboard.server.dao.service.DataValidator;
import org.thingsboard.server.gen.edge.v1.DeviceCredentialsUpdateMsg;
import org.thingsboard.server.gen.edge.v1.DeviceUpdateMsg;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

public abstract class BaseDeviceProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseDeviceProcessor.class);
    @Autowired
    private TbClusterService tbClusterService;
    @Autowired
    private DataValidator<Device> deviceValidator;

    protected Pair<Boolean, Boolean> saveOrUpdateDevice(TenantId tenantId, DeviceId deviceId, DeviceUpdateMsg deviceUpdateMsg) throws ThingsboardException {
        boolean created = false;
        boolean deviceNameUpdated = false;
        deviceCreationLock.lock();
        try {
            Device device = (Device)JacksonUtil.fromString((String)deviceUpdateMsg.getEntity(), Device.class, (boolean)true);
            if (device == null) {
                throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] deviceUpdateMsg {" + String.valueOf(deviceUpdateMsg) + "} cannot be converted to device");
            }
            Device deviceById = this.edgeCtx.getDeviceService().findDeviceById(tenantId, deviceId);
            if (deviceById == null) {
                created = true;
                device.setId(null);
            } else {
                this.changeOwnerIfRequired(tenantId, device.getCustomerId(), (EntityId)deviceId);
                device.setId((UUIDBased)deviceId);
            }
            if (this.isSaveRequired((HasVersion)deviceById, (HasVersion)device)) {
                deviceNameUpdated = this.updateDeviceNameIfDuplicateExists(tenantId, deviceId, device);
                this.setCustomerId(tenantId, created ? null : deviceById.getCustomerId(), device, deviceUpdateMsg);
                this.deviceValidator.validate((BaseData)device, Device::getTenantId);
                if (created) {
                    device.setId((UUIDBased)deviceId);
                }
                Device savedDevice = this.edgeCtx.getDeviceService().saveDevice(device, false);
                if (created) {
                    this.edgeCtx.getEntityGroupService().addEntityToEntityGroupAll(savedDevice.getTenantId(), savedDevice.getOwnerId(), (EntityId)savedDevice.getId());
                }
                this.tbClusterService.onDeviceUpdated(savedDevice, created ? null : device);
            }
            this.safeAddToEntityGroup(tenantId, deviceUpdateMsg, deviceId);
        }
        catch (Exception e) {
            log.error("[{}] Failed to process device update msg [{}]", new Object[]{tenantId, deviceUpdateMsg, e});
            throw e;
        }
        finally {
            deviceCreationLock.unlock();
        }
        return Pair.of((Object)created, (Object)deviceNameUpdated);
    }

    private void safeAddToEntityGroup(TenantId tenantId, DeviceUpdateMsg deviceUpdateMsg, DeviceId deviceId) {
        if (deviceUpdateMsg.hasEntityGroupIdMSB() && deviceUpdateMsg.hasEntityGroupIdLSB()) {
            UUID entityGroupUUID = this.safeGetUUID(deviceUpdateMsg.getEntityGroupIdMSB(), deviceUpdateMsg.getEntityGroupIdLSB());
            this.safeAddEntityToGroup(tenantId, new EntityGroupId(entityGroupUUID), (EntityId)deviceId);
        }
    }

    private boolean updateDeviceNameIfDuplicateExists(TenantId tenantId, DeviceId deviceId, Device device) {
        Device deviceByName = this.edgeCtx.getDeviceService().findDeviceByTenantIdAndName(tenantId, device.getName());
        return this.generateUniqueNameIfDuplicateExists(tenantId, (EntityId)deviceId, (HasName)device, (HasName)deviceByName).map(uniqueName -> {
            device.setName(uniqueName);
            return true;
        }).orElse(false);
    }

    protected void updateDeviceCredentials(TenantId tenantId, DeviceCredentialsUpdateMsg deviceCredentialsUpdateMsg) {
        DeviceCredentials deviceCredentials = (DeviceCredentials)JacksonUtil.fromString((String)deviceCredentialsUpdateMsg.getEntity(), DeviceCredentials.class, (boolean)true);
        if (deviceCredentials == null) {
            throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] deviceCredentialsUpdateMsg {" + String.valueOf(deviceCredentialsUpdateMsg) + "} cannot be converted to device credentials");
        }
        Device device = this.edgeCtx.getDeviceService().findDeviceById(tenantId, deviceCredentials.getDeviceId());
        if (device != null) {
            log.debug("[{}] Updating device credentials for device [{}]. New device credentials Id [{}], value [{}]", new Object[]{tenantId, device.getName(), deviceCredentials.getCredentialsId(), deviceCredentials.getCredentialsValue()});
            try {
                DeviceCredentials deviceCredentialsByDeviceId = this.edgeCtx.getDeviceCredentialsService().findDeviceCredentialsByDeviceId(tenantId, device.getId());
                if (deviceCredentialsByDeviceId == null) {
                    deviceCredentialsByDeviceId = new DeviceCredentials();
                    deviceCredentialsByDeviceId.setDeviceId(device.getId());
                }
                deviceCredentialsByDeviceId.setCredentialsType(deviceCredentials.getCredentialsType());
                deviceCredentialsByDeviceId.setCredentialsId(deviceCredentials.getCredentialsId());
                deviceCredentialsByDeviceId.setCredentialsValue(deviceCredentials.getCredentialsValue());
                this.edgeCtx.getDeviceCredentialsService().updateDeviceCredentials(tenantId, deviceCredentialsByDeviceId);
            }
            catch (Exception e) {
                log.error("[{}] Can't update device credentials for device [{}], deviceCredentialsUpdateMsg [{}]", new Object[]{tenantId, device.getName(), deviceCredentialsUpdateMsg, e});
                throw new RuntimeException(e);
            }
        } else {
            log.warn("[{}] Can't find device by id [{}], deviceCredentialsUpdateMsg [{}]", new Object[]{tenantId, deviceCredentials.getDeviceId(), deviceCredentialsUpdateMsg});
        }
    }

    protected abstract void setCustomerId(TenantId var1, CustomerId var2, Device var3, DeviceUpdateMsg var4);

    protected void deleteDevice(TenantId tenantId, DeviceId deviceId) {
        this.deleteDevice(tenantId, null, deviceId);
    }

    protected void deleteDevice(TenantId tenantId, Edge edge, DeviceId deviceId) {
        Device deviceById = this.edgeCtx.getDeviceService().findDeviceById(tenantId, deviceId);
        if (deviceById != null) {
            this.edgeCtx.getDeviceService().deleteDevice(tenantId, deviceId);
            this.pushEntityEventToRuleEngine(tenantId, edge, (HasId)deviceById, TbMsgType.ENTITY_DELETED);
        }
    }
}

