/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.cf;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.util.Pair;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.dao.service.DataValidator;
import org.thingsboard.server.gen.edge.v1.CalculatedFieldUpdateMsg;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

public abstract class BaseCalculatedFieldProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseCalculatedFieldProcessor.class);
    @Autowired
    private DataValidator<CalculatedField> calculatedFieldValidator;

    protected Pair<Boolean, Boolean> saveOrUpdateCalculatedField(TenantId tenantId, CalculatedFieldId calculatedFieldId, CalculatedFieldUpdateMsg calculatedFieldUpdateMsg) {
        boolean isCreated = false;
        boolean isNameUpdated = false;
        try {
            CalculatedField calculatedField = (CalculatedField)JacksonUtil.fromString((String)calculatedFieldUpdateMsg.getEntity(), CalculatedField.class, (boolean)true);
            if (calculatedField == null) {
                throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] calculatedFieldUpdateMsg {" + String.valueOf(calculatedFieldUpdateMsg) + " } cannot be converted to calculatedField");
            }
            CalculatedField calculatedFieldById = this.edgeCtx.getCalculatedFieldService().findById(tenantId, calculatedFieldId);
            if (calculatedFieldById == null) {
                calculatedField.setCreatedTime(Uuids.unixTimestamp((UUID)calculatedFieldId.getId()));
                isCreated = true;
                calculatedField.setId(null);
            } else {
                calculatedField.setId((UUIDBased)calculatedFieldId);
            }
            Object calculatedFieldName = calculatedField.getName();
            CalculatedField calculatedFieldByName = this.edgeCtx.getCalculatedFieldService().findByEntityIdAndTypeAndName(calculatedField.getEntityId(), calculatedField.getType(), (String)calculatedFieldName);
            if (calculatedFieldByName != null && !calculatedFieldByName.getId().equals((Object)calculatedFieldId)) {
                calculatedFieldName = (String)calculatedFieldName + "_" + StringUtils.randomAlphabetic((int)15);
                log.warn("[{}] calculatedField with name {} already exists. Renaming calculatedField name to {}", new Object[]{tenantId, calculatedField.getName(), calculatedFieldByName.getName()});
                isNameUpdated = true;
            }
            calculatedField.setName((String)calculatedFieldName);
            this.calculatedFieldValidator.validate((BaseData)calculatedField, CalculatedField::getTenantId);
            if (isCreated) {
                calculatedField.setId((UUIDBased)calculatedFieldId);
            }
            this.edgeCtx.getCalculatedFieldService().save(calculatedField, false);
        }
        catch (Exception e) {
            log.error("[{}] Failed to process calculatedField update msg [{}]", new Object[]{tenantId, calculatedFieldUpdateMsg, e});
            throw e;
        }
        return Pair.of((Object)isCreated, (Object)isNameUpdated);
    }
}

