/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.asset;

import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.util.Pair;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasVersion;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.HasId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.dao.service.DataValidator;
import org.thingsboard.server.gen.edge.v1.AssetUpdateMsg;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

public abstract class BaseAssetProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseAssetProcessor.class);
    @Autowired
    private DataValidator<Asset> assetValidator;

    protected Pair<Boolean, Boolean> saveOrUpdateAsset(TenantId tenantId, AssetId assetId, AssetUpdateMsg assetUpdateMsg) throws ThingsboardException {
        boolean created = false;
        boolean assetNameUpdated = false;
        assetCreationLock.lock();
        try {
            Asset asset = (Asset)JacksonUtil.fromString((String)assetUpdateMsg.getEntity(), Asset.class, (boolean)true);
            if (asset == null) {
                throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] assetUpdateMsg {" + String.valueOf(assetUpdateMsg) + " } cannot be converted to asset");
            }
            Asset assetById = this.edgeCtx.getAssetService().findAssetById(tenantId, assetId);
            if (assetById == null) {
                created = true;
                asset.setId(null);
            } else {
                asset.setId((UUIDBased)assetId);
                this.changeOwnerIfRequired(tenantId, asset.getCustomerId(), (EntityId)assetId);
            }
            if (this.isSaveRequired((HasVersion)assetById, (HasVersion)asset)) {
                assetNameUpdated = this.updateAssetNameIfDuplicateExists(tenantId, assetId, asset);
                this.setCustomerId(tenantId, created ? null : assetById.getCustomerId(), asset, assetUpdateMsg);
                this.assetValidator.validate((BaseData)asset, Asset::getTenantId);
                if (created) {
                    asset.setId((UUIDBased)assetId);
                }
                Asset savedAsset = this.edgeCtx.getAssetService().saveAsset(asset, false);
                if (created) {
                    this.edgeCtx.getEntityGroupService().addEntityToEntityGroupAll(savedAsset.getTenantId(), savedAsset.getOwnerId(), (EntityId)savedAsset.getId());
                }
            }
            this.safeAddToEntityGroup(tenantId, assetUpdateMsg, assetId);
        }
        catch (Exception e) {
            log.error("[{}] Failed to process asset update msg [{}]", new Object[]{tenantId, assetUpdateMsg, e});
            throw e;
        }
        finally {
            assetCreationLock.unlock();
        }
        return Pair.of((Object)created, (Object)assetNameUpdated);
    }

    private void safeAddToEntityGroup(TenantId tenantId, AssetUpdateMsg assetUpdateMsg, AssetId assetId) {
        if (assetUpdateMsg.hasEntityGroupIdMSB() && assetUpdateMsg.hasEntityGroupIdLSB()) {
            UUID entityGroupUUID = this.safeGetUUID(assetUpdateMsg.getEntityGroupIdMSB(), assetUpdateMsg.getEntityGroupIdLSB());
            this.safeAddEntityToGroup(tenantId, new EntityGroupId(entityGroupUUID), (EntityId)assetId);
        }
    }

    private boolean updateAssetNameIfDuplicateExists(TenantId tenantId, AssetId assetId, Asset asset) {
        Asset assetByName = this.edgeCtx.getAssetService().findAssetByTenantIdAndName(tenantId, asset.getName());
        return this.generateUniqueNameIfDuplicateExists(tenantId, (EntityId)assetId, (HasName)asset, (HasName)assetByName).map(uniqueName -> {
            asset.setName(uniqueName);
            return true;
        }).orElse(false);
    }

    protected abstract void setCustomerId(TenantId var1, CustomerId var2, Asset var3, AssetUpdateMsg var4);

    protected void deleteAsset(TenantId tenantId, AssetId assetId) {
        this.deleteAsset(tenantId, null, assetId);
    }

    protected void deleteAsset(TenantId tenantId, Edge edge, AssetId assetId) {
        Asset assetById = this.edgeCtx.getAssetService().findAssetById(tenantId, assetId);
        if (assetById != null) {
            this.edgeCtx.getAssetService().deleteAsset(tenantId, assetId);
            this.pushEntityEventToRuleEngine(tenantId, edge, (HasId)assetById, TbMsgType.ENTITY_DELETED);
        }
    }
}

