/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.ai;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.util.Pair;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.ai.AiModel;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.id.AiModelId;
import org.thingsboard.server.common.data.id.HasId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.dao.service.DataValidator;
import org.thingsboard.server.gen.edge.v1.AiModelUpdateMsg;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

public abstract class BaseAiModelProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseAiModelProcessor.class);
    @Autowired
    private DataValidator<AiModel> aiModelValidator;

    protected Pair<Boolean, Boolean> saveOrUpdateAiModel(TenantId tenantId, AiModelId aiModelId, AiModelUpdateMsg aiModelUpdateMsg) {
        boolean isCreated = false;
        boolean isNameUpdated = false;
        try {
            AiModel aiModel = (AiModel)JacksonUtil.fromString((String)aiModelUpdateMsg.getEntity(), AiModel.class, (boolean)true);
            if (aiModel == null) {
                throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] aiModelUpdateMsg {" + String.valueOf(aiModelUpdateMsg) + " } cannot be converted to aiModel");
            }
            Optional aiModelById = this.edgeCtx.getAiModelService().findAiModelById(tenantId, aiModelId);
            if (aiModelById.isEmpty()) {
                aiModel.setCreatedTime(Uuids.unixTimestamp((UUID)aiModelId.getId()));
                isCreated = true;
                aiModel.setId(null);
            } else {
                aiModel.setId((UUIDBased)aiModelId);
            }
            Object aiModelName = aiModel.getName();
            Optional aiModelByName = this.edgeCtx.getAiModelService().findAiModelByTenantIdAndName(aiModel.getTenantId(), (String)aiModelName);
            if (aiModelByName.isPresent() && !((AiModelId)((AiModel)aiModelByName.get()).getId()).equals((Object)aiModelId)) {
                aiModelName = (String)aiModelName + "_" + StringUtils.randomAlphabetic((int)15);
                log.warn("[{}] aiModel with name {} already exists. Renaming aiModel name to {}", new Object[]{tenantId, aiModel.getName(), ((AiModel)aiModelByName.get()).getName()});
                isNameUpdated = true;
            }
            aiModel.setName((String)aiModelName);
            this.aiModelValidator.validate((BaseData)aiModel, AiModel::getTenantId);
            if (isCreated) {
                aiModel.setId((UUIDBased)aiModelId);
            }
            this.edgeCtx.getAiModelService().save(aiModel, false);
        }
        catch (Exception e) {
            log.error("[{}] Failed to process aiModel update msg [{}]", new Object[]{tenantId, aiModelUpdateMsg, e});
            throw e;
        }
        return Pair.of((Object)isCreated, (Object)isNameUpdated);
    }

    protected void deleteAiModel(TenantId tenantId, Edge edge, AiModelId aiModelId) {
        Optional aiModel = this.edgeCtx.getAiModelService().findAiModelById(tenantId, aiModelId);
        if (aiModel.isPresent()) {
            this.edgeCtx.getAiModelService().deleteByTenantIdAndId(tenantId, aiModelId);
            this.pushEntityEventToRuleEngine(tenantId, edge, (HasId)((AiModel)aiModel.get()), TbMsgType.ENTITY_DELETED);
        }
    }
}

