/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.CloudUtils;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Dashboard;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.EntityView;
import org.thingsboard.server.common.data.HasCustomerId;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasOwnerId;
import org.thingsboard.server.common.data.HasVersion;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.cloud.CloudEventType;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.BlobEntityId;
import org.thingsboard.server.common.data.id.ConverterId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.EntityViewId;
import org.thingsboard.server.common.data.id.HasId;
import org.thingsboard.server.common.data.id.IntegrationId;
import org.thingsboard.server.common.data.id.RoleId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.SchedulerEventId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.common.data.page.PageDataIterableByTenantIdEntityId;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.relation.RelationTypeGroup;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.common.data.rule.RuleChainConnectionInfo;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgDataType;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.dao.cloud.CloudEventService;
import org.thingsboard.server.dao.cloud.CloudSynchronizationManager;
import org.thingsboard.server.dao.edge.EdgeService;
import org.thingsboard.server.dao.edge.EdgeSynchronizationManager;
import org.thingsboard.server.dao.entity.EntityDaoRegistry;
import org.thingsboard.server.dao.model.ModelConstants;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.service.edge.EdgeContextComponent;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.EdgeProcessor;
import org.thingsboard.server.service.executors.DbCallbackExecutorService;
import org.thingsboard.server.service.security.permission.OwnersCacheService;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class BaseEdgeProcessor
implements EdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseEdgeProcessor.class);
    protected static final Lock deviceCreationLock = new ReentrantLock();
    protected static final Lock assetCreationLock = new ReentrantLock();
    protected static final Lock widgetCreationLock = new ReentrantLock();
    protected static final Lock customerCreationLock = new ReentrantLock();
    @Lazy
    @Autowired
    protected EdgeContextComponent edgeCtx;
    @Autowired
    protected EntityDaoRegistry entityDaoRegistry;
    @Autowired
    protected EdgeSynchronizationManager edgeSynchronizationManager;
    @Autowired
    protected CloudSynchronizationManager cloudSynchronizationManager;
    @Autowired
    protected CloudEventService cloudEventService;
    @Autowired
    protected DbCallbackExecutorService dbCallbackExecutorService;
    @Autowired
    protected OwnersCacheService ownersCacheService;

    protected ListenableFuture<Void> saveEdgeEvent(TenantId tenantId, EdgeId edgeId, EdgeEventType type, EdgeEventActionType action, EntityId entityId, JsonNode body) {
        return this.saveEdgeEvent(tenantId, edgeId, type, action, entityId, body, null);
    }

    protected ListenableFuture<Void> saveEdgeEvent(TenantId tenantId, EdgeId edgeId, EdgeEventType type, EdgeEventActionType action, EntityId entityId, JsonNode body, EntityGroupId entityGroupId) {
        return this.saveEdgeEvent(tenantId, edgeId, type, action, entityId, body, entityGroupId, true);
    }

    protected ListenableFuture<Void> saveEdgeEvent(TenantId tenantId, EdgeId edgeId, EdgeEventType type, EdgeEventActionType action, EntityId entityId, JsonNode body, EntityGroupId entityGroupId, boolean doValidate) {
        if (doValidate) {
            ListenableFuture future = this.edgeCtx.getAttributesService().find(tenantId, (EntityId)edgeId, AttributeScope.SERVER_SCOPE, "active");
            return Futures.transformAsync((ListenableFuture)future, activeOpt -> {
                if (activeOpt.isEmpty()) {
                    log.trace("Edge is not activated. Skipping event. tenantId [{}], edgeId [{}], type[{}], action [{}], entityId [{}], body [{}], entityGroupId [{}]", new Object[]{tenantId, edgeId, type, action, entityId, body, entityGroupId});
                    return Futures.immediateFuture(null);
                }
                if (((AttributeKvEntry)activeOpt.get()).getBooleanValue().isPresent() && ((Boolean)((AttributeKvEntry)activeOpt.get()).getBooleanValue().get()).booleanValue()) {
                    return this.doSaveEdgeEvent(tenantId, edgeId, type, action, entityId, body, entityGroupId);
                }
                if (this.doSaveIfEdgeIsOffline(type, action)) {
                    return this.doSaveEdgeEvent(tenantId, edgeId, type, action, entityId, body, entityGroupId);
                }
                log.trace("Edge is not active at the moment. Skipping event. tenantId [{}], edgeId [{}], type[{}], action [{}], entityId [{}], body [{}], entityGroupId [{}]", new Object[]{tenantId, edgeId, type, action, entityId, body, entityGroupId});
                return Futures.immediateFuture(null);
            }, (Executor)this.dbCallbackExecutorService);
        }
        return this.doSaveEdgeEvent(tenantId, edgeId, type, action, entityId, body, entityGroupId);
    }

    private boolean doSaveIfEdgeIsOffline(EdgeEventType type, EdgeEventActionType action) {
        return switch (2.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[action.ordinal()]) {
            case 1, 2, 3, 4, 5, 6, 7, 8 -> true;
            default -> {
                switch (2.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventType[type.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: {
                        yield true;
                    }
                }
                yield false;
            }
        };
    }

    private ListenableFuture<Void> doSaveEdgeEvent(TenantId tenantId, EdgeId edgeId, EdgeEventType type, EdgeEventActionType action, EntityId entityId, JsonNode body, EntityGroupId entityGroupId) {
        log.debug("Pushing event to edge queue. tenantId [{}], edgeId [{}], type[{}], action [{}], entityId [{}], body [{}], entityGroupId [{}]", new Object[]{tenantId, edgeId, type, action, entityId, body, entityGroupId});
        EdgeEvent edgeEvent = EdgeUtils.constructEdgeEvent((TenantId)tenantId, (EdgeId)edgeId, (EdgeEventType)type, (EdgeEventActionType)action, (EntityId)entityId, (JsonNode)body, (EntityId)entityGroupId);
        return this.edgeCtx.getEdgeEventService().saveAsync(edgeEvent);
    }

    protected ListenableFuture<Void> processActionForAllEdges(TenantId tenantId, EdgeEventType type, EdgeEventActionType actionType, EntityId entityId, JsonNode body, EdgeId sourceEdgeId) {
        List<ListenableFuture> futures = new ArrayList();
        if (TenantId.SYS_TENANT_ID.equals((Object)tenantId)) {
            PageDataIterable edges = new PageDataIterable(link -> this.edgeCtx.getEdgeService().findActiveEdges(link), 1024);
            for (Edge edge : edges) {
                futures.add(this.saveEdgeEvent(edge.getTenantId(), edge.getId(), type, actionType, entityId, body, null, false));
            }
        } else {
            futures = this.processActionForAllEdgesByTenantId(tenantId, type, actionType, entityId, body, sourceEdgeId, null);
        }
        return Futures.transform((ListenableFuture)Futures.allAsList(futures), voids -> null, (Executor)this.dbCallbackExecutorService);
    }

    protected List<ListenableFuture<Void>> processActionForAllEdgesByTenantId(TenantId tenantId, EdgeEventType type, EdgeEventActionType actionType, EntityId entityId, JsonNode body, EdgeId sourceEdgeId, EntityGroupId entityGroupId) {
        ArrayList<ListenableFuture<Void>> futures = new ArrayList<ListenableFuture<Void>>();
        PageDataIterable edges = new PageDataIterable(link -> this.edgeCtx.getEdgeService().findEdgesByTenantId(tenantId, link), 1024);
        for (Edge edge : edges) {
            if (edge.getId().equals((Object)sourceEdgeId)) continue;
            futures.add((ListenableFuture<Void>)this.saveEdgeEvent(tenantId, edge.getId(), type, actionType, entityId, body, entityGroupId));
        }
        return futures;
    }

    protected ListenableFuture<Void> handleUnsupportedMsgType(UpdateMsgType msgType) {
        String errMsg = String.format("Unsupported msg type %s", msgType);
        log.error(errMsg);
        return Futures.immediateFailedFuture((Throwable)new RuntimeException(errMsg));
    }

    protected UpdateMsgType getUpdateMsgType(EdgeEventActionType actionType) {
        return switch (2.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[actionType.ordinal()]) {
            case 7, 9, 10 -> UpdateMsgType.ENTITY_UPDATED_RPC_MESSAGE;
            case 6, 11, 12, 13, 14 -> UpdateMsgType.ENTITY_CREATED_RPC_MESSAGE;
            case 8, 15, 16, 17, 18, 19, 20 -> UpdateMsgType.ENTITY_DELETED_RPC_MESSAGE;
            case 2 -> UpdateMsgType.ALARM_ACK_RPC_MESSAGE;
            case 3 -> UpdateMsgType.ALARM_CLEAR_RPC_MESSAGE;
            default -> throw new RuntimeException("Unsupported actionType [" + String.valueOf(actionType) + "]");
        };
    }

    public ListenableFuture<Void> processEntityNotification(TenantId tenantId, TransportProtos.EdgeNotificationMsgProto edgeNotificationMsg) {
        EdgeEventType type = EdgeEventType.valueOf((String)edgeNotificationMsg.getType());
        EdgeEventActionType actionType = EdgeEventActionType.valueOf((String)edgeNotificationMsg.getAction());
        EntityId entityId = EntityIdFactory.getByEdgeEventTypeAndUuid((EdgeEventType)type, (UUID)new UUID(edgeNotificationMsg.getEntityIdMSB(), edgeNotificationMsg.getEntityIdLSB()));
        EdgeId originatorEdgeId = this.safeGetEdgeId(edgeNotificationMsg.getOriginatorEdgeIdMSB(), edgeNotificationMsg.getOriginatorEdgeIdLSB());
        if (type.isAllEdgesRelated()) {
            return this.processEntityNotificationForAllEdges(tenantId, type, actionType, entityId, originatorEdgeId);
        }
        JsonNode body = JacksonUtil.toJsonNode((String)edgeNotificationMsg.getBody());
        EdgeId edgeId = this.safeGetEdgeId(edgeNotificationMsg.getEdgeIdMSB(), edgeNotificationMsg.getEdgeIdLSB());
        EntityGroupId entityGroupId = this.constructEntityGroupId(tenantId, edgeNotificationMsg);
        switch (2.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[actionType.ordinal()]) {
            case 9: 
            case 10: 
            case 12: {
                if (edgeId != null && !edgeId.equals((Object)originatorEdgeId)) {
                    return this.saveEdgeEvent(tenantId, edgeId, type, actionType, entityId, body, entityGroupId);
                }
                return this.pushNotificationToAllRelatedEdges(tenantId, entityId, entityId, type, actionType, body, entityGroupId, originatorEdgeId);
            }
            case 8: 
            case 17: {
                if (edgeId != null) {
                    return this.saveEdgeEvent(tenantId, edgeId, type, actionType, entityId, body, entityGroupId);
                }
                return Futures.transform((ListenableFuture)Futures.allAsList((Iterable)this.processActionForAllEdgesByTenantId(tenantId, type, actionType, entityId, body, originatorEdgeId, entityGroupId)), voids -> null, (Executor)this.dbCallbackExecutorService);
            }
            case 13: 
            case 15: {
                if (originatorEdgeId == null) {
                    ListenableFuture future = this.saveEdgeEvent(tenantId, edgeId, type, actionType, entityId, body);
                    return Futures.transformAsync((ListenableFuture)future, unused -> {
                        if (type.equals((Object)EdgeEventType.RULE_CHAIN)) {
                            return this.updateDependentRuleChains(tenantId, new RuleChainId(entityId.getId()), edgeId);
                        }
                        return Futures.immediateFuture(null);
                    }, (Executor)this.dbCallbackExecutorService);
                }
                return Futures.immediateFuture(null);
            }
            case 18: {
                if (edgeId != null) {
                    return this.saveEdgeEvent(tenantId, edgeId, type, actionType, entityId, body);
                }
                return Futures.transform((ListenableFuture)Futures.allAsList((Iterable)this.processActionForAllEdgesByTenantId(tenantId, type, actionType, entityId, body, originatorEdgeId, null)), voids -> null, (Executor)this.dbCallbackExecutorService);
            }
        }
        return Futures.immediateFuture(null);
    }

    protected EdgeId safeGetEdgeId(long edgeIdMSB, long edgeIdLSB) {
        if (edgeIdMSB != 0L && edgeIdLSB != 0L) {
            return new EdgeId(new UUID(edgeIdMSB, edgeIdLSB));
        }
        return null;
    }

    private EntityGroupId constructEntityGroupId(TenantId tenantId, TransportProtos.EdgeNotificationMsgProto edgeNotificationMsg) {
        if (edgeNotificationMsg.getEntityGroupIdMSB() != 0L && edgeNotificationMsg.getEntityGroupIdLSB() != 0L) {
            EntityGroupId entityGroupId = new EntityGroupId(new UUID(edgeNotificationMsg.getEntityGroupIdMSB(), edgeNotificationMsg.getEntityGroupIdLSB()));
            EntityGroup entityGroup = this.edgeCtx.getEntityGroupService().findEntityGroupById(tenantId, entityGroupId);
            if (entityGroup == null) {
                return null;
            }
            if (entityGroup.isEdgeGroupAll()) {
                return null;
            }
            return entityGroupId;
        }
        return null;
    }

    protected ListenableFuture<Void> pushNotificationToAllRelatedEdges(TenantId tenantId, EntityId ownerEntityId, EntityId entityId, EdgeEventType type, EdgeEventActionType actionType, JsonNode body, EntityGroupId entityGroupId, EdgeId sourceEdgeId) {
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        PageDataIterableByTenantIdEntityId edgeIds = new PageDataIterableByTenantIdEntityId((arg_0, arg_1, arg_2) -> ((EdgeService)this.edgeCtx.getEdgeService()).findRelatedEdgeIdsByEntityId(arg_0, arg_1, arg_2), tenantId, ownerEntityId, 1000);
        for (EdgeId relatedEdgeId : edgeIds) {
            if (relatedEdgeId.equals((Object)sourceEdgeId)) continue;
            futures.add(this.saveEdgeEvent(tenantId, relatedEdgeId, type, actionType, entityId, body, entityGroupId));
        }
        return Futures.transform((ListenableFuture)Futures.allAsList(futures), voids -> null, (Executor)this.dbCallbackExecutorService);
    }

    private ListenableFuture<Void> updateDependentRuleChains(TenantId tenantId, RuleChainId processingRuleChainId, EdgeId edgeId) {
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        PageDataIterable ruleChains = new PageDataIterable(link -> this.edgeCtx.getRuleChainService().findRuleChainsByTenantIdAndEdgeId(tenantId, edgeId, link), 1024);
        for (RuleChain ruleChain : ruleChains) {
            List connectionInfos = this.edgeCtx.getRuleChainService().loadRuleChainMetaData(ruleChain.getTenantId(), ruleChain.getId()).getRuleChainConnections();
            if (connectionInfos == null || connectionInfos.isEmpty()) continue;
            for (RuleChainConnectionInfo connectionInfo : connectionInfos) {
                if (!connectionInfo.getTargetRuleChainId().equals((Object)processingRuleChainId)) continue;
                futures.add(this.saveEdgeEvent(tenantId, edgeId, EdgeEventType.RULE_CHAIN_METADATA, EdgeEventActionType.UPDATED, (EntityId)ruleChain.getId(), null));
            }
        }
        return Futures.transform((ListenableFuture)Futures.allAsList(futures), voids -> null, (Executor)this.dbCallbackExecutorService);
    }

    private ListenableFuture<Void> processEntityNotificationForAllEdges(TenantId tenantId, EdgeEventType type, EdgeEventActionType actionType, EntityId entityId, EdgeId sourceEdgeId) {
        return switch (2.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[actionType.ordinal()]) {
            case 8, 9, 10, 11 -> this.processActionForAllEdges(tenantId, type, actionType, entityId, null, sourceEdgeId);
            default -> Futures.immediateFuture(null);
        };
    }

    protected EntityId constructEntityId(String entityTypeStr, long entityIdMSB, long entityIdLSB) {
        EntityType entityType = EntityType.valueOf((String)entityTypeStr);
        return switch (2.$SwitchMap$org$thingsboard$server$common$data$EntityType[entityType.ordinal()]) {
            case 1 -> new DeviceId(new UUID(entityIdMSB, entityIdLSB));
            case 2 -> new AssetId(new UUID(entityIdMSB, entityIdLSB));
            case 3 -> new EntityViewId(new UUID(entityIdMSB, entityIdLSB));
            case 4 -> new DashboardId(new UUID(entityIdMSB, entityIdLSB));
            case 5 -> TenantId.fromUUID((UUID)new UUID(entityIdMSB, entityIdLSB));
            case 6 -> new CustomerId(new UUID(entityIdMSB, entityIdLSB));
            case 7 -> new UserId(new UUID(entityIdMSB, entityIdLSB));
            case 8 -> new EdgeId(new UUID(entityIdMSB, entityIdLSB));
            case 9 -> new EntityGroupId(new UUID(entityIdMSB, entityIdLSB));
            case 10 -> new ConverterId(new UUID(entityIdMSB, entityIdLSB));
            case 11 -> new IntegrationId(new UUID(entityIdMSB, entityIdLSB));
            case 12 -> new SchedulerEventId(new UUID(entityIdMSB, entityIdLSB));
            case 13 -> new BlobEntityId(new UUID(entityIdMSB, entityIdLSB));
            case 14 -> new RoleId(new UUID(entityIdMSB, entityIdLSB));
            default -> {
                log.warn("Unsupported entity type [{}] during construct of entity id. entityIdMSB [{}], entityIdLSB [{}]", new Object[]{entityTypeStr, entityIdMSB, entityIdLSB});
                yield null;
            }
        };
    }

    protected UUID safeGetUUID(long mSB, long lSB) {
        return mSB != 0L && lSB != 0L ? new UUID(mSB, lSB) : null;
    }

    protected CustomerId safeGetCustomerId(long mSB, long lSB) {
        CustomerId customerId = null;
        UUID customerUUID = this.safeGetUUID(mSB, lSB);
        if (customerUUID != null) {
            customerId = new CustomerId(customerUUID);
        }
        return customerId;
    }

    protected boolean isEntityExists(TenantId tenantId, EntityId entityId) {
        return this.entityDaoRegistry.getDao(entityId.getEntityType()).existsById(tenantId, entityId.getId());
    }

    protected ListenableFuture<Void> requestForCalculatedFieldData(TenantId tenantId, EntityId entityId) {
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        CloudEventType cloudEventType = CloudUtils.getCloudEventTypeByEntityType((EntityType)entityId.getEntityType());
        log.info("Adding CALCULATED_FIELD_REQUEST {} {}", (Object)entityId, (Object)cloudEventType);
        futures.add(this.cloudEventService.saveCloudEventAsync(tenantId, cloudEventType, EdgeEventActionType.CALCULATED_FIELD_REQUEST, entityId, null, null));
        return Futures.transform((ListenableFuture)Futures.allAsList(futures), voids -> null, (Executor)this.dbCallbackExecutorService);
    }

    protected ListenableFuture<Void> requestForAdditionalData(TenantId tenantId, EntityId entityId) {
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        CloudEventType cloudEventType = CloudUtils.getCloudEventTypeByEntityType((EntityType)entityId.getEntityType());
        log.info("Adding ATTRIBUTES_REQUEST/RELATION_REQUEST {} {}", (Object)entityId, (Object)cloudEventType);
        futures.add(this.cloudEventService.saveCloudEventAsync(tenantId, cloudEventType, EdgeEventActionType.ATTRIBUTES_REQUEST, entityId, null, null));
        futures.add(this.cloudEventService.saveCloudEventAsync(tenantId, cloudEventType, EdgeEventActionType.RELATION_REQUEST, entityId, null, null));
        return Futures.transform((ListenableFuture)Futures.allAsList(futures), voids -> null, (Executor)this.dbCallbackExecutorService);
    }

    protected void createRelationFromEdge(TenantId tenantId, EdgeId edgeId, EntityId entityId) {
        EntityRelation relation = new EntityRelation();
        relation.setFrom((EntityId)edgeId);
        relation.setTo(entityId);
        relation.setTypeGroup(RelationTypeGroup.COMMON);
        relation.setType("ManagedByEdge");
        this.edgeCtx.getRelationService().saveRelation(tenantId, relation);
    }

    protected <T extends HasId<? extends EntityId>> void pushEntityEventToRuleEngine(TenantId tenantId, T entity, TbMsgType msgType) {
        this.pushEntityEventToRuleEngine(tenantId, null, entity, msgType);
    }

    protected <T extends HasId<? extends EntityId>> void pushEntityEventToRuleEngine(TenantId tenantId, Edge edge, T entity, TbMsgType msgType) {
        try {
            String entityAsString = JacksonUtil.toString(entity);
            CustomerId customerId = this.getCustomerId(entity);
            TbMsgMetaData tbMsgMetaData = edge == null ? TbMsgMetaData.EMPTY : this.getEdgeActionTbMsgMetaData(edge, customerId);
            this.pushEntityEventToRuleEngine(tenantId, (EntityId)entity.getId(), customerId, msgType, entityAsString, tbMsgMetaData);
        }
        catch (Exception e) {
            log.warn("[{}][{}] Failed to push entity action for {} to rule engine: {}", new Object[]{tenantId, entity.getId(), ((EntityId)entity.getId()).getEntityType(), msgType.name(), e});
        }
    }

    private <T extends HasId<? extends EntityId>> CustomerId getCustomerId(T entity) {
        if (entity instanceof HasCustomerId) {
            HasCustomerId hasCustomer = (HasCustomerId)entity;
            return hasCustomer.getCustomerId();
        }
        return null;
    }

    protected TbMsgMetaData getEdgeActionTbMsgMetaData(Edge edge, CustomerId customerId) {
        TbMsgMetaData metaData = new TbMsgMetaData();
        metaData.putValue("edgeId", edge.getId().toString());
        metaData.putValue("edgeName", edge.getName());
        if (customerId != null && !customerId.isNullUid()) {
            metaData.putValue("customerId", customerId.toString());
        }
        return metaData;
    }

    protected void pushEntityEventToRuleEngine(TenantId tenantId, EntityId entityId, CustomerId customerId, TbMsgType msgType, String msgData, TbMsgMetaData metaData) {
        TbMsg tbMsg = TbMsg.newMsg().type(msgType).originator(entityId).customerId(customerId).copyMetaData(metaData).dataType(TbMsgDataType.JSON).data(msgData).build();
        this.edgeCtx.getClusterService().pushMsgToRuleEngine(tenantId, entityId, tbMsg, (TbQueueCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void changeOwnerIfRequired(TenantId tenantId, CustomerId customerId, EntityId entityId) throws ThingsboardException {
        EntityId newOwnerId = this.getOwnerId(tenantId, customerId);
        switch (2.$SwitchMap$org$thingsboard$server$common$data$EntityType[entityId.getEntityType().ordinal()]) {
            case 1: {
                Device device = this.edgeCtx.getDeviceService().findDeviceById(tenantId, new DeviceId(entityId.getId()));
                EntityId currentOwnerId = device.getOwnerId();
                if (newOwnerId.equals(currentOwnerId) || !this.checkIfNewOwnerIsCustomerAndExists(tenantId, newOwnerId)) break;
                this.ownersCacheService.changeDeviceOwner(tenantId, newOwnerId, device);
                break;
            }
            case 2: {
                Asset asset = this.edgeCtx.getAssetService().findAssetById(tenantId, new AssetId(entityId.getId()));
                EntityId currentOwnerId = asset.getOwnerId();
                if (newOwnerId.equals(currentOwnerId) || !this.checkIfNewOwnerIsCustomerAndExists(tenantId, newOwnerId)) break;
                this.ownersCacheService.changeAssetOwner(tenantId, newOwnerId, asset);
                break;
            }
            case 3: {
                EntityView entityView = this.edgeCtx.getEntityViewService().findEntityViewById(tenantId, new EntityViewId(entityId.getId()));
                EntityId currentOwnerId = entityView.getOwnerId();
                if (newOwnerId.equals(currentOwnerId) || !this.checkIfNewOwnerIsCustomerAndExists(tenantId, newOwnerId)) break;
                this.ownersCacheService.changeEntityViewOwner(tenantId, newOwnerId, entityView);
                break;
            }
            case 7: {
                User user = this.edgeCtx.getUserService().findUserById(tenantId, new UserId(entityId.getId()));
                EntityId currentOwnerId = user.getOwnerId();
                if (newOwnerId.equals(currentOwnerId) || !this.checkIfNewOwnerIsCustomerAndExists(tenantId, newOwnerId)) break;
                this.ownersCacheService.changeUserOwner(tenantId, newOwnerId, user);
                break;
            }
            case 4: {
                Dashboard dashboard = this.edgeCtx.getDashboardService().findDashboardById(tenantId, new DashboardId(entityId.getId()));
                EntityId currentOwnerId = dashboard.getOwnerId();
                if (newOwnerId.equals(currentOwnerId) || !this.checkIfNewOwnerIsCustomerAndExists(tenantId, newOwnerId)) break;
                this.ownersCacheService.changeDashboardOwner(tenantId, newOwnerId, dashboard);
                break;
            }
            case 6: {
                Customer customer = this.edgeCtx.getCustomerService().findCustomerById(tenantId, new CustomerId(entityId.getId()));
                EntityId currentOwnerId = customer.getOwnerId();
                if (newOwnerId.equals(currentOwnerId) || !this.checkIfNewOwnerIsCustomerAndExists(tenantId, newOwnerId)) break;
                this.ownersCacheService.changeCustomerOwner(tenantId, newOwnerId, customer);
                break;
            }
            case 8: {
                Edge edge = this.edgeCtx.getEdgeService().findEdgeById(tenantId, new EdgeId(entityId.getId()));
                EntityId currentOwnerId = edge.getOwnerId();
                if (newOwnerId.equals(currentOwnerId) || !this.checkIfNewOwnerIsCustomerAndExists(tenantId, newOwnerId)) break;
                this.ownersCacheService.changeEdgeOwner(tenantId, newOwnerId, edge);
            }
        }
    }

    private boolean checkIfNewOwnerIsCustomerAndExists(TenantId tenantId, EntityId newOwnerId) {
        if (EntityType.TENANT.equals((Object)newOwnerId.getEntityType())) {
            return true;
        }
        if (EntityId.NULL_UUID.equals(newOwnerId.getId())) {
            return false;
        }
        Customer customerById = this.edgeCtx.getCustomerService().findCustomerById(tenantId, new CustomerId(newOwnerId.getId()));
        return customerById != null;
    }

    protected boolean isCustomerNotExists(TenantId tenantId, CustomerId customerId) {
        if (customerId == null || EntityId.NULL_UUID.equals(customerId.getId())) {
            return false;
        }
        Customer customerById = this.edgeCtx.getCustomerService().findCustomerById(tenantId, customerId);
        return customerById == null;
    }

    private EntityId getOwnerId(TenantId tenantId, CustomerId customerId) {
        return customerId != null && !customerId.isNullUid() ? customerId : tenantId;
    }

    protected void safeAddEntityToGroup(TenantId tenantId, EntityGroupId entityGroupId, EntityId entityId) {
        EntityGroup entityGroup;
        if (entityGroupId != null && !ModelConstants.NULL_UUID.equals(entityGroupId.getId()) && (entityGroup = this.edgeCtx.getEntityGroupService().findEntityGroupById(tenantId, entityGroupId)) != null) {
            this.edgeCtx.getEntityGroupService().addEntityToEntityGroup(tenantId, entityGroupId, entityId);
        }
    }

    protected ListenableFuture<Void> removeEntityIfInSingleAllGroup(TenantId tenantId, EntityId entityId, Runnable provider) {
        try {
            List list = (List)this.edgeCtx.getEntityGroupService().findEntityGroupsForEntityAsync(tenantId, entityId).get();
            if (list.size() == 1) {
                provider.run();
            }
        }
        catch (Exception e) {
            log.error("Failed to remove entity from group", (Throwable)e);
        }
        return Futures.immediateFuture(null);
    }

    protected boolean isSaveRequired(HasVersion current, HasVersion updated) {
        updated.setVersion(null);
        return !updated.equals(current);
    }

    protected <I extends EntityId, E extends HasName & HasId<I>> Optional<String> generateUniqueNameIfDuplicateExists(TenantId tenantId, I entityId, E entity, @Nullable E entityWithSameName) {
        if (entityWithSameName == null || ((EntityId)((HasId<I>)entityWithSameName).getId()).equals(entityId)) {
            return Optional.empty();
        }
        String currentName = entity.getName();
        String newEntityName = BaseEdgeProcessor.generateRandomAlphabeticString((String)currentName);
        log.warn("[{}] Entity with name '{}' already exists (id={}). Renaming to '{}'", new Object[]{tenantId, currentName, ((HasId<I>)entityWithSameName).getId(), newEntityName});
        return Optional.of(newEntityName);
    }

    protected static String generateRandomAlphabeticString(String prefix) {
        return prefix + "_" + StringUtils.randomAlphabetic((int)15);
    }

    protected <T extends HasOwnerId & HasId<? extends EntityId>> void addEntityToEdgeAllGroup(TenantId tenantId, Edge edge, T entity) {
        if (entity == null) {
            return;
        }
        EntityId entityId = (EntityId)((HasId<? extends EntityId>)entity).getId();
        EntityType entityType = entityId.getEntityType();
        try {
            EntityType ownerType = entity.getOwnerId().getEntityType();
            EntityGroup edgeEntityGroup = (EntityGroup)this.edgeCtx.getEntityGroupService().findOrCreateEdgeAllGroupAsync(tenantId, edge, edge.getName(), ownerType, entityType).get();
            if (edgeEntityGroup != null) {
                this.edgeCtx.getEntityGroupService().addEntityToEntityGroup(tenantId, edgeEntityGroup.getId(), entityId);
            }
        }
        catch (Exception e) {
            log.warn("[{}] Can't add entity to edge {} 'All' group, entity id [{}]", new Object[]{tenantId, entityType, entityId, e});
            throw new RuntimeException(e);
        }
    }

    protected <T extends HasOwnerId & HasId<? extends EntityId>> void removeEntityFromEdgeAllGroup(TenantId tenantId, Edge edge, T entity) {
        if (entity == null) {
            return;
        }
        EntityId entityId = (EntityId)((HasId<? extends EntityId>)entity).getId();
        EntityType entityType = entityId.getEntityType();
        try {
            EntityType ownerType = entity.getOwnerId().getEntityType();
            EntityGroup edgeEntityGroup = (EntityGroup)this.edgeCtx.getEntityGroupService().findOrCreateEdgeAllGroupAsync(tenantId, edge, edge.getName(), ownerType, entityType).get();
            if (edgeEntityGroup != null) {
                this.edgeCtx.getEntityGroupService().removeEntityFromEntityGroup(tenantId, edgeEntityGroup.getId(), entityId);
            }
        }
        catch (Exception e) {
            log.warn("[{}] Can't delete entity from edge {} 'All' group, entity id [{}]", new Object[]{tenantId, entityType, entityId, e});
            throw new RuntimeException(e);
        }
    }
}

