/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.fetch;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.report.ReportTemplateInfo;
import org.thingsboard.server.common.data.report.ReportTemplateQuery;
import org.thingsboard.server.dao.report.ReportTemplateService;
import org.thingsboard.server.service.edge.rpc.fetch.BasePageableEdgeEventFetcher;

public class ReportTemplateEdgeEventFetcher
extends BasePageableEdgeEventFetcher<ReportTemplateInfo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReportTemplateEdgeEventFetcher.class);
    private final ReportTemplateService reportTemplateService;
    private final CustomerId customerId;

    PageData<ReportTemplateInfo> fetchEntities(TenantId tenantId, Edge edge, PageLink pageLink) {
        ReportTemplateQuery query = new ReportTemplateQuery(pageLink, false, null, null);
        if (this.customerId == null) {
            return this.reportTemplateService.findReportTemplates(tenantId, query);
        }
        return this.reportTemplateService.findCustomerReportTemplates(tenantId, this.customerId, query);
    }

    EdgeEvent constructEdgeEvent(TenantId tenantId, Edge edge, ReportTemplateInfo reportTemplateInfo) {
        return EdgeUtils.constructEdgeEvent((TenantId)tenantId, (EdgeId)edge.getId(), (EdgeEventType)EdgeEventType.REPORT_TEMPLATE, (EdgeEventActionType)EdgeEventActionType.ADDED, (EntityId)reportTemplateInfo.getId(), null);
    }

    @ConstructorProperties(value={"reportTemplateService", "customerId"})
    @Generated
    public ReportTemplateEdgeEventFetcher(ReportTemplateService reportTemplateService, CustomerId customerId) {
        this.reportTemplateService = reportTemplateService;
        this.customerId = customerId;
    }
}

