/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.fetch;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.service.edge.rpc.fetch.EdgeEventFetcher;

public class PublicCustomerUserGroupEdgeEventFetcher
implements EdgeEventFetcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PublicCustomerUserGroupEdgeEventFetcher.class);
    private final CustomerService customerService;
    private final EntityId ownerId;

    public PageLink getPageLink(int pageSize) {
        return new PageLink(pageSize);
    }

    public PageData<EdgeEvent> fetchEdgeEvents(TenantId tenantId, Edge edge, PageLink pageLink) {
        ArrayList<EdgeEvent> result = new ArrayList<EdgeEvent>();
        EntityGroup publicUserGroup = this.customerService.findOrCreatePublicUserGroup(tenantId, this.ownerId);
        result.add(EdgeUtils.constructEdgeEvent((TenantId)edge.getTenantId(), (EdgeId)edge.getId(), (EdgeEventType)EdgeEventType.ENTITY_GROUP, (EdgeEventActionType)EdgeEventActionType.ADDED, (EntityId)publicUserGroup.getId(), null));
        return new PageData(result, 1, (long)result.size(), false);
    }

    @ConstructorProperties(value={"customerService", "ownerId"})
    @Generated
    public PublicCustomerUserGroupEdgeEventFetcher(CustomerService customerService, EntityId ownerId) {
        this.customerService = customerService;
        this.ownerId = ownerId;
    }
}

