/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.fetch;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.group.EntityGroupService;
import org.thingsboard.server.service.edge.rpc.fetch.EdgeEventFetcher;

public class EntityGroupEdgeEventFetcher
implements EdgeEventFetcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntityGroupEdgeEventFetcher.class);
    private final EntityGroupService entityGroupService;
    private final EntityType groupType;

    public PageLink getPageLink(int pageSize) {
        return new PageLink(pageSize);
    }

    public PageData<EdgeEvent> fetchEdgeEvents(TenantId tenantId, Edge edge, PageLink pageLink) {
        log.trace("[{}] start fetching edge events [{}], groupType {}, pageLink {}", new Object[]{tenantId, edge.getId(), this.groupType, pageLink});
        PageData pageData = this.entityGroupService.findEdgeEntityGroupsByType(tenantId, edge.getId(), this.groupType, pageLink);
        ArrayList<EdgeEvent> result = new ArrayList<EdgeEvent>();
        if (!pageData.getData().isEmpty()) {
            for (EntityGroup entityGroup : pageData.getData()) {
                result.add(EdgeUtils.constructEdgeEvent((TenantId)tenantId, (EdgeId)edge.getId(), (EdgeEventType)EdgeEventType.ENTITY_GROUP, (EdgeEventActionType)EdgeEventActionType.ADDED, (EntityId)entityGroup.getId(), null, null));
            }
        }
        return new PageData(result, pageData.getTotalPages(), pageData.getTotalElements(), pageData.hasNext());
    }

    @ConstructorProperties(value={"entityGroupService", "groupType"})
    @Generated
    public EntityGroupEdgeEventFetcher(EntityGroupService entityGroupService, EntityType groupType) {
        this.entityGroupService = entityGroupService;
        this.groupType = groupType;
    }

    @Generated
    public EntityType getGroupType() {
        return this.groupType;
    }
}

