/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.fetch;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.service.edge.rpc.fetch.BasePageableEdgeEventFetcher;

public class CustomerEdgeEventFetcher
extends BasePageableEdgeEventFetcher<Customer> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomerEdgeEventFetcher.class);
    private final CustomerService customerService;
    private final CustomerId ownerId;

    PageData<Customer> fetchEntities(TenantId tenantId, Edge edge, PageLink pageLink) {
        List customersHierarchy = this.getCustomersHierarchy(tenantId, this.ownerId);
        return new PageData(customersHierarchy, 1, (long)customersHierarchy.size(), false);
    }

    List<Customer> getCustomersHierarchy(TenantId tenantId, CustomerId customerId) {
        ArrayList<Customer> result = new ArrayList<Customer>();
        Customer customerById = this.customerService.findCustomerById(tenantId, customerId);
        result.add(customerById);
        if (customerById != null && customerById.isPublic()) {
            return result;
        }
        Customer publicCustomer = this.customerService.findPublicCustomer(tenantId, (EntityId)customerId);
        if (publicCustomer != null) {
            result.add(publicCustomer);
        }
        if (customerById != null && customerById.getParentCustomerId() != null && !customerById.getParentCustomerId().isNullUid()) {
            result.addAll(this.getCustomersHierarchy(tenantId, customerById.getParentCustomerId()));
        }
        return result;
    }

    EdgeEvent constructEdgeEvent(TenantId tenantId, Edge edge, Customer customer) {
        return EdgeUtils.constructEdgeEvent((TenantId)edge.getTenantId(), (EdgeId)edge.getId(), (EdgeEventType)EdgeEventType.CUSTOMER, (EdgeEventActionType)EdgeEventActionType.ADDED, (EntityId)customer.getId(), null);
    }

    @ConstructorProperties(value={"customerService", "ownerId"})
    @Generated
    public CustomerEdgeEventFetcher(CustomerService customerService, CustomerId ownerId) {
        this.customerService = customerService;
        this.ownerId = ownerId;
    }
}

