/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.fetch;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.CustomMenuId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.menu.CustomMenu;
import org.thingsboard.server.common.data.menu.CustomMenuFilter;
import org.thingsboard.server.common.data.menu.CustomMenuInfo;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.menu.CustomMenuService;
import org.thingsboard.server.service.edge.rpc.fetch.EdgeEventFetcher;

public class CustomMenuEdgeEventFetcher
implements EdgeEventFetcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomMenuEdgeEventFetcher.class);
    private final CustomMenuService customMenuService;

    public PageLink getPageLink(int pageSize) {
        return new PageLink(pageSize);
    }

    public PageData<EdgeEvent> fetchEdgeEvents(TenantId tenantId, Edge edge, PageLink pageLink) throws Exception {
        CustomMenuFilter customMenuFilter = CustomMenuFilter.builder().tenantId(tenantId).customerId(edge.getCustomerId()).scope(null).assigneeType(null).build();
        PageData customMenuInfos = this.customMenuService.findCustomMenuInfos(tenantId, customMenuFilter, pageLink);
        ArrayList<EdgeEvent> events = new ArrayList<EdgeEvent>();
        for (CustomMenuInfo cm : customMenuInfos.getData()) {
            CustomMenu customMenu = this.customMenuService.findCustomMenuById(cm.getTenantId(), (CustomMenuId)cm.getId());
            events.add(EdgeUtils.constructEdgeEvent((TenantId)tenantId, (EdgeId)edge.getId(), (EdgeEventType)EdgeEventType.CUSTOM_MENU, (EdgeEventActionType)EdgeEventActionType.UPDATED, null, (JsonNode)JacksonUtil.valueToTree((Object)customMenu)));
        }
        return new PageData(events, customMenuInfos.getTotalPages(), customMenuInfos.getTotalElements(), customMenuInfos.hasNext());
    }

    @ConstructorProperties(value={"customMenuService"})
    @Generated
    public CustomMenuEdgeEventFetcher(CustomMenuService customMenuService) {
        this.customMenuService = customMenuService;
    }
}

