/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc;

import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import lombok.Generated;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.service.edge.EdgeContextComponent;
import org.thingsboard.server.service.edge.rpc.fetch.AdminSettingsEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.AiModelEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.AssetProfilesEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.CustomMenuEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.CustomTranslationEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.CustomerEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.CustomerRolesEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.DefaultProfilesEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.DeviceGroupOtaPackageEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.DeviceProfilesEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.EdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.EncryptionKeyEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.EntityGroupEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.IntegrationsEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.NotificationRuleEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.NotificationTargetEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.NotificationTemplateEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.OAuth2EdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.OtaPackagesEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.PublicCustomerUserGroupEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.QueuesEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.ReportTemplateEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.RuleChainsEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.SchedulerEventsEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.SecretEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.SysAdminRolesEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.SystemCustomMenuEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.SystemWidgetTypesEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.SystemWidgetsBundlesEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.TenantEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.TenantResourcesEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.TenantRolesEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.TenantWidgetTypesEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.TenantWidgetsBundlesEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.WhiteLabelingEdgeEventFetcher;

public class EdgeSyncCursor {
    private final List<EdgeEventFetcher> fetchers = new LinkedList();
    private int currentIdx = 0;

    public EdgeSyncCursor(EdgeContextComponent ctx, Edge edge, boolean fullSync) {
        Customer publicCustomer;
        if (fullSync) {
            this.fetchers.add(new TenantEdgeEventFetcher(ctx.getTenantService()));
            this.fetchers.add(new QueuesEdgeEventFetcher(ctx.getQueueService()));
            this.fetchers.add(new AdminSettingsEdgeEventFetcher(ctx.getAdminSettingsService()));
            this.fetchers.add(new RuleChainsEdgeEventFetcher(ctx.getRuleChainService()));
            this.fetchers.add(new SysAdminRolesEdgeEventFetcher(ctx.getRoleService()));
            this.fetchers.add(new TenantRolesEdgeEventFetcher(ctx.getRoleService()));
            this.fetchers.add(new OAuth2EdgeEventFetcher(ctx.getDomainService(), TenantId.SYS_TENANT_ID, new CustomerId(CustomerId.NULL_UUID)));
            this.fetchers.add(new OAuth2EdgeEventFetcher(ctx.getDomainService(), edge.getTenantId(), new CustomerId(CustomerId.NULL_UUID)));
            if (EntityType.CUSTOMER.equals((Object)edge.getOwnerId().getEntityType())) {
                this.addCustomerOAuth2EdgeEventFetchers(ctx, edge.getTenantId(), new CustomerId(edge.getOwnerId().getId()));
            }
            this.fetchers.add(new WhiteLabelingEdgeEventFetcher(ctx.getCustomerService()));
            this.fetchers.add(new SystemWidgetTypesEdgeEventFetcher(ctx.getWidgetTypeService()));
            this.fetchers.add(new TenantWidgetTypesEdgeEventFetcher(ctx.getWidgetTypeService()));
            this.fetchers.add(new SystemWidgetsBundlesEdgeEventFetcher(ctx.getWidgetsBundleService()));
            this.fetchers.add(new TenantWidgetsBundlesEdgeEventFetcher(ctx.getWidgetsBundleService()));
            this.fetchers.add(new AiModelEdgeEventFetcher(ctx.getAiModelService()));
        }
        if ((publicCustomer = ctx.getCustomerService().findPublicCustomer(edge.getTenantId(), (EntityId)edge.getTenantId())) != null) {
            this.fetchers.add(new CustomerEdgeEventFetcher(ctx.getCustomerService(), publicCustomer.getId()));
            this.fetchers.add(new CustomerRolesEdgeEventFetcher(ctx.getRoleService(), publicCustomer.getId()));
            this.fetchers.add(new PublicCustomerUserGroupEdgeEventFetcher(ctx.getCustomerService(), (EntityId)edge.getTenantId()));
        }
        if (EntityType.CUSTOMER.equals((Object)edge.getOwnerId().getEntityType())) {
            CustomerId customerId = new CustomerId(edge.getOwnerId().getId());
            this.fetchers.add(new CustomerEdgeEventFetcher(ctx.getCustomerService(), customerId));
            this.addCustomerRolesEdgeEventFetchers(ctx, edge.getTenantId(), customerId);
        }
        this.fetchers.add(new EntityGroupEdgeEventFetcher(ctx.getEntityGroupService(), EntityType.DASHBOARD));
        this.fetchers.add(new DefaultProfilesEdgeEventFetcher(ctx.getDeviceProfileService(), ctx.getAssetProfileService()));
        this.fetchers.add(new DeviceProfilesEdgeEventFetcher(ctx.getDeviceProfileService()));
        this.fetchers.add(new AssetProfilesEdgeEventFetcher(ctx.getAssetProfileService()));
        this.fetchers.add(new EntityGroupEdgeEventFetcher(ctx.getEntityGroupService(), EntityType.USER));
        this.fetchers.add(new EntityGroupEdgeEventFetcher(ctx.getEntityGroupService(), EntityType.ASSET));
        this.fetchers.add(new EntityGroupEdgeEventFetcher(ctx.getEntityGroupService(), EntityType.DEVICE));
        this.fetchers.add(new EntityGroupEdgeEventFetcher(ctx.getEntityGroupService(), EntityType.ENTITY_VIEW));
        this.fetchers.add(new SchedulerEventsEdgeEventFetcher(ctx.getSchedulerEventService()));
        if (fullSync) {
            this.fetchers.add(new NotificationTemplateEdgeEventFetcher(ctx.getNotificationTemplateService()));
            this.fetchers.add(new NotificationTargetEdgeEventFetcher(ctx.getNotificationTargetService()));
            this.fetchers.add(new NotificationRuleEdgeEventFetcher(ctx.getNotificationRuleService()));
            this.fetchers.add(new IntegrationsEdgeEventFetcher(ctx.getIntegrationService()));
            this.fetchers.add(new OtaPackagesEdgeEventFetcher(ctx.getOtaPackageService()));
            this.fetchers.add(new DeviceProfilesEdgeEventFetcher(ctx.getDeviceProfileService()));
            this.fetchers.add(new TenantResourcesEdgeEventFetcher(ctx.getResourceService()));
            this.fetchers.add(new DeviceGroupOtaPackageEdgeEventFetcher(ctx.getDeviceGroupOtaPackageService(), ctx.getEntityGroupService()));
            this.fetchers.add(new CustomTranslationEdgeEventFetcher(ctx.getCustomerService(), ctx.getCustomTranslationService()));
            this.fetchers.add(new SystemCustomMenuEdgeEventFetcher(ctx.getCustomMenuService()));
            this.fetchers.add(new CustomMenuEdgeEventFetcher(ctx.getCustomMenuService()));
            this.fetchers.add(new EncryptionKeyEdgeEventFetcher(ctx.getEncryptionService()));
            this.fetchers.add(new SecretEdgeEventFetcher(ctx.getSecretService()));
            this.fetchers.add(new ReportTemplateEdgeEventFetcher(ctx.getReportTemplateService(), null));
            if (EntityType.CUSTOMER.equals((Object)edge.getOwnerId().getEntityType())) {
                this.fetchers.add(new ReportTemplateEdgeEventFetcher(ctx.getReportTemplateService(), new CustomerId(edge.getOwnerId().getId())));
            }
        }
    }

    private void addCustomerRolesEdgeEventFetchers(EdgeContextComponent ctx, TenantId tenantId, CustomerId customerId) {
        Customer customerById;
        this.fetchers.add(new CustomerRolesEdgeEventFetcher(ctx.getRoleService(), customerId));
        Customer publicCustomer = ctx.getCustomerService().findPublicCustomer(tenantId, (EntityId)customerId);
        if (publicCustomer != null) {
            this.fetchers.add(new CustomerRolesEdgeEventFetcher(ctx.getRoleService(), publicCustomer.getId()));
            this.fetchers.add(new PublicCustomerUserGroupEdgeEventFetcher(ctx.getCustomerService(), (EntityId)customerId));
        }
        if ((customerById = ctx.getCustomerService().findCustomerById(tenantId, customerId)) != null && customerById.getParentCustomerId() != null && !customerById.getParentCustomerId().isNullUid()) {
            this.addCustomerRolesEdgeEventFetchers(ctx, tenantId, customerById.getParentCustomerId());
        }
    }

    private void addCustomerOAuth2EdgeEventFetchers(EdgeContextComponent ctx, TenantId tenantId, CustomerId customerId) {
        this.fetchers.add(new OAuth2EdgeEventFetcher(ctx.getDomainService(), tenantId, customerId));
        Customer customerById = ctx.getCustomerService().findCustomerById(tenantId, customerId);
        if (customerById != null && customerById.getParentCustomerId() != null && !customerById.getParentCustomerId().isNullUid()) {
            this.addCustomerOAuth2EdgeEventFetchers(ctx, tenantId, customerById.getParentCustomerId());
        }
    }

    public boolean hasNext() {
        return this.fetchers.size() > this.currentIdx;
    }

    public EdgeEventFetcher getNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        EdgeEventFetcher edgeEventFetcher = (EdgeEventFetcher)this.fetchers.get(this.currentIdx);
        ++this.currentIdx;
        return edgeEventFetcher;
    }

    @Generated
    public List<EdgeEventFetcher> getFetchers() {
        return this.fetchers;
    }

    @Generated
    public int getCurrentIdx() {
        return this.currentIdx;
    }
}

