/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.WidgetTypeId;
import org.thingsboard.server.common.data.widget.WidgetType;
import org.thingsboard.server.common.data.widget.WidgetTypeDetails;
import org.thingsboard.server.gen.edge.v1.WidgetTypeUpdateMsg;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.cloud.rpc.processor.WidgetTypeCloudProcessor;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

@Component
@TbCoreComponent
public class WidgetTypeCloudProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WidgetTypeCloudProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ListenableFuture<Void> processWidgetTypeMsgFromCloud(TenantId tenantId, WidgetTypeUpdateMsg widgetTypeUpdateMsg) {
        WidgetTypeId widgetTypeId = new WidgetTypeId(new UUID(widgetTypeUpdateMsg.getIdMSB(), widgetTypeUpdateMsg.getIdLSB()));
        try {
            this.cloudSynchronizationManager.getSync().set(true);
            switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[widgetTypeUpdateMsg.getMsgType().ordinal()]) {
                case 1: 
                case 2: {
                    widgetCreationLock.lock();
                    try {
                        WidgetTypeDetails widgetTypeDetails = (WidgetTypeDetails)JacksonUtil.fromString((String)widgetTypeUpdateMsg.getEntity(), WidgetTypeDetails.class, (boolean)true);
                        if (widgetTypeDetails == null) {
                            throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] widgetTypeUpdateMsg {" + String.valueOf(widgetTypeUpdateMsg) + "} cannot be converted to widget type");
                        }
                        WidgetType widgetTypeByTenantIdAndFqn = this.edgeCtx.getWidgetTypeService().findWidgetTypeByTenantIdAndFqn(widgetTypeDetails.getTenantId(), widgetTypeDetails.getFqn());
                        if (widgetTypeByTenantIdAndFqn != null && !widgetTypeByTenantIdAndFqn.getId().equals((Object)widgetTypeDetails.getId())) {
                            this.edgeCtx.getWidgetTypeService().deleteWidgetType(widgetTypeByTenantIdAndFqn.getTenantId(), widgetTypeByTenantIdAndFqn.getId());
                        }
                        this.edgeCtx.getWidgetTypeService().saveWidgetType(widgetTypeDetails, false);
                        return Futures.immediateFuture(null);
                    }
                    finally {
                        widgetCreationLock.unlock();
                    }
                }
                case 3: {
                    WidgetType widgetType = this.edgeCtx.getWidgetTypeService().findWidgetTypeById(tenantId, widgetTypeId);
                    if (widgetType == null) return Futures.immediateFuture(null);
                    this.edgeCtx.getWidgetTypeService().deleteWidgetType(tenantId, widgetType.getId());
                    return Futures.immediateFuture(null);
                }
                case 4: {
                    ListenableFuture listenableFuture = this.handleUnsupportedMsgType(widgetTypeUpdateMsg.getMsgType());
                    return listenableFuture;
                }
            }
            return Futures.immediateFuture(null);
        }
        finally {
            this.cloudSynchronizationManager.getSync().remove();
        }
    }
}

