/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.cloud.CloudEvent;
import org.thingsboard.server.common.data.cloud.CloudEventType;
import org.thingsboard.server.common.data.id.ReportTemplateId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.report.ReportTemplate;
import org.thingsboard.server.gen.edge.v1.ReportTemplateUpdateMsg;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.gen.edge.v1.UplinkMsg;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.cloud.rpc.processor.ReportTemplateCloudProcessor;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.report.BaseReportTemplateProcessor;

@Component
@TbCoreComponent
public class ReportTemplateCloudProcessor
extends BaseReportTemplateProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReportTemplateCloudProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ListenableFuture<Void> processReportTemplateMsgFromCloud(TenantId tenantId, ReportTemplateUpdateMsg reportTemplateUpdateMsg) {
        ReportTemplateId reportTemplateId = new ReportTemplateId(new UUID(reportTemplateUpdateMsg.getIdMSB(), reportTemplateUpdateMsg.getIdLSB()));
        try {
            this.cloudSynchronizationManager.getSync().set(true);
            switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[reportTemplateUpdateMsg.getMsgType().ordinal()]) {
                case 1: 
                case 2: {
                    Boolean created = super.saveOrUpdateReportTemplate(tenantId, reportTemplateId, reportTemplateUpdateMsg);
                    if (created == false) return Futures.immediateFuture(null);
                    this.pushReportTemplateCreatedEventToRuleEngine(tenantId, reportTemplateId);
                    ListenableFuture listenableFuture = Futures.immediateFuture(null);
                    return listenableFuture;
                }
                case 3: {
                    this.deleteReportTemplate(tenantId, reportTemplateId);
                }
                case 4: {
                    ListenableFuture listenableFuture = this.handleUnsupportedMsgType(reportTemplateUpdateMsg.getMsgType());
                    return listenableFuture;
                }
            }
            return Futures.immediateFuture(null);
        }
        finally {
            this.cloudSynchronizationManager.getSync().remove();
        }
    }

    public UplinkMsg convertCloudEventToUplink(CloudEvent cloudEvent) {
        ReportTemplateId reportTemplateId = new ReportTemplateId(cloudEvent.getEntityId());
        switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[cloudEvent.getAction().ordinal()]) {
            case 1: 
            case 2: {
                ReportTemplate reportTemplate = this.edgeCtx.getReportTemplateService().findReportTemplateById(cloudEvent.getTenantId(), reportTemplateId);
                if (reportTemplate != null) {
                    UpdateMsgType msgType = this.getUpdateMsgType(cloudEvent.getAction());
                    ReportTemplateUpdateMsg reportTemplateUpdateMsg = EdgeMsgConstructorUtils.constructReportTemplateUpdatedMsg((UpdateMsgType)msgType, (ReportTemplate)reportTemplate);
                    return UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addReportTemplateUpdateMsg(reportTemplateUpdateMsg).build();
                }
                log.info("Skipping event as report template was not found [{}]", (Object)cloudEvent);
                break;
            }
            case 3: {
                ReportTemplateUpdateMsg reportTemplateUpdateMsg = EdgeMsgConstructorUtils.constructReportTemplateDeleteMsg((ReportTemplateId)reportTemplateId);
                return UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addReportTemplateUpdateMsg(reportTemplateUpdateMsg).build();
            }
        }
        return null;
    }

    public CloudEventType getCloudEventType() {
        return CloudEventType.REPORT_TEMPLATE;
    }

    private void pushReportTemplateCreatedEventToRuleEngine(TenantId tenantId, ReportTemplateId reportTemplateId) {
        ReportTemplate reportTemplate = this.edgeCtx.getReportTemplateService().findReportTemplateById(tenantId, reportTemplateId);
        this.pushReportTemplateEventToRuleEngine(tenantId, reportTemplate, TbMsgType.ENTITY_CREATED);
    }
}

