/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.EntityView;
import org.thingsboard.server.common.data.cloud.CloudEvent;
import org.thingsboard.server.common.data.cloud.CloudEventType;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityViewId;
import org.thingsboard.server.common.data.id.HasId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.gen.edge.v1.EntityViewUpdateMsg;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.gen.edge.v1.UplinkMsg;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.cloud.rpc.processor.EntityViewCloudProcessor;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.entityview.BaseEntityViewProcessor;

@Component
@TbCoreComponent
public class EntityViewCloudProcessor
extends BaseEntityViewProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntityViewCloudProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> processEntityViewMsgFromCloud(TenantId tenantId, EntityViewUpdateMsg entityViewUpdateMsg) throws ThingsboardException {
        EntityViewId entityViewId = new EntityViewId(new UUID(entityViewUpdateMsg.getIdMSB(), entityViewUpdateMsg.getIdLSB()));
        try {
            this.cloudSynchronizationManager.getSync().set(true);
            ListenableFuture listenableFuture = switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[entityViewUpdateMsg.getMsgType().ordinal()]) {
                case 1, 2 -> {
                    boolean created = this.saveOrUpdateEntityViewFromCloud(tenantId, entityViewId, entityViewUpdateMsg);
                    if (created) {
                        yield this.requestForAdditionalData(tenantId, (EntityId)entityViewId);
                    }
                    yield Futures.immediateFuture(null);
                }
                case 3 -> {
                    if (entityViewUpdateMsg.hasEntityGroupIdMSB() && entityViewUpdateMsg.hasEntityGroupIdLSB()) {
                        UUID entityGroupUUID = this.safeGetUUID(entityViewUpdateMsg.getEntityGroupIdMSB(), entityViewUpdateMsg.getEntityGroupIdLSB());
                        EntityGroupId entityGroupId = new EntityGroupId(entityGroupUUID);
                        this.edgeCtx.getEntityGroupService().removeEntityFromEntityGroup(tenantId, entityGroupId, (EntityId)entityViewId);
                        yield this.removeEntityIfInSingleAllGroup(tenantId, (EntityId)entityViewId, () -> this.edgeCtx.getEntityViewService().deleteEntityView(tenantId, entityViewId));
                    }
                    this.deleteEntityView(tenantId, entityViewId);
                    yield Futures.immediateFuture(null);
                }
                default -> this.handleUnsupportedMsgType(entityViewUpdateMsg.getMsgType());
            };
            return listenableFuture;
        }
        finally {
            this.cloudSynchronizationManager.getSync().remove();
        }
    }

    private boolean saveOrUpdateEntityViewFromCloud(TenantId tenantId, EntityViewId entityViewId, EntityViewUpdateMsg entityViewUpdateMsg) throws ThingsboardException {
        Boolean entityViewNameUpdated;
        Pair resultPair = super.saveOrUpdateEntityView(tenantId, entityViewId, entityViewUpdateMsg);
        Boolean created = (Boolean)resultPair.getFirst();
        if (created.booleanValue()) {
            this.pushEntityViewCreatedEventToRuleEngine(tenantId, entityViewId);
        }
        if ((entityViewNameUpdated = (Boolean)resultPair.getSecond()).booleanValue()) {
            this.cloudEventService.saveCloudEventAsync(tenantId, CloudEventType.ENTITY_VIEW, EdgeEventActionType.UPDATED, (EntityId)entityViewId, null, null);
        }
        return created;
    }

    private void pushEntityViewCreatedEventToRuleEngine(TenantId tenantId, EntityViewId entityViewId) {
        EntityView entityView = this.edgeCtx.getEntityViewService().findEntityViewById(tenantId, entityViewId);
        this.pushEntityEventToRuleEngine(tenantId, (HasId)entityView, TbMsgType.ENTITY_CREATED);
    }

    public UplinkMsg convertCloudEventToUplink(CloudEvent cloudEvent) {
        EntityViewId entityViewId = new EntityViewId(cloudEvent.getEntityId());
        EntityGroupId entityGroupId = cloudEvent.getEntityGroupId() != null ? new EntityGroupId(cloudEvent.getEntityGroupId()) : null;
        switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[cloudEvent.getAction().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                EntityView entityView = this.edgeCtx.getEntityViewService().findEntityViewById(cloudEvent.getTenantId(), entityViewId);
                if (entityView != null) {
                    UpdateMsgType msgType = this.getUpdateMsgType(cloudEvent.getAction());
                    EntityViewUpdateMsg entityViewUpdateMsg = EdgeMsgConstructorUtils.constructEntityViewUpdatedMsg((UpdateMsgType)msgType, (EntityView)entityView, (EntityGroupId)entityGroupId);
                    return UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addEntityViewUpdateMsg(entityViewUpdateMsg).build();
                }
                log.info("Skipping event as entity view was not found [{}]", (Object)cloudEvent);
                break;
            }
            case 4: 
            case 5: {
                EntityViewUpdateMsg entityViewUpdateMsg = EdgeMsgConstructorUtils.constructEntityViewDeleteMsg((EntityViewId)entityViewId, (EntityGroupId)entityGroupId);
                return UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addEntityViewUpdateMsg(entityViewUpdateMsg).build();
            }
        }
        return null;
    }

    protected void setCustomerId(TenantId tenantId, CustomerId customerId, EntityView entityView, EntityViewUpdateMsg entityViewUpdateMsg) {
        if (this.isCustomerNotExists(tenantId, entityView.getCustomerId())) {
            entityView.setCustomerId(null);
        }
    }

    public CloudEventType getCloudEventType() {
        return CloudEventType.ENTITY_VIEW;
    }
}

