/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.translation.CustomTranslation;
import org.thingsboard.server.gen.edge.v1.CustomTranslationUpdateMsg;
import org.thingsboard.server.service.cloud.rpc.processor.CustomTranslationCloudProcessor;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

@Component
public class CustomTranslationCloudProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomTranslationCloudProcessor.class);

    public ListenableFuture<Void> processCustomTranslationMsgFromCloud(TenantId tenantId, CustomTranslationUpdateMsg customTranslationUpdateMsg) {
        try {
            CustomTranslation customTranslation = (CustomTranslation)JacksonUtil.fromString((String)customTranslationUpdateMsg.getEntity(), CustomTranslation.class, (boolean)true);
            if (customTranslation == null) {
                throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] customTranslationUpdateMsg {" + String.valueOf(customTranslationUpdateMsg) + "} cannot be converted to custom translation");
            }
            switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[customTranslationUpdateMsg.getMsgType().ordinal()]) {
                case 1: 
                case 2: {
                    this.edgeCtx.getCustomTranslationService().saveCustomTranslation(customTranslation);
                    break;
                }
                case 3: {
                    this.edgeCtx.getCustomTranslationService().deleteCustomTranslation(customTranslation.getTenantId(), customTranslation.getCustomerId(), customTranslation.getLocaleCode());
                    break;
                }
                default: {
                    return this.handleUnsupportedMsgType(customTranslationUpdateMsg.getMsgType());
                }
            }
        }
        catch (Exception e) {
            String errMsg = "Exception during updating custom translation";
            log.error(errMsg, (Throwable)e);
            return Futures.immediateFailedFuture((Throwable)new RuntimeException(errMsg, e));
        }
        return Futures.immediateFuture(null);
    }
}

