/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.id.CustomMenuId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.menu.CMAssigneeType;
import org.thingsboard.server.common.data.menu.CustomMenu;
import org.thingsboard.server.common.data.menu.CustomMenuInfo;
import org.thingsboard.server.gen.edge.v1.CustomMenuProto;
import org.thingsboard.server.service.cloud.rpc.processor.CustomMenuCloudProcessor;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

@Component
public class CustomMenuCloudProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomMenuCloudProcessor.class);

    public ListenableFuture<Void> processCustomMenuMsgFromCloud(TenantId tenantId, CustomMenuProto customMenuProto) {
        try {
            switch (2.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[customMenuProto.getMsgType().ordinal()]) {
                case 1: 
                case 2: {
                    CustomMenu customMenu = (CustomMenu)JacksonUtil.fromString((String)customMenuProto.getEntity(), CustomMenu.class, (boolean)true);
                    if (customMenu == null) {
                        throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] customMenuProto {" + String.valueOf(customMenuProto) + "} cannot be converted to custom menu");
                    }
                    List assigneeList = customMenuProto.hasAssigneeList() ? (List)JacksonUtil.fromString((String)customMenuProto.getAssigneeList(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (boolean)true) : null;
                    CustomMenu existing = this.edgeCtx.getCustomMenuService().findCustomMenuById(customMenu.getTenantId(), (CustomMenuId)customMenu.getId());
                    if (existing != null) {
                        CustomMenu savedCustomMenu = this.edgeCtx.getCustomMenuService().updateCustomMenu(customMenu, false);
                        if (assigneeList != null) {
                            CMAssigneeType assigneeType = savedCustomMenu.getAssigneeType();
                            String[] assigneeIds = (String[])assigneeList.stream().map(id -> id.getId().toString()).toArray(String[]::new);
                            this.edgeCtx.getCustomMenuService().updateAssigneeList(savedCustomMenu, assigneeType, assigneeList, assigneeType == CMAssigneeType.USER_GROUPS ? assigneeIds : new String[]{}, true);
                        }
                        break;
                    }
                    this.edgeCtx.getCustomMenuService().createCustomMenu((CustomMenuInfo)customMenu, assigneeList, false);
                    break;
                }
                case 3: {
                    CustomMenu customMenu = (CustomMenu)JacksonUtil.fromString((String)customMenuProto.getEntity(), CustomMenu.class, (boolean)true);
                    if (customMenu == null) {
                        throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] customMenuProto {" + String.valueOf(customMenuProto) + "} cannot be converted to custom menu");
                    }
                    CustomMenu existing = this.edgeCtx.getCustomMenuService().findCustomMenuById(customMenu.getTenantId(), (CustomMenuId)customMenu.getId());
                    if (existing == null) break;
                    this.edgeCtx.getCustomMenuService().deleteCustomMenu(customMenu, true);
                }
            }
        }
        catch (Exception e) {
            String errMsg = "Exception during updating custom menu";
            log.error(errMsg, (Throwable)e);
            return Futures.immediateFailedFuture((Throwable)new RuntimeException(errMsg, e));
        }
        return Futures.immediateFuture(null);
    }
}

