/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.cloud.CloudEvent;
import org.thingsboard.server.common.data.cloud.CloudEventType;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.gen.edge.v1.AlarmUpdateMsg;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.gen.edge.v1.UplinkMsg;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.cloud.rpc.processor.AlarmCloudProcessor;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.alarm.BaseAlarmProcessor;

@Component
@TbCoreComponent
public class AlarmCloudProcessor
extends BaseAlarmProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlarmCloudProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> processAlarmMsgFromCloud(TenantId tenantId, AlarmUpdateMsg alarmUpdateMsg) {
        try {
            this.cloudSynchronizationManager.getSync().set(true);
            ListenableFuture listenableFuture = this.processAlarmMsg(tenantId, alarmUpdateMsg);
            return listenableFuture;
        }
        finally {
            this.cloudSynchronizationManager.getSync().remove();
        }
    }

    public UplinkMsg convertCloudEventToUplink(CloudEvent cloudEvent) {
        AlarmUpdateMsg alarmUpdateMsg = this.convertAlarmEventToAlarmMsg(cloudEvent.getTenantId(), cloudEvent.getEntityId(), cloudEvent.getAction(), cloudEvent.getEntityBody());
        if (alarmUpdateMsg != null) {
            return UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addAlarmUpdateMsg(alarmUpdateMsg).build();
        }
        return null;
    }

    private AlarmUpdateMsg convertAlarmEventToAlarmMsg(TenantId tenantId, UUID entityId, EdgeEventActionType actionType, JsonNode body) {
        AlarmId alarmId = new AlarmId(entityId);
        UpdateMsgType msgType = this.getUpdateMsgType(actionType);
        switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[actionType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                Alarm alarm = this.edgeCtx.getAlarmService().findAlarmById(tenantId, alarmId);
                if (alarm == null) break;
                return EdgeMsgConstructorUtils.constructAlarmUpdatedMsg((UpdateMsgType)msgType, (Alarm)alarm);
            }
            case 5: 
            case 6: {
                Alarm deletedAlarm = (Alarm)JacksonUtil.convertValue((Object)body, Alarm.class);
                if (deletedAlarm == null) break;
                return EdgeMsgConstructorUtils.constructAlarmUpdatedMsg((UpdateMsgType)msgType, (Alarm)deletedAlarm);
            }
        }
        return null;
    }

    public CloudEventType getCloudEventType() {
        return CloudEventType.ALARM;
    }
}

