/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc.processor;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.ai.AiModel;
import org.thingsboard.server.common.data.cloud.CloudEvent;
import org.thingsboard.server.common.data.cloud.CloudEventType;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.id.AiModelId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.HasId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.gen.edge.v1.AiModelUpdateMsg;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.gen.edge.v1.UplinkMsg;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.cloud.rpc.processor.AiModelCloudProcessor;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.ai.BaseAiModelProcessor;

@Component
@TbCoreComponent
public class AiModelCloudProcessor
extends BaseAiModelProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AiModelCloudProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> processAiModelMsgFromCloud(TenantId tenantId, AiModelUpdateMsg aiModelUpdateMsg) {
        AiModelId aiModelId = new AiModelId(new UUID(aiModelUpdateMsg.getIdMSB(), aiModelUpdateMsg.getIdLSB()));
        try {
            this.cloudSynchronizationManager.getSync().set(true);
            ListenableFuture listenableFuture = switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[aiModelUpdateMsg.getMsgType().ordinal()]) {
                case 1, 2 -> {
                    this.saveOrUpdateAiModelFromCloud(tenantId, aiModelId, aiModelUpdateMsg);
                    yield Futures.immediateFuture(null);
                }
                case 3 -> {
                    this.deleteAiModel(tenantId, null, aiModelId);
                    yield Futures.immediateFuture(null);
                }
                default -> this.handleUnsupportedMsgType(aiModelUpdateMsg.getMsgType());
            };
            return listenableFuture;
        }
        finally {
            this.cloudSynchronizationManager.getSync().remove();
        }
    }

    private void saveOrUpdateAiModelFromCloud(TenantId tenantId, AiModelId aiModelId, AiModelUpdateMsg aiModelUpdateMsg) {
        Boolean aiModelNameUpdated;
        Pair resultPair = super.saveOrUpdateAiModel(tenantId, aiModelId, aiModelUpdateMsg);
        Boolean create = (Boolean)resultPair.getFirst();
        if (create.booleanValue()) {
            Optional aiModel = this.edgeCtx.getAiModelService().findAiModelById(tenantId, aiModelId);
            aiModel.ifPresent(model -> this.pushEntityEventToRuleEngine(tenantId, null, (HasId)model, TbMsgType.ENTITY_CREATED));
        }
        if ((aiModelNameUpdated = (Boolean)resultPair.getSecond()).booleanValue()) {
            this.cloudEventService.saveCloudEventAsync(tenantId, CloudEventType.AI_MODEL, EdgeEventActionType.UPDATED, (EntityId)aiModelId, null, null);
        }
    }

    public UplinkMsg convertCloudEventToUplink(CloudEvent cloudEvent) {
        AiModelId aiModelId = new AiModelId(cloudEvent.getEntityId());
        switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[cloudEvent.getAction().ordinal()]) {
            case 1: 
            case 2: {
                AiModel aiModel = this.edgeCtx.getAiModelService().findAiModelById(cloudEvent.getTenantId(), aiModelId).orElse(null);
                if (aiModel != null) {
                    UpdateMsgType msgType = this.getUpdateMsgType(cloudEvent.getAction());
                    AiModelUpdateMsg aiModelUpdateMsg = EdgeMsgConstructorUtils.constructAiModelUpdatedMsg((UpdateMsgType)msgType, (AiModel)aiModel);
                    return UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addAiModelUpdateMsg(aiModelUpdateMsg).build();
                }
                log.info("Skipping event as AiModel was not found [{}]", (Object)cloudEvent);
                break;
            }
            case 3: {
                AiModelUpdateMsg aiModelUpdateMsg = EdgeMsgConstructorUtils.constructAiModelDeleteMsg((AiModelId)aiModelId);
                return UplinkMsg.newBuilder().setUplinkMsgId(EdgeUtils.nextPositiveInt()).addAiModelUpdateMsg(aiModelUpdateMsg).build();
            }
        }
        return null;
    }

    public CloudEventType getCloudEventType() {
        return CloudEventType.AI_MODEL;
    }
}

