/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.rpc;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.edge.rpc.EdgeRpcClient;
import org.thingsboard.server.common.data.edge.EdgeSettings;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.dao.cloud.EdgeSettingsService;
import org.thingsboard.server.dao.edge.stats.CloudStatsCounterService;
import org.thingsboard.server.dao.edge.stats.CloudStatsKey;
import org.thingsboard.server.dao.eventsourcing.GrpcConnectionEstablishedEvent;
import org.thingsboard.server.dao.eventsourcing.InterruptSendUplinkEvent;
import org.thingsboard.server.dao.eventsourcing.StopCloudEventProcessingEvent;
import org.thingsboard.server.dao.subscription.SubscriptionService;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeConfiguration;
import org.thingsboard.server.gen.edge.v1.UplinkMsg;
import org.thingsboard.server.gen.edge.v1.UplinkResponseMsg;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.discovery.TbApplicationEventListener;
import org.thingsboard.server.queue.discovery.event.PartitionChangeEvent;
import org.thingsboard.server.service.cloud.DownlinkMessageService;
import org.thingsboard.server.service.cloud.DownlinkMsgProcessedCallback;
import org.thingsboard.server.service.cloud.config.EdgeConfigurationHandler;
import org.thingsboard.server.service.cloud.info.EdgeInfoHolder;
import org.thingsboard.server.service.cloud.info.PendingUplinkMsgPackHolder;
import org.thingsboard.server.service.cloud.rpc.ConnectionStatusManager;
import org.thingsboard.server.service.cloud.rpc.GrpcClientManager;

@Service
public class BaseGrpcClientManager
extends TbApplicationEventListener<PartitionChangeEvent>
implements GrpcClientManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseGrpcClientManager.class);
    private final EdgeRpcClient edgeRpcClient;
    private final EdgeInfoHolder edgeInfo;
    private final PendingUplinkMsgPackHolder pendingMsgs;
    private final CloudStatsCounterService statsCounterService;
    private final PartitionService partitionService;
    private final ApplicationEventPublisher eventPublisher;
    private final ConnectionStatusManager connectionStatusManager;
    private final ConfigurableApplicationContext context;
    private final EdgeConfigurationHandler edgeConfigurationHandler;
    private final DownlinkMessageService downlinkMessageService;
    private final EdgeSettingsService edgeSettingsService;
    @Autowired
    @Lazy
    private SubscriptionService subscriptionService;
    private ScheduledExecutorService shutdownExecutor;
    private ScheduledExecutorService connectExecutor;
    private ScheduledExecutorService reconnectExecutor;
    private ScheduledFuture<?> connectFuture;
    private ScheduledFuture<?> reconnectFuture;

    protected void onTbApplicationEvent(PartitionChangeEvent event) {
        if (ServiceType.TB_CORE.equals((Object)event.getServiceType())) {
            this.establishRpcConnection();
        }
    }

    @PreDestroy
    private void destroy() {
        this.edgeInfo.resetProcessingFlags();
        if (this.shutdownExecutor != null) {
            this.shutdownExecutor.shutdownNow();
        }
        this.connectionStatusManager.updateConnectivityStatus(false);
        EdgeSettings currentEdgeSettings = this.edgeInfo.getSettings();
        String edgeId = currentEdgeSettings != null ? currentEdgeSettings.getEdgeId() : "";
        log.info("[{}] Starting destroying process", (Object)edgeId);
        try {
            this.edgeRpcClient.disconnect(false);
        }
        catch (Exception e) {
            log.error("Exception during disconnect", (Throwable)e);
        }
        if (this.reconnectExecutor != null) {
            this.reconnectExecutor.shutdownNow();
            this.reconnectExecutor = null;
        }
        log.info("[{}] Destroy was successful", (Object)edgeId);
    }

    public void sendUplinkMsg(UplinkMsg msg) {
        double serverMaxInboundMessageSize = this.edgeRpcClient.getServerMaxInboundMessageSize();
        if (serverMaxInboundMessageSize == 0.0 || (double)msg.getSerializedSize() <= serverMaxInboundMessageSize) {
            this.edgeRpcClient.sendUplinkMsg(msg);
        } else {
            log.error("Uplink msg size [{}] exceeds server max inbound message size [{}]. Skipping this message. Please increase value of EDGES_RPC_MAX_INBOUND_MESSAGE_SIZE env variable on the server and restart it. Message {}", new Object[]{msg.getSerializedSize(), serverMaxInboundMessageSize, msg});
            this.statsCounterService.recordEvent(CloudStatsKey.UPLINK_MSGS_PERMANENTLY_FAILED, this.edgeInfo.getTenantId(), 1L);
            this.pendingMsgs.markAsProcessed(Integer.valueOf(msg.getUplinkMsgId()));
        }
    }

    public void establishRpcConnection() {
        if (this.connectFuture != null) {
            this.connectFuture.cancel(true);
            this.connectFuture = null;
        }
        if (this.connectExecutor == null) {
            this.connectExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)"cloud-manager-connect"));
        }
        this.connectFuture = this.connectExecutor.schedule(() -> {
            try {
                BaseGrpcClientManager baseGrpcClientManager = this;
                synchronized (baseGrpcClientManager) {
                    if (!this.isSystemTenantPartitionMine()) {
                        this.onDestroy();
                        return;
                    }
                    this.edgeInfo.resetProcessingFlags();
                    if (!this.edgeInfo.isInitialized() && !this.edgeInfo.isInitInProgress() && this.validateRoutingKeyAndSecret()) {
                        this.connectToServerAndLaunchEventsProcessing();
                    }
                }
            }
            catch (Exception e) {
                log.error("Failed to establish Cloud Edge service", (Throwable)e);
            }
        }, this.edgeInfo.getReconnectTimeoutMs(), TimeUnit.MILLISECONDS);
    }

    private void connectToServerAndLaunchEventsProcessing() {
        this.edgeInfo.setInitInProgress(true);
        try {
            log.info("Starting Cloud Edge service");
            this.edgeRpcClient.connect(this.edgeInfo.getRoutingKey(), this.edgeInfo.getRoutingSecret(), arg_0 -> this.onUplinkResponse(arg_0), arg_0 -> this.onEdgeUpdate(arg_0), arg_0 -> this.onDownlink(arg_0), arg_0 -> this.scheduleReconnect(arg_0));
            this.launchCloudEventsProcessing();
        }
        catch (Exception e) {
            log.error("Failed to establish connection to cloud", (Throwable)e);
            this.connectExecutor.schedule(() -> this.establishRpcConnection(), this.edgeInfo.getReconnectTimeoutMs(), TimeUnit.MILLISECONDS);
        }
    }

    private void scheduleReconnect(Exception e) {
        this.edgeInfo.resetProcessingFlags();
        this.connectionStatusManager.updateConnectivityStatus(false);
        if (this.reconnectFuture == null) {
            this.reconnectFuture = this.reconnectExecutor.scheduleAtFixedRate(() -> {
                log.info("Trying to reconnect due to the error: {}!", (Object)e.getMessage());
                try {
                    this.edgeRpcClient.disconnect(true);
                    this.tryInitOfflineMode();
                }
                catch (Exception ex) {
                    log.error("Exception during disconnect: {}", (Object)ex.getMessage());
                }
                try {
                    this.edgeRpcClient.connect(this.edgeInfo.getRoutingKey(), this.edgeInfo.getRoutingSecret(), arg_0 -> this.onUplinkResponse(arg_0), arg_0 -> this.onEdgeUpdate(arg_0), arg_0 -> this.onDownlink(arg_0), arg_0 -> this.scheduleReconnect(arg_0));
                }
                catch (Exception ex) {
                    log.error("Exception during connect: {}", (Object)ex.getMessage());
                }
            }, this.edgeInfo.getReconnectTimeoutMs(), this.edgeInfo.getReconnectTimeoutMs(), TimeUnit.MILLISECONDS);
        }
    }

    private void tryInitOfflineMode() {
        EdgeSettings edgeSettings;
        if (!this.edgeInfo.isOfflineInitialized() && (edgeSettings = this.edgeSettingsService.findEdgeSettings()) != null) {
            this.subscriptionService.init(TenantId.fromUUID((UUID)UUID.fromString(edgeSettings.getTenantId())), new EdgeId(UUID.fromString(edgeSettings.getEdgeId())), "OFFLINE_KEY", "OFFLINE_CLOUD_ENDPOINT");
            this.edgeInfo.setOfflineInitialized(true);
        }
    }

    private void onDownlink(DownlinkMsg downlinkMsg) {
        boolean edgeCustomerIdUpdated = this.updateCustomerIdIfRequired(downlinkMsg);
        if (this.edgeInfo.isSyncInProgress() && downlinkMsg.hasSyncCompletedMsg()) {
            log.trace("[{}] downlinkMsg hasSyncCompletedMsg = true", (Object)downlinkMsg);
            this.edgeInfo.setSyncInProgress(false);
            this.edgeInfo.setPerformInitialSyncRequired(false);
        }
        Futures.addCallback((ListenableFuture)this.downlinkMessageService.processDownlinkMsg(this.edgeInfo.getTenantId(), this.edgeInfo.getCustomerId(), downlinkMsg, this.edgeInfo.getSettings()), (FutureCallback)new DownlinkMsgProcessedCallback(this.edgeRpcClient, this.edgeInfo, downlinkMsg, edgeCustomerIdUpdated), (Executor)MoreExecutors.directExecutor());
    }

    private boolean updateCustomerIdIfRequired(DownlinkMsg downlinkMsg) {
        if (downlinkMsg.hasEdgeConfiguration()) {
            return this.edgeConfigurationHandler.setOrUpdateCustomerId(downlinkMsg.getEdgeConfiguration());
        }
        return false;
    }

    private void onEdgeUpdate(EdgeConfiguration edgeConfiguration) {
        try {
            this.eventPublisher.publishEvent((Object)InterruptSendUplinkEvent.INSTANCE);
            if (this.reconnectFuture != null) {
                this.reconnectFuture.cancel(true);
                this.reconnectFuture = null;
            }
            if ("PE".equals(edgeConfiguration.getCloudType())) {
                this.subscriptionService.setLicenseVersion(Integer.valueOf(edgeConfiguration.getLicenseVersion()));
                EdgeId edgeId = new EdgeId(new UUID(edgeConfiguration.getEdgeIdMSB(), edgeConfiguration.getEdgeIdLSB()));
                TenantId tenantId = new TenantId(new UUID(edgeConfiguration.getTenantIdMSB(), edgeConfiguration.getTenantIdLSB()));
                String cloudEndpoint = null;
                if (edgeConfiguration.getLicenseVersion() < 2) {
                    String string = cloudEndpoint = "host.docker.internal".equals(this.edgeInfo.getRpcHost()) ? edgeConfiguration.getCloudEndpoint().replace("localhost", "host.docker.internal") : edgeConfiguration.getCloudEndpoint();
                }
                if (this.subscriptionService.init(tenantId, edgeId, edgeConfiguration.getEdgeLicenseKey(), cloudEndpoint)) {
                    log.debug("Subscription service was initialized successfully!");
                    this.initAndUpdateEdgeSettings(edgeConfiguration);
                } else {
                    log.debug("Failed to initialize subscription service!");
                }
            } else {
                new Thread(() -> {
                    int exitCode;
                    log.error("Terminating application. PE edge can be connected only to PE server version...");
                    int appExitCode = exitCode = -1;
                    try {
                        appExitCode = SpringApplication.exit((ApplicationContext)this.context, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> exitCode});
                    }
                    finally {
                        System.exit(appExitCode);
                    }
                }, "Shutdown Thread").start();
            }
        }
        catch (Exception e) {
            log.error("Can't process edge configuration message [{}]", (Object)edgeConfiguration, (Object)e);
        }
        this.edgeInfo.setInitInProgress(false);
    }

    private void initAndUpdateEdgeSettings(EdgeConfiguration edgeConfiguration) throws Exception {
        EdgeSettings edgeSettings = this.edgeConfigurationHandler.initAndUpdateEdgeSettings(edgeConfiguration);
        if (edgeSettings == null) {
            return;
        }
        if (this.edgeInfo.isPerformInitialSyncRequired()) {
            log.trace("Sending sync request, fullSyncRequired {}", (Object)edgeSettings.isFullSyncRequired());
            this.requestSyncToCloud(edgeSettings.isFullSyncRequired());
        }
        this.edgeInfo.setInitialized(true);
        this.edgeInfo.setOfflineInitialized(true);
    }

    private void onUplinkResponse(UplinkResponseMsg msg) {
        try {
            if (this.edgeInfo.isSendingInProgress()) {
                if (msg.getSuccess()) {
                    this.statsCounterService.recordEvent(CloudStatsKey.UPLINK_MSGS_PUSHED, this.edgeInfo.getTenantId(), 1L);
                    this.pendingMsgs.markAsProcessed(Integer.valueOf(msg.getUplinkMsgId()));
                    log.debug("uplink msg has been processed successfully! {}", (Object)msg);
                } else {
                    this.statsCounterService.recordEvent(CloudStatsKey.UPLINK_MSGS_TMP_FAILED, this.edgeInfo.getTenantId(), 1L);
                    this.pendingMsgs.countDown();
                    if (msg.getErrorMsg().contains("Rate limit reached")) {
                        log.warn("uplink msg processing failed! {}", (Object)"Rate limit reached");
                        this.edgeInfo.setRateLimitViolated(true);
                    } else {
                        log.error("uplink msg processing failed! Error msg: {}", (Object)msg.getErrorMsg());
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Can't process uplink msg response [{}]", (Object)msg, (Object)e);
        }
    }

    private void launchCloudEventsProcessing() {
        this.eventPublisher.publishEvent((Object)GrpcConnectionEstablishedEvent.INSTANCE);
        this.reconnectExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)"cloud-manager-reconnect"));
    }

    private void onDestroy() {
        this.eventPublisher.publishEvent((Object)StopCloudEventProcessingEvent.INSTANCE);
        this.destroy();
    }

    private boolean validateRoutingKeyAndSecret() {
        if (StringUtils.isBlank((CharSequence)this.edgeInfo.getRoutingKey()) || StringUtils.isBlank((CharSequence)this.edgeInfo.getRoutingSecret())) {
            this.shutdownExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)"cloud-manager-shutdown"));
            this.shutdownExecutor.scheduleAtFixedRate(() -> log.error("Routing Key and Routing Secret must be provided! Please configure Routing Key and Routing Secret in the tb-edge.yml file or add CLOUD_ROUTING_KEY and CLOUD_ROUTING_SECRET variable to the tb-edge.conf file. ThingsBoard Edge is not going to connect to cloud!"), 0L, 10L, TimeUnit.SECONDS);
            return false;
        }
        return true;
    }

    private void requestSyncToCloud(boolean fullSyncRequired) {
        this.edgeRpcClient.sendSyncRequestMsg(fullSyncRequired);
        this.edgeInfo.setSyncInProgress(true);
    }

    private boolean isSystemTenantPartitionMine() {
        return this.partitionService.resolve(ServiceType.TB_CORE, TenantId.SYS_TENANT_ID, (EntityId)TenantId.SYS_TENANT_ID).isMyPartition();
    }

    @ConstructorProperties(value={"edgeRpcClient", "edgeInfo", "pendingMsgs", "statsCounterService", "partitionService", "eventPublisher", "connectionStatusManager", "context", "edgeConfigurationHandler", "downlinkMessageService", "edgeSettingsService"})
    @Generated
    public BaseGrpcClientManager(EdgeRpcClient edgeRpcClient, EdgeInfoHolder edgeInfo, PendingUplinkMsgPackHolder pendingMsgs, CloudStatsCounterService statsCounterService, PartitionService partitionService, ApplicationEventPublisher eventPublisher, ConnectionStatusManager connectionStatusManager, ConfigurableApplicationContext context, EdgeConfigurationHandler edgeConfigurationHandler, DownlinkMessageService downlinkMessageService, EdgeSettingsService edgeSettingsService) {
        this.edgeRpcClient = edgeRpcClient;
        this.edgeInfo = edgeInfo;
        this.pendingMsgs = pendingMsgs;
        this.statsCounterService = statsCounterService;
        this.partitionService = partitionService;
        this.eventPublisher = eventPublisher;
        this.connectionStatusManager = connectionStatusManager;
        this.context = context;
        this.edgeConfigurationHandler = edgeConfigurationHandler;
        this.downlinkMessageService = downlinkMessageService;
        this.edgeSettingsService = edgeSettingsService;
    }
}

