/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.event.sender;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.server.common.data.cloud.CloudEvent;
import org.thingsboard.server.dao.edge.stats.CloudStatsCounterService;
import org.thingsboard.server.dao.edge.stats.CloudStatsKey;
import org.thingsboard.server.dao.eventsourcing.InterruptSendUplinkEvent;
import org.thingsboard.server.gen.edge.v1.UplinkMsg;
import org.thingsboard.server.service.cloud.event.UplinkMsgMapper;
import org.thingsboard.server.service.cloud.event.sender.CloudEventUplinkInterrupter;
import org.thingsboard.server.service.cloud.event.sender.CloudEventUplinkSender;
import org.thingsboard.server.service.cloud.info.EdgeInfoHolder;
import org.thingsboard.server.service.cloud.info.PendingUplinkMsgPackHolder;
import org.thingsboard.server.service.cloud.rpc.CloudEventStorageSettings;
import org.thingsboard.server.service.cloud.rpc.GrpcClientManager;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;

@Service
public class GrpcCloudEventUplinkSender
implements CloudEventUplinkSender,
CloudEventUplinkInterrupter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GrpcCloudEventUplinkSender.class);
    private static final int MAX_SEND_UPLINK_ATTEMPTS = 3;
    private final EdgeInfoHolder edgeInfo;
    private final PendingUplinkMsgPackHolder pendingMsgs;
    private final UplinkMsgMapper uplinkMsgMapper;
    private final CloudEventStorageSettings cloudEventStorageSettings;
    private final CloudStatsCounterService statsCounterService;
    private final GrpcClientManager grpcClientManager;
    private Future<?> sendUplinkFuture;
    private SettableFuture<Boolean> sendUplinkFutureResult;
    private ExecutorService uplinkExecutor;

    public void init() {
        this.uplinkExecutor = Executors.newSingleThreadExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)"cloud-manager-uplink"));
    }

    @PreDestroy
    public void shutdown() {
        if (this.uplinkExecutor != null) {
            this.uplinkExecutor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Boolean> sendCloudEvents(List<CloudEvent> cloudEvents, boolean isGeneralMsg) {
        this.edgeInfo.lockSend();
        try {
            if (!isGeneralMsg && this.edgeInfo.isGeneralProcessInProgress()) {
                ListenableFuture listenableFuture = Futures.immediateFuture((Object)true);
                return listenableFuture;
            }
            this.interruptPreviousSendUplinkMsgsTask();
            this.sendUplinkFutureResult = SettableFuture.create();
            cloudEvents = EdgeMsgConstructorUtils.mergeAndFilterUplinkDuplicates(cloudEvents);
            List uplinkMsgPack = this.uplinkMsgMapper.convertCloudEventsToUplink(cloudEvents);
            if (uplinkMsgPack.isEmpty()) {
                ListenableFuture listenableFuture = Futures.immediateFuture((Object)false);
                return listenableFuture;
            }
            this.processMsgPack(uplinkMsgPack, isGeneralMsg);
        }
        finally {
            this.edgeInfo.unlockSend();
        }
        return this.sendUplinkFutureResult;
    }

    @EventListener(value={InterruptSendUplinkEvent.class})
    public void interruptPreviousSendUplinkMsgsTask() {
        if (this.sendUplinkFutureResult != null) {
            try {
                this.sendUplinkFutureResult.get(10L, TimeUnit.SECONDS);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.sendUplinkFutureResult.isDone()) {
                log.debug("[{}] Stopping send uplink future now!", (Object)this.edgeInfo.getTenantId());
                this.sendUplinkFutureResult.set((Object)true);
            }
        }
        if (this.sendUplinkFuture != null && !this.sendUplinkFuture.isCancelled()) {
            this.sendUplinkFuture.cancel(true);
            this.sendUplinkFuture = null;
        }
    }

    private void processMsgPack(List<UplinkMsg> uplinkMsgPack, boolean isGeneralMsg) {
        this.pendingMsgs.setNewPack(uplinkMsgPack);
        this.sendUplinkFuture = this.uplinkExecutor.submit(() -> {
            try {
                boolean success;
                int attempt = 1;
                do {
                    log.trace("[{}] uplink msg(s) are going to be send.", (Object)this.pendingMsgs.getQueueSize());
                    long startTime = System.currentTimeMillis();
                    boolean bl = success = this.sendUplinkMsgPack() && this.pendingMsgs.isQueueEmpty();
                    if (!success) {
                        String batchPrefix = isGeneralMsg ? "General" : "Timeseries";
                        log.warn("Failed to deliver {} batch (size: {}) on attempt {}", new Object[]{batchPrefix, this.pendingMsgs.getQueueSize(), attempt});
                        log.trace("Entities in failed batch: {}", (Object)this.pendingMsgs.getValues());
                        try {
                            Thread.sleep(this.cloudEventStorageSettings.getSleepIntervalBetweenBatches());
                            if (this.edgeInfo.clearRateLimitViolationIfSet()) {
                                TimeUnit.SECONDS.sleep(60L);
                            }
                        }
                        catch (InterruptedException e) {
                            log.error("Error during sleep between batches or on rate limit violation", (Throwable)e);
                        }
                    } else {
                        log.info("Sending of [{}] uplink msg(s) took {} ms.", (Object)uplinkMsgPack.size(), (Object)(System.currentTimeMillis() - startTime));
                    }
                    if (!isGeneralMsg || ++attempt <= 3) continue;
                    log.warn("Failed to deliver the batch: after {} attempts. Next messages are going to be discarded {}", (Object)3, (Object)this.pendingMsgs.getValues());
                    this.statsCounterService.recordEvent(CloudStatsKey.UPLINK_MSGS_PERMANENTLY_FAILED, this.edgeInfo.getTenantId(), (long)this.pendingMsgs.getQueueSize());
                    this.sendUplinkFutureResult.set((Object)false);
                    return;
                } while (!success);
                this.sendUplinkFutureResult.set((Object)false);
            }
            catch (Exception e) {
                this.sendUplinkFutureResult.set((Object)true);
                log.error("Error during send uplink msg", (Throwable)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendUplinkMsgPack() {
        this.edgeInfo.setSendingInProgress(true);
        LinkedBlockingQueue orderedPendingMsgQueue = this.pendingMsgs.getQueue();
        try {
            this.pendingMsgs.startPendingBatch();
            orderedPendingMsgQueue.forEach(arg_0 -> ((GrpcClientManager)this.grpcClientManager).sendUplinkMsg(arg_0));
            boolean bl = this.pendingMsgs.awaitBatchCompletion();
            return bl;
        }
        catch (Exception e) {
            log.error("Interrupted while waiting for latch, isGeneralProcessInProgress={}", (Object)this.edgeInfo.isGeneralProcessInProgress(), (Object)e);
            for (UplinkMsg value : this.pendingMsgs.getValues()) {
                log.warn("Message not send due to exception: {}", (Object)value);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.edgeInfo.setSendingInProgress(false);
        }
    }

    @ConstructorProperties(value={"edgeInfo", "pendingMsgs", "uplinkMsgMapper", "cloudEventStorageSettings", "statsCounterService", "grpcClientManager"})
    @Generated
    public GrpcCloudEventUplinkSender(EdgeInfoHolder edgeInfo, PendingUplinkMsgPackHolder pendingMsgs, UplinkMsgMapper uplinkMsgMapper, CloudEventStorageSettings cloudEventStorageSettings, CloudStatsCounterService statsCounterService, GrpcClientManager grpcClientManager) {
        this.edgeInfo = edgeInfo;
        this.pendingMsgs = pendingMsgs;
        this.uplinkMsgMapper = uplinkMsgMapper;
        this.cloudEventStorageSettings = cloudEventStorageSettings;
        this.statsCounterService = statsCounterService;
        this.grpcClientManager = grpcClientManager;
    }
}

