/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.event.postgres;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.BaseAttributeKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.LongDataEntry;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.eventsourcing.ResetQueueOffsetEvent;
import org.thingsboard.server.service.cloud.info.EdgeInfoHolder;

@Service
public class PostgresResetQueueOffsetEventHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PostgresResetQueueOffsetEventHandler.class);
    private final AttributesService attributesService;
    private final EdgeInfoHolder edgeInfo;

    @EventListener(value={ResetQueueOffsetEvent.class})
    public void onEvent() {
        this.updateQueueStartTsSeqIdOffset(this.edgeInfo.getTenantId(), "queueStartTs", "queueSeqIdOffset", Long.valueOf(System.currentTimeMillis()), Long.valueOf(0L));
        this.updateQueueStartTsSeqIdOffset(this.edgeInfo.getTenantId(), "queueTsKvStartTs", "queueTsKvSeqIdOffset", Long.valueOf(System.currentTimeMillis()), Long.valueOf(0L));
    }

    public void updateQueueStartTsSeqIdOffset(TenantId tenantId, String attrStartTsKey, String attrSeqIdKey, Long startTs, Long seqIdOffset) {
        log.trace("updateQueueStartTsSeqIdOffset [{}][{}][{}][{}]", new Object[]{attrStartTsKey, attrSeqIdKey, startTs, seqIdOffset});
        List<AttributeKvEntry> attributes = Arrays.asList(new BaseAttributeKvEntry((KvEntry)new LongDataEntry(attrStartTsKey, startTs), System.currentTimeMillis()), new BaseAttributeKvEntry((KvEntry)new LongDataEntry(attrSeqIdKey, seqIdOffset), System.currentTimeMillis()));
        try {
            this.attributesService.save(tenantId, (EntityId)tenantId, AttributeScope.SERVER_SCOPE, attributes).get();
        }
        catch (Exception e) {
            log.error("Failed to update queueStartTsSeqIdOffset [{}][{}]", new Object[]{attrStartTsKey, attrSeqIdKey, e});
        }
    }

    @ConstructorProperties(value={"attributesService", "edgeInfo"})
    @Generated
    public PostgresResetQueueOffsetEventHandler(AttributesService attributesService, EdgeInfoHolder edgeInfo) {
        this.attributesService = attributesService;
        this.edgeInfo = edgeInfo;
    }
}

