/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.event.postgres;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.server.common.data.cloud.CloudEvent;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.TimePageLink;
import org.thingsboard.server.dao.edge.stats.CloudStatsCounterService;
import org.thingsboard.server.dao.edge.stats.CloudStatsKey;
import org.thingsboard.server.service.cloud.CloudEventFinder;
import org.thingsboard.server.service.cloud.event.postgres.PostgresCloudEventUplinkRetriever;
import org.thingsboard.server.service.cloud.event.postgres.PostgresResetQueueOffsetEventHandler;
import org.thingsboard.server.service.cloud.event.sender.CloudEventUplinkSender;
import org.thingsboard.server.service.cloud.info.EdgeInfoHolder;

public abstract class AbstractPostgresCloudEventUplinkBatchDispatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractPostgresCloudEventUplinkBatchDispatcher.class);
    @Autowired
    private PostgresCloudEventUplinkRetriever cloudEventUplinkRetriever;
    @Autowired
    private CloudStatsCounterService statsCounterService;
    @Autowired
    private PostgresResetQueueOffsetEventHandler resetQueueOffsetEventHandler;
    @Autowired
    private EdgeInfoHolder edgeInfo;

    protected abstract CloudEventUplinkSender getCloudEventUplinkSender();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUplinkMessages(TimePageLink pageLink, Long queueSeqIdStart, String queueStartTsAttrKey, String queueSeqIdAttrKey, boolean isGeneralMsg, CloudEventFinder finder) {
        try {
            PageData cloudEvents;
            boolean isInterrupted;
            if (isGeneralMsg) {
                this.edgeInfo.setGeneralProcessInProgress(true);
            }
            do {
                if (!isGeneralMsg) {
                    this.waitForGeneralProcessingCompleteIfInProgress();
                }
                if ((cloudEvents = finder.find(this.edgeInfo.getTenantId(), queueSeqIdStart, null, pageLink)).getData().isEmpty()) {
                    log.info("seqId column of table started new cycle. queueSeqIdStart={}, queueStartTsAttrKey={}, queueSeqIdAttrKey={}, isGeneralMsg={}", new Object[]{queueSeqIdStart, queueStartTsAttrKey, queueSeqIdAttrKey, isGeneralMsg});
                    cloudEvents = this.cloudEventUplinkRetriever.findCloudEventsFromBeginning(this.edgeInfo.getTenantId(), pageLink, finder);
                }
                if (!(isInterrupted = ((Boolean)this.getCloudEventUplinkSender().sendCloudEvents(cloudEvents.getData(), isGeneralMsg).get()).booleanValue()) && cloudEvents.getTotalElements() > 0L) {
                    CloudEvent latestCloudEvent = (CloudEvent)cloudEvents.getData().get(cloudEvents.getData().size() - 1);
                    try {
                        Long newStartTs = Uuids.unixTimestamp((UUID)latestCloudEvent.getUuidId());
                        this.resetQueueOffsetEventHandler.updateQueueStartTsSeqIdOffset(this.edgeInfo.getTenantId(), queueStartTsAttrKey, queueSeqIdAttrKey, newStartTs, Long.valueOf(latestCloudEvent.getSeqId()));
                        log.info("Queue offset was updated [{}][{}][{}]", new Object[]{latestCloudEvent.getUuidId(), newStartTs, latestCloudEvent.getSeqId()});
                    }
                    catch (Exception e) {
                        log.error("Failed to update queue offset [{}]", (Object)latestCloudEvent);
                    }
                }
                if (!isInterrupted) {
                    pageLink = pageLink.nextPageLink();
                    if (cloudEvents.hasNext()) {
                        String queueName = isGeneralMsg ? "Cloud Event" : "TSKv Cloud Event";
                        long queueSize = Math.max(cloudEvents.getTotalElements() - (long)pageLink.getPage() * (long)pageLink.getPageSize(), 0L);
                        this.statsCounterService.recordEvent(CloudStatsKey.UPLINK_MSGS_LAG, this.edgeInfo.getTenantId(), queueSize);
                        log.info("[{}] Uplink Processing Lag Stats: queue size = [{}], current page = [{}], total pages = [{}]", new Object[]{queueName, queueSize, pageLink.getPage(), cloudEvents.getTotalPages()});
                    }
                }
                if (!isGeneralMsg) {
                    this.waitForGeneralProcessingCompleteIfInProgress();
                }
                log.trace("processUplinkMessages state isInterrupted={},total={},hasNext={},isGeneralMsg={},isGeneralProcessInProgress={}", new Object[]{isInterrupted, cloudEvents.getTotalElements(), cloudEvents.hasNext(), isGeneralMsg, this.edgeInfo.isGeneralProcessInProgress()});
            } while (isInterrupted || cloudEvents.hasNext());
        }
        catch (Exception e) {
            log.error("Failed to process cloud event messages handling!", (Throwable)e);
        }
        finally {
            if (isGeneralMsg) {
                this.edgeInfo.setGeneralProcessInProgress(false);
            }
        }
    }

    private void waitForGeneralProcessingCompleteIfInProgress() {
        if (!this.edgeInfo.isGeneralProcessInProgress()) {
            return;
        }
        do {
            try {
                TimeUnit.MILLISECONDS.sleep(25L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        } while (this.edgeInfo.isGeneralProcessInProgress());
    }
}

