/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.event;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.cloud.CloudEvent;
import org.thingsboard.server.gen.edge.v1.UplinkMsg;
import org.thingsboard.server.service.cloud.CloudContextComponent;
import org.thingsboard.server.service.cloud.event.UplinkMsgMapper;
import org.thingsboard.server.service.cloud.rpc.processor.EntityGroupCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.GroupPermissionCloudProcessor;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;

@Service
public class UplinkMsgMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UplinkMsgMapper.class);
    private final CloudContextComponent cloudCtx;
    private final EntityGroupCloudProcessor entityGroupProcessor;
    private final GroupPermissionCloudProcessor groupPermissionProcessor;

    public List<UplinkMsg> convertCloudEventsToUplink(List<CloudEvent> cloudEvents) {
        cloudEvents = EdgeMsgConstructorUtils.mergeAndFilterUplinkDuplicates(cloudEvents);
        log.trace("[{}] event(s) are going to be converted.", (Object)cloudEvents.size());
        return cloudEvents.stream().map(arg_0 -> this.convertCloudEventToUplink(arg_0)).filter(Objects::nonNull).toList();
    }

    public UplinkMsg convertCloudEventToUplink(CloudEvent cloudEvent) {
        log.trace("Converting cloud event [{}]", (Object)cloudEvent);
        try {
            return switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[cloudEvent.getAction().ordinal()]) {
                case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14 -> this.convertEntityEventToUplink(cloudEvent);
                case 15, 16, 17, 18 -> this.cloudCtx.getTelemetryProcessor().convertTelemetryEventToUplink(cloudEvent.getTenantId(), cloudEvent);
                case 19 -> this.cloudCtx.getTelemetryProcessor().convertAttributesRequestEventToUplink(cloudEvent);
                case 20 -> this.entityGroupProcessor.processGroupEntitiesRequestMsgToCloud(cloudEvent);
                case 21 -> this.groupPermissionProcessor.processEntityGroupPermissionsRequestMsgToCloud(cloudEvent);
                case 22 -> this.cloudCtx.getRelationProcessor().convertRelationRequestEventToUplink(cloudEvent);
                case 23 -> this.cloudCtx.getCalculatedFieldProcessor().convertCalculatedFieldRequestEventToUplink(cloudEvent);
                case 24 -> this.cloudCtx.getDeviceProcessor().convertRpcCallEventToUplink(cloudEvent);
                default -> {
                    log.warn("Unsupported action type [{}]", (Object)cloudEvent);
                    yield null;
                }
            };
        }
        catch (Exception e) {
            log.error("Exception during converting events from queue, skipping event [{}]", (Object)cloudEvent, (Object)e);
            return null;
        }
    }

    private UplinkMsg convertEntityEventToUplink(CloudEvent cloudEvent) {
        log.trace("Executing convertEntityEventToUplink cloudEvent [{}], edgeEventAction [{}]", (Object)cloudEvent, (Object)cloudEvent.getAction());
        return this.cloudCtx.getProcessor(cloudEvent.getType()).convertCloudEventToUplink(cloudEvent);
    }

    @ConstructorProperties(value={"cloudCtx", "entityGroupProcessor", "groupPermissionProcessor"})
    @Generated
    public UplinkMsgMapper(CloudContextComponent cloudCtx, EntityGroupCloudProcessor entityGroupProcessor, GroupPermissionCloudProcessor groupPermissionProcessor) {
        this.cloudCtx = cloudCtx;
        this.entityGroupProcessor = entityGroupProcessor;
        this.groupPermissionProcessor = groupPermissionProcessor;
    }
}

