/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud.config;

import java.beans.ConstructorProperties;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.cloud.CloudEventType;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeSettings;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.dao.cloud.EdgeSettingsService;
import org.thingsboard.server.dao.edge.EdgeService;
import org.thingsboard.server.dao.eventsourcing.ResetQueueOffsetEvent;
import org.thingsboard.server.dao.subscription.SubscriptionService;
import org.thingsboard.server.gen.edge.v1.EdgeConfiguration;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.service.cloud.CloudContextComponent;
import org.thingsboard.server.service.cloud.config.EdgeConfigurationHandler;
import org.thingsboard.server.service.cloud.event.migrator.CloudEventMigrationService;
import org.thingsboard.server.service.cloud.info.EdgeInfoHolder;
import org.thingsboard.server.service.cloud.rpc.ConnectionStatusManager;

@Service
public class BaseEdgeConfigurationHandler
implements EdgeConfigurationHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseEdgeConfigurationHandler.class);
    private final EdgeSettingsService edgeSettingsService;
    private final CloudContextComponent cloudCtx;
    private final EdgeService edgeService;
    private final EdgeInfoHolder edgeInfo;
    private final PartitionService partitionService;
    private final ConnectionStatusManager connectionStatusManager;
    private final ApplicationEventPublisher eventPublisher;
    @Autowired
    @Lazy
    private SubscriptionService subscriptionService;
    @Autowired(required=false)
    private CloudEventMigrationService cloudEventMigrationService;

    public EdgeSettings initAndUpdateEdgeSettings(EdgeConfiguration edgeConfiguration) throws Exception {
        if (!this.isSystemTenantPartitionMine()) {
            return null;
        }
        TenantId tenantId = TenantId.fromUUID((UUID)new UUID(edgeConfiguration.getTenantIdMSB(), edgeConfiguration.getTenantIdLSB()));
        this.edgeInfo.setTenantId(tenantId);
        EdgeSettings currentEdgeSettings = this.updateEdgeSettingsIfRequired(edgeConfiguration);
        this.cloudCtx.getTenantProcessor().createTenantIfNotExists(tenantId);
        boolean edgeCustomerIdUpdated = this.setOrUpdateCustomerId(edgeConfiguration);
        if (edgeCustomerIdUpdated) {
            this.cloudCtx.getCustomerProcessor().createCustomerIfNotExists(tenantId, edgeConfiguration);
        }
        this.edgeSettingsService.saveEdgeSettings(tenantId, currentEdgeSettings);
        this.saveOrUpdateEdge(tenantId, edgeConfiguration);
        this.connectionStatusManager.updateConnectivityStatus(true);
        if (this.cloudEventMigrationService != null && this.cloudEventMigrationService.isMigrationRequired()) {
            this.cloudEventMigrationService.migrateUnprocessedEventToKafka();
        }
        return currentEdgeSettings;
    }

    public boolean setOrUpdateCustomerId(EdgeConfiguration edgeConfiguration) {
        EdgeId edgeId = this.getEdgeId(edgeConfiguration);
        Edge edge = this.edgeService.findEdgeById(this.edgeInfo.getTenantId(), edgeId);
        CustomerId previousCustomerId = null;
        if (edge != null) {
            previousCustomerId = edge.getCustomerId();
        }
        if (edgeConfiguration.getCustomerIdMSB() != 0L && edgeConfiguration.getCustomerIdLSB() != 0L) {
            UUID customerUUID = new UUID(edgeConfiguration.getCustomerIdMSB(), edgeConfiguration.getCustomerIdLSB());
            this.edgeInfo.setCustomerId(new CustomerId(customerUUID));
            return !this.edgeInfo.getCustomerId().equals((Object)previousCustomerId);
        }
        return false;
    }

    private void saveOrUpdateEdge(TenantId tenantId, EdgeConfiguration edgeConfiguration) throws Exception {
        EdgeId edgeId = this.getEdgeId(edgeConfiguration);
        this.cloudCtx.getEdgeProcessor().processEdgeConfigurationMsgFromCloud(tenantId, edgeConfiguration);
        this.cloudCtx.getCloudEventService().saveCloudEvent(tenantId, CloudEventType.EDGE, EdgeEventActionType.ATTRIBUTES_REQUEST, (EntityId)edgeId, null, null);
        this.cloudCtx.getCloudEventService().saveCloudEvent(tenantId, CloudEventType.EDGE, EdgeEventActionType.RELATION_REQUEST, (EntityId)edgeId, null, null);
    }

    private EdgeId getEdgeId(EdgeConfiguration edgeConfiguration) {
        UUID edgeUUID = new UUID(edgeConfiguration.getEdgeIdMSB(), edgeConfiguration.getEdgeIdLSB());
        return new EdgeId(edgeUUID);
    }

    private EdgeSettings updateEdgeSettingsIfRequired(EdgeConfiguration edgeConfiguration) {
        EdgeSettings currentEdgeSettings = this.edgeSettingsService.findEdgeSettings();
        EdgeSettings newEdgeSettings = this.constructEdgeSettings(edgeConfiguration);
        if (currentEdgeSettings != null && !newEdgeSettings.getEdgeId().equals(currentEdgeSettings.getEdgeId())) {
            this.cloudCtx.getTenantProcessor().cleanUp();
            this.eventPublisher.publishEvent((Object)ResetQueueOffsetEvent.INSTANCE);
            currentEdgeSettings = null;
        }
        if (currentEdgeSettings == null) {
            currentEdgeSettings = newEdgeSettings;
        } else {
            log.trace("Using edge settings from DB {}", (Object)currentEdgeSettings);
            currentEdgeSettings.setName(newEdgeSettings.getName());
            currentEdgeSettings.setType(newEdgeSettings.getType());
            currentEdgeSettings.setRoutingKey(newEdgeSettings.getRoutingKey());
            currentEdgeSettings.setMaxAssets(newEdgeSettings.getMaxAssets());
            currentEdgeSettings.setMaxDevices(newEdgeSettings.getMaxDevices());
        }
        this.edgeInfo.setSettings(currentEdgeSettings);
        return currentEdgeSettings;
    }

    private EdgeSettings constructEdgeSettings(EdgeConfiguration edgeConfiguration) {
        EdgeSettings edgeSettings = new EdgeSettings();
        UUID edgeUUID = new UUID(edgeConfiguration.getEdgeIdMSB(), edgeConfiguration.getEdgeIdLSB());
        edgeSettings.setEdgeId(edgeUUID.toString());
        UUID tenantUUID = new UUID(edgeConfiguration.getTenantIdMSB(), edgeConfiguration.getTenantIdLSB());
        edgeSettings.setTenantId(tenantUUID.toString());
        edgeSettings.setName(edgeConfiguration.getName());
        edgeSettings.setType(edgeConfiguration.getType());
        edgeSettings.setRoutingKey(edgeConfiguration.getRoutingKey());
        edgeSettings.setFullSyncRequired(true);
        edgeSettings.setMaxDevices(this.subscriptionService.maxDevices());
        edgeSettings.setMaxAssets(this.subscriptionService.maxAssets());
        return edgeSettings;
    }

    private boolean isSystemTenantPartitionMine() {
        return this.partitionService.resolve(ServiceType.TB_CORE, TenantId.SYS_TENANT_ID, (EntityId)TenantId.SYS_TENANT_ID).isMyPartition();
    }

    @ConstructorProperties(value={"edgeSettingsService", "cloudCtx", "edgeService", "edgeInfo", "partitionService", "connectionStatusManager", "eventPublisher"})
    @Generated
    public BaseEdgeConfigurationHandler(EdgeSettingsService edgeSettingsService, CloudContextComponent cloudCtx, EdgeService edgeService, EdgeInfoHolder edgeInfo, PartitionService partitionService, ConnectionStatusManager connectionStatusManager, ApplicationEventPublisher eventPublisher) {
        this.edgeSettingsService = edgeSettingsService;
        this.cloudCtx = cloudCtx;
        this.edgeService = edgeService;
        this.edgeInfo = edgeInfo;
        this.partitionService = partitionService;
        this.connectionStatusManager = connectionStatusManager;
        this.eventPublisher = eventPublisher;
    }
}

