/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud;

import com.google.common.util.concurrent.FutureCallback;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.edge.rpc.EdgeRpcClient;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.DownlinkResponseMsg;
import org.thingsboard.server.service.cloud.info.EdgeInfoHolder;

public class DownlinkMsgProcessedCallback
implements FutureCallback<List<Void>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DownlinkMsgProcessedCallback.class);
    private final EdgeRpcClient client;
    private final EdgeInfoHolder edgeInfo;
    private final DownlinkMsg downlinkMsg;
    private final boolean edgeCustomerIdUpdated;

    public DownlinkMsgProcessedCallback(EdgeRpcClient client, EdgeInfoHolder edgeInfo, DownlinkMsg downlinkMsg, boolean edgeCustomerIdUpdated) {
        this.client = client;
        this.edgeInfo = edgeInfo;
        this.downlinkMsg = downlinkMsg;
        this.edgeCustomerIdUpdated = edgeCustomerIdUpdated;
    }

    public void onSuccess(List<Void> result) {
        log.trace("[{}] DownlinkMsg has been processed successfully! DownlinkMsgId {}", (Object)this.edgeInfo.getRoutingKey(), (Object)this.downlinkMsg.getDownlinkMsgId());
        DownlinkResponseMsg downlinkResponseMsg = DownlinkResponseMsg.newBuilder().setDownlinkMsgId(this.downlinkMsg.getDownlinkMsgId()).setSuccess(true).build();
        this.client.sendDownlinkResponseMsg(downlinkResponseMsg);
        if (this.downlinkMsg.hasEdgeConfiguration() && this.edgeCustomerIdUpdated && !this.edgeInfo.isSyncInProgress()) {
            log.info("Edge customer id has been updated. Sending sync request...");
            this.requestSyncToCloud();
        }
    }

    public void onFailure(Throwable t) {
        log.error("[{}] Failed to process DownlinkMsg! DownlinkMsgId {}", (Object)this.edgeInfo.getRoutingKey(), (Object)this.downlinkMsg.getDownlinkMsgId());
        String errorMsg = EdgeUtils.createErrorMsgFromRootCauseAndStackTrace((Throwable)t);
        DownlinkResponseMsg downlinkResponseMsg = DownlinkResponseMsg.newBuilder().setDownlinkMsgId(this.downlinkMsg.getDownlinkMsgId()).setSuccess(false).setErrorMsg(errorMsg).build();
        this.client.sendDownlinkResponseMsg(downlinkResponseMsg);
    }

    private void requestSyncToCloud() {
        this.client.sendSyncRequestMsg(false);
        this.edgeInfo.setSyncInProgress(true);
    }
}

