/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cloud;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.cloud.CloudEventType;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.cloud.CloudEventService;
import org.thingsboard.server.dao.cloud.EdgeSettingsService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.cloud.rpc.CloudEventStorageSettings;
import org.thingsboard.server.service.cloud.rpc.processor.AdminSettingsCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.AiModelCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.AlarmCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.AlarmCommentCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.AssetCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.AssetProfileCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.CalculatedFieldCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.ConverterCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.CustomMenuCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.CustomTranslationCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.CustomerCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.DashboardCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.DeviceCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.DeviceProfileCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.EdgeCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.EncryptionKeyCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.EntityGroupCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.EntityViewCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.GroupPermissionCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.IntegrationCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.NotificationCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.OAuth2CloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.OtaPackageCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.QueueCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.RelationCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.ReportTemplateCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.ResourceCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.RoleCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.RuleChainCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.SchedulerEventCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.SecretCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.TelemetryCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.TenantCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.TenantProfileCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.UserCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.WhiteLabelingCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.WidgetBundleCloudProcessor;
import org.thingsboard.server.service.cloud.rpc.processor.WidgetTypeCloudProcessor;
import org.thingsboard.server.service.edge.rpc.processor.EdgeProcessor;
import org.thingsboard.server.service.executors.DbCallbackExecutorService;

@Lazy
@Component
@TbCoreComponent
public class CloudContextComponent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloudContextComponent.class);
    private Map<CloudEventType, EdgeProcessor> processorMap = new EnumMap(CloudEventType.class);
    @Autowired
    private AttributesService attributesService;
    @Autowired
    private CloudEventService cloudEventService;
    @Autowired
    private AdminSettingsCloudProcessor adminSettingsProcessor;
    @Autowired
    private AlarmCommentCloudProcessor alarmCommentProcessor;
    @Autowired
    private AlarmCloudProcessor alarmProcessor;
    @Autowired
    private AssetCloudProcessor assetProcessor;
    @Autowired
    private AssetProfileCloudProcessor assetProfileProcessor;
    @Autowired
    private CustomerCloudProcessor customerProcessor;
    @Autowired
    private DashboardCloudProcessor dashboardProcessor;
    @Autowired
    private DeviceCloudProcessor deviceProcessor;
    @Autowired
    private DeviceProfileCloudProcessor deviceProfileProcessor;
    @Autowired
    private EdgeCloudProcessor edgeProcessor;
    @Autowired
    private EntityViewCloudProcessor entityViewProcessor;
    @Autowired
    private NotificationCloudProcessor notificationProcessor;
    @Autowired
    private OAuth2CloudProcessor oAuth2Processor;
    @Autowired
    private OtaPackageCloudProcessor otaPackageProcessor;
    @Autowired
    private QueueCloudProcessor queueProcessor;
    @Autowired
    private RelationCloudProcessor relationProcessor;
    @Autowired
    private ResourceCloudProcessor resourceProcessor;
    @Autowired
    private RuleChainCloudProcessor ruleChainProcessor;
    @Autowired
    private TelemetryCloudProcessor telemetryProcessor;
    @Autowired
    private TenantCloudProcessor tenantProcessor;
    @Autowired
    private TenantProfileCloudProcessor tenantProfileProcessor;
    @Autowired
    private UserCloudProcessor userProcessor;
    @Autowired
    private WidgetBundleCloudProcessor widgetsBundleProcessor;
    @Autowired
    private WidgetTypeCloudProcessor widgetTypeProcessor;
    @Autowired
    private AiModelCloudProcessor aiModelProcessor;
    @Autowired
    private EntityGroupCloudProcessor entityGroupProcessor;
    @Autowired
    private SchedulerEventCloudProcessor schedulerEventProcessor;
    @Autowired
    private RoleCloudProcessor roleProcessor;
    @Autowired
    private GroupPermissionCloudProcessor groupPermissionProcessor;
    @Autowired
    private CustomTranslationCloudProcessor customTranslationProcessor;
    @Autowired
    private CustomMenuCloudProcessor customMenuProcessor;
    @Autowired
    private WhiteLabelingCloudProcessor whiteLabelingProcessor;
    @Autowired
    private ConverterCloudProcessor converterProcessor;
    @Autowired
    private IntegrationCloudProcessor integrationProcessor;
    @Autowired
    private ResourceCloudProcessor tbResourceProcessor;
    @Autowired
    private ReportTemplateCloudProcessor reportTemplateProcessor;
    @Autowired
    private SecretCloudProcessor secretProcessor;
    @Autowired
    private EncryptionKeyCloudProcessor encryptionKeyCloudProcessor;
    @Autowired
    private EdgeSettingsService edgeSettingsService;
    @Autowired
    private CloudEventStorageSettings cloudEventStorageSettings;
    @Autowired
    private CalculatedFieldCloudProcessor calculatedFieldProcessor;
    @Autowired
    private DbCallbackExecutorService dbCallbackExecutorService;

    @Autowired
    public CloudContextComponent(List<EdgeProcessor> processors) {
        processors.forEach(processor -> {
            CloudEventType eventType = processor.getCloudEventType();
            if (eventType != null) {
                this.processorMap.put(eventType, processor);
            }
        });
    }

    public EdgeProcessor getProcessor(CloudEventType cloudEventType) {
        EdgeProcessor processor = (EdgeProcessor)this.processorMap.get(cloudEventType);
        if (processor == null) {
            throw new UnsupportedOperationException("No processor found for CloudEventType: " + String.valueOf(cloudEventType));
        }
        return processor;
    }

    @Generated
    public Map<CloudEventType, EdgeProcessor> getProcessorMap() {
        return this.processorMap;
    }

    @Generated
    public AttributesService getAttributesService() {
        return this.attributesService;
    }

    @Generated
    public CloudEventService getCloudEventService() {
        return this.cloudEventService;
    }

    @Generated
    public AdminSettingsCloudProcessor getAdminSettingsProcessor() {
        return this.adminSettingsProcessor;
    }

    @Generated
    public AlarmCommentCloudProcessor getAlarmCommentProcessor() {
        return this.alarmCommentProcessor;
    }

    @Generated
    public AlarmCloudProcessor getAlarmProcessor() {
        return this.alarmProcessor;
    }

    @Generated
    public AssetCloudProcessor getAssetProcessor() {
        return this.assetProcessor;
    }

    @Generated
    public AssetProfileCloudProcessor getAssetProfileProcessor() {
        return this.assetProfileProcessor;
    }

    @Generated
    public CustomerCloudProcessor getCustomerProcessor() {
        return this.customerProcessor;
    }

    @Generated
    public DashboardCloudProcessor getDashboardProcessor() {
        return this.dashboardProcessor;
    }

    @Generated
    public DeviceCloudProcessor getDeviceProcessor() {
        return this.deviceProcessor;
    }

    @Generated
    public DeviceProfileCloudProcessor getDeviceProfileProcessor() {
        return this.deviceProfileProcessor;
    }

    @Generated
    public EdgeCloudProcessor getEdgeProcessor() {
        return this.edgeProcessor;
    }

    @Generated
    public EntityViewCloudProcessor getEntityViewProcessor() {
        return this.entityViewProcessor;
    }

    @Generated
    public NotificationCloudProcessor getNotificationProcessor() {
        return this.notificationProcessor;
    }

    @Generated
    public OAuth2CloudProcessor getOAuth2Processor() {
        return this.oAuth2Processor;
    }

    @Generated
    public OtaPackageCloudProcessor getOtaPackageProcessor() {
        return this.otaPackageProcessor;
    }

    @Generated
    public QueueCloudProcessor getQueueProcessor() {
        return this.queueProcessor;
    }

    @Generated
    public RelationCloudProcessor getRelationProcessor() {
        return this.relationProcessor;
    }

    @Generated
    public ResourceCloudProcessor getResourceProcessor() {
        return this.resourceProcessor;
    }

    @Generated
    public RuleChainCloudProcessor getRuleChainProcessor() {
        return this.ruleChainProcessor;
    }

    @Generated
    public TelemetryCloudProcessor getTelemetryProcessor() {
        return this.telemetryProcessor;
    }

    @Generated
    public TenantCloudProcessor getTenantProcessor() {
        return this.tenantProcessor;
    }

    @Generated
    public TenantProfileCloudProcessor getTenantProfileProcessor() {
        return this.tenantProfileProcessor;
    }

    @Generated
    public UserCloudProcessor getUserProcessor() {
        return this.userProcessor;
    }

    @Generated
    public WidgetBundleCloudProcessor getWidgetsBundleProcessor() {
        return this.widgetsBundleProcessor;
    }

    @Generated
    public WidgetTypeCloudProcessor getWidgetTypeProcessor() {
        return this.widgetTypeProcessor;
    }

    @Generated
    public AiModelCloudProcessor getAiModelProcessor() {
        return this.aiModelProcessor;
    }

    @Generated
    public EntityGroupCloudProcessor getEntityGroupProcessor() {
        return this.entityGroupProcessor;
    }

    @Generated
    public SchedulerEventCloudProcessor getSchedulerEventProcessor() {
        return this.schedulerEventProcessor;
    }

    @Generated
    public RoleCloudProcessor getRoleProcessor() {
        return this.roleProcessor;
    }

    @Generated
    public GroupPermissionCloudProcessor getGroupPermissionProcessor() {
        return this.groupPermissionProcessor;
    }

    @Generated
    public CustomTranslationCloudProcessor getCustomTranslationProcessor() {
        return this.customTranslationProcessor;
    }

    @Generated
    public CustomMenuCloudProcessor getCustomMenuProcessor() {
        return this.customMenuProcessor;
    }

    @Generated
    public WhiteLabelingCloudProcessor getWhiteLabelingProcessor() {
        return this.whiteLabelingProcessor;
    }

    @Generated
    public ConverterCloudProcessor getConverterProcessor() {
        return this.converterProcessor;
    }

    @Generated
    public IntegrationCloudProcessor getIntegrationProcessor() {
        return this.integrationProcessor;
    }

    @Generated
    public ResourceCloudProcessor getTbResourceProcessor() {
        return this.tbResourceProcessor;
    }

    @Generated
    public ReportTemplateCloudProcessor getReportTemplateProcessor() {
        return this.reportTemplateProcessor;
    }

    @Generated
    public SecretCloudProcessor getSecretProcessor() {
        return this.secretProcessor;
    }

    @Generated
    public EncryptionKeyCloudProcessor getEncryptionKeyCloudProcessor() {
        return this.encryptionKeyCloudProcessor;
    }

    @Generated
    public EdgeSettingsService getEdgeSettingsService() {
        return this.edgeSettingsService;
    }

    @Generated
    public CloudEventStorageSettings getCloudEventStorageSettings() {
        return this.cloudEventStorageSettings;
    }

    @Generated
    public CalculatedFieldCloudProcessor getCalculatedFieldProcessor() {
        return this.calculatedFieldProcessor;
    }

    @Generated
    public DbCallbackExecutorService getDbCallbackExecutorService() {
        return this.dbCallbackExecutorService;
    }

    @Generated
    public void setProcessorMap(Map<CloudEventType, EdgeProcessor> processorMap) {
        this.processorMap = processorMap;
    }

    @Generated
    public void setAttributesService(AttributesService attributesService) {
        this.attributesService = attributesService;
    }

    @Generated
    public void setCloudEventService(CloudEventService cloudEventService) {
        this.cloudEventService = cloudEventService;
    }

    @Generated
    public void setAdminSettingsProcessor(AdminSettingsCloudProcessor adminSettingsProcessor) {
        this.adminSettingsProcessor = adminSettingsProcessor;
    }

    @Generated
    public void setAlarmCommentProcessor(AlarmCommentCloudProcessor alarmCommentProcessor) {
        this.alarmCommentProcessor = alarmCommentProcessor;
    }

    @Generated
    public void setAlarmProcessor(AlarmCloudProcessor alarmProcessor) {
        this.alarmProcessor = alarmProcessor;
    }

    @Generated
    public void setAssetProcessor(AssetCloudProcessor assetProcessor) {
        this.assetProcessor = assetProcessor;
    }

    @Generated
    public void setAssetProfileProcessor(AssetProfileCloudProcessor assetProfileProcessor) {
        this.assetProfileProcessor = assetProfileProcessor;
    }

    @Generated
    public void setCustomerProcessor(CustomerCloudProcessor customerProcessor) {
        this.customerProcessor = customerProcessor;
    }

    @Generated
    public void setDashboardProcessor(DashboardCloudProcessor dashboardProcessor) {
        this.dashboardProcessor = dashboardProcessor;
    }

    @Generated
    public void setDeviceProcessor(DeviceCloudProcessor deviceProcessor) {
        this.deviceProcessor = deviceProcessor;
    }

    @Generated
    public void setDeviceProfileProcessor(DeviceProfileCloudProcessor deviceProfileProcessor) {
        this.deviceProfileProcessor = deviceProfileProcessor;
    }

    @Generated
    public void setEdgeProcessor(EdgeCloudProcessor edgeProcessor) {
        this.edgeProcessor = edgeProcessor;
    }

    @Generated
    public void setEntityViewProcessor(EntityViewCloudProcessor entityViewProcessor) {
        this.entityViewProcessor = entityViewProcessor;
    }

    @Generated
    public void setNotificationProcessor(NotificationCloudProcessor notificationProcessor) {
        this.notificationProcessor = notificationProcessor;
    }

    @Generated
    public void setOAuth2Processor(OAuth2CloudProcessor oAuth2Processor) {
        this.oAuth2Processor = oAuth2Processor;
    }

    @Generated
    public void setOtaPackageProcessor(OtaPackageCloudProcessor otaPackageProcessor) {
        this.otaPackageProcessor = otaPackageProcessor;
    }

    @Generated
    public void setQueueProcessor(QueueCloudProcessor queueProcessor) {
        this.queueProcessor = queueProcessor;
    }

    @Generated
    public void setRelationProcessor(RelationCloudProcessor relationProcessor) {
        this.relationProcessor = relationProcessor;
    }

    @Generated
    public void setResourceProcessor(ResourceCloudProcessor resourceProcessor) {
        this.resourceProcessor = resourceProcessor;
    }

    @Generated
    public void setRuleChainProcessor(RuleChainCloudProcessor ruleChainProcessor) {
        this.ruleChainProcessor = ruleChainProcessor;
    }

    @Generated
    public void setTelemetryProcessor(TelemetryCloudProcessor telemetryProcessor) {
        this.telemetryProcessor = telemetryProcessor;
    }

    @Generated
    public void setTenantProcessor(TenantCloudProcessor tenantProcessor) {
        this.tenantProcessor = tenantProcessor;
    }

    @Generated
    public void setTenantProfileProcessor(TenantProfileCloudProcessor tenantProfileProcessor) {
        this.tenantProfileProcessor = tenantProfileProcessor;
    }

    @Generated
    public void setUserProcessor(UserCloudProcessor userProcessor) {
        this.userProcessor = userProcessor;
    }

    @Generated
    public void setWidgetsBundleProcessor(WidgetBundleCloudProcessor widgetsBundleProcessor) {
        this.widgetsBundleProcessor = widgetsBundleProcessor;
    }

    @Generated
    public void setWidgetTypeProcessor(WidgetTypeCloudProcessor widgetTypeProcessor) {
        this.widgetTypeProcessor = widgetTypeProcessor;
    }

    @Generated
    public void setAiModelProcessor(AiModelCloudProcessor aiModelProcessor) {
        this.aiModelProcessor = aiModelProcessor;
    }

    @Generated
    public void setEntityGroupProcessor(EntityGroupCloudProcessor entityGroupProcessor) {
        this.entityGroupProcessor = entityGroupProcessor;
    }

    @Generated
    public void setSchedulerEventProcessor(SchedulerEventCloudProcessor schedulerEventProcessor) {
        this.schedulerEventProcessor = schedulerEventProcessor;
    }

    @Generated
    public void setRoleProcessor(RoleCloudProcessor roleProcessor) {
        this.roleProcessor = roleProcessor;
    }

    @Generated
    public void setGroupPermissionProcessor(GroupPermissionCloudProcessor groupPermissionProcessor) {
        this.groupPermissionProcessor = groupPermissionProcessor;
    }

    @Generated
    public void setCustomTranslationProcessor(CustomTranslationCloudProcessor customTranslationProcessor) {
        this.customTranslationProcessor = customTranslationProcessor;
    }

    @Generated
    public void setCustomMenuProcessor(CustomMenuCloudProcessor customMenuProcessor) {
        this.customMenuProcessor = customMenuProcessor;
    }

    @Generated
    public void setWhiteLabelingProcessor(WhiteLabelingCloudProcessor whiteLabelingProcessor) {
        this.whiteLabelingProcessor = whiteLabelingProcessor;
    }

    @Generated
    public void setConverterProcessor(ConverterCloudProcessor converterProcessor) {
        this.converterProcessor = converterProcessor;
    }

    @Generated
    public void setIntegrationProcessor(IntegrationCloudProcessor integrationProcessor) {
        this.integrationProcessor = integrationProcessor;
    }

    @Generated
    public void setTbResourceProcessor(ResourceCloudProcessor tbResourceProcessor) {
        this.tbResourceProcessor = tbResourceProcessor;
    }

    @Generated
    public void setReportTemplateProcessor(ReportTemplateCloudProcessor reportTemplateProcessor) {
        this.reportTemplateProcessor = reportTemplateProcessor;
    }

    @Generated
    public void setSecretProcessor(SecretCloudProcessor secretProcessor) {
        this.secretProcessor = secretProcessor;
    }

    @Generated
    public void setEncryptionKeyCloudProcessor(EncryptionKeyCloudProcessor encryptionKeyCloudProcessor) {
        this.encryptionKeyCloudProcessor = encryptionKeyCloudProcessor;
    }

    @Generated
    public void setEdgeSettingsService(EdgeSettingsService edgeSettingsService) {
        this.edgeSettingsService = edgeSettingsService;
    }

    @Generated
    public void setCloudEventStorageSettings(CloudEventStorageSettings cloudEventStorageSettings) {
        this.cloudEventStorageSettings = cloudEventStorageSettings;
    }

    @Generated
    public void setCalculatedFieldProcessor(CalculatedFieldCloudProcessor calculatedFieldProcessor) {
        this.calculatedFieldProcessor = calculatedFieldProcessor;
    }

    @Generated
    public void setDbCallbackExecutorService(DbCallbackExecutorService dbCallbackExecutorService) {
        this.dbCallbackExecutorService = dbCallbackExecutorService;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CloudContextComponent)) {
            return false;
        }
        CloudContextComponent other = (CloudContextComponent)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Map this$processorMap = this.getProcessorMap();
        Map other$processorMap = other.getProcessorMap();
        if (this$processorMap == null ? other$processorMap != null : !((Object)this$processorMap).equals(other$processorMap)) {
            return false;
        }
        AttributesService this$attributesService = this.getAttributesService();
        AttributesService other$attributesService = other.getAttributesService();
        if (this$attributesService == null ? other$attributesService != null : !this$attributesService.equals(other$attributesService)) {
            return false;
        }
        CloudEventService this$cloudEventService = this.getCloudEventService();
        CloudEventService other$cloudEventService = other.getCloudEventService();
        if (this$cloudEventService == null ? other$cloudEventService != null : !this$cloudEventService.equals(other$cloudEventService)) {
            return false;
        }
        AdminSettingsCloudProcessor this$adminSettingsProcessor = this.getAdminSettingsProcessor();
        AdminSettingsCloudProcessor other$adminSettingsProcessor = other.getAdminSettingsProcessor();
        if (this$adminSettingsProcessor == null ? other$adminSettingsProcessor != null : !this$adminSettingsProcessor.equals(other$adminSettingsProcessor)) {
            return false;
        }
        AlarmCommentCloudProcessor this$alarmCommentProcessor = this.getAlarmCommentProcessor();
        AlarmCommentCloudProcessor other$alarmCommentProcessor = other.getAlarmCommentProcessor();
        if (this$alarmCommentProcessor == null ? other$alarmCommentProcessor != null : !this$alarmCommentProcessor.equals(other$alarmCommentProcessor)) {
            return false;
        }
        AlarmCloudProcessor this$alarmProcessor = this.getAlarmProcessor();
        AlarmCloudProcessor other$alarmProcessor = other.getAlarmProcessor();
        if (this$alarmProcessor == null ? other$alarmProcessor != null : !this$alarmProcessor.equals(other$alarmProcessor)) {
            return false;
        }
        AssetCloudProcessor this$assetProcessor = this.getAssetProcessor();
        AssetCloudProcessor other$assetProcessor = other.getAssetProcessor();
        if (this$assetProcessor == null ? other$assetProcessor != null : !this$assetProcessor.equals(other$assetProcessor)) {
            return false;
        }
        AssetProfileCloudProcessor this$assetProfileProcessor = this.getAssetProfileProcessor();
        AssetProfileCloudProcessor other$assetProfileProcessor = other.getAssetProfileProcessor();
        if (this$assetProfileProcessor == null ? other$assetProfileProcessor != null : !this$assetProfileProcessor.equals(other$assetProfileProcessor)) {
            return false;
        }
        CustomerCloudProcessor this$customerProcessor = this.getCustomerProcessor();
        CustomerCloudProcessor other$customerProcessor = other.getCustomerProcessor();
        if (this$customerProcessor == null ? other$customerProcessor != null : !this$customerProcessor.equals(other$customerProcessor)) {
            return false;
        }
        DashboardCloudProcessor this$dashboardProcessor = this.getDashboardProcessor();
        DashboardCloudProcessor other$dashboardProcessor = other.getDashboardProcessor();
        if (this$dashboardProcessor == null ? other$dashboardProcessor != null : !this$dashboardProcessor.equals(other$dashboardProcessor)) {
            return false;
        }
        DeviceCloudProcessor this$deviceProcessor = this.getDeviceProcessor();
        DeviceCloudProcessor other$deviceProcessor = other.getDeviceProcessor();
        if (this$deviceProcessor == null ? other$deviceProcessor != null : !this$deviceProcessor.equals(other$deviceProcessor)) {
            return false;
        }
        DeviceProfileCloudProcessor this$deviceProfileProcessor = this.getDeviceProfileProcessor();
        DeviceProfileCloudProcessor other$deviceProfileProcessor = other.getDeviceProfileProcessor();
        if (this$deviceProfileProcessor == null ? other$deviceProfileProcessor != null : !this$deviceProfileProcessor.equals(other$deviceProfileProcessor)) {
            return false;
        }
        EdgeCloudProcessor this$edgeProcessor = this.getEdgeProcessor();
        EdgeCloudProcessor other$edgeProcessor = other.getEdgeProcessor();
        if (this$edgeProcessor == null ? other$edgeProcessor != null : !this$edgeProcessor.equals(other$edgeProcessor)) {
            return false;
        }
        EntityViewCloudProcessor this$entityViewProcessor = this.getEntityViewProcessor();
        EntityViewCloudProcessor other$entityViewProcessor = other.getEntityViewProcessor();
        if (this$entityViewProcessor == null ? other$entityViewProcessor != null : !this$entityViewProcessor.equals(other$entityViewProcessor)) {
            return false;
        }
        NotificationCloudProcessor this$notificationProcessor = this.getNotificationProcessor();
        NotificationCloudProcessor other$notificationProcessor = other.getNotificationProcessor();
        if (this$notificationProcessor == null ? other$notificationProcessor != null : !this$notificationProcessor.equals(other$notificationProcessor)) {
            return false;
        }
        OAuth2CloudProcessor this$oAuth2Processor = this.getOAuth2Processor();
        OAuth2CloudProcessor other$oAuth2Processor = other.getOAuth2Processor();
        if (this$oAuth2Processor == null ? other$oAuth2Processor != null : !this$oAuth2Processor.equals(other$oAuth2Processor)) {
            return false;
        }
        OtaPackageCloudProcessor this$otaPackageProcessor = this.getOtaPackageProcessor();
        OtaPackageCloudProcessor other$otaPackageProcessor = other.getOtaPackageProcessor();
        if (this$otaPackageProcessor == null ? other$otaPackageProcessor != null : !this$otaPackageProcessor.equals(other$otaPackageProcessor)) {
            return false;
        }
        QueueCloudProcessor this$queueProcessor = this.getQueueProcessor();
        QueueCloudProcessor other$queueProcessor = other.getQueueProcessor();
        if (this$queueProcessor == null ? other$queueProcessor != null : !this$queueProcessor.equals(other$queueProcessor)) {
            return false;
        }
        RelationCloudProcessor this$relationProcessor = this.getRelationProcessor();
        RelationCloudProcessor other$relationProcessor = other.getRelationProcessor();
        if (this$relationProcessor == null ? other$relationProcessor != null : !this$relationProcessor.equals(other$relationProcessor)) {
            return false;
        }
        ResourceCloudProcessor this$resourceProcessor = this.getResourceProcessor();
        ResourceCloudProcessor other$resourceProcessor = other.getResourceProcessor();
        if (this$resourceProcessor == null ? other$resourceProcessor != null : !this$resourceProcessor.equals(other$resourceProcessor)) {
            return false;
        }
        RuleChainCloudProcessor this$ruleChainProcessor = this.getRuleChainProcessor();
        RuleChainCloudProcessor other$ruleChainProcessor = other.getRuleChainProcessor();
        if (this$ruleChainProcessor == null ? other$ruleChainProcessor != null : !this$ruleChainProcessor.equals(other$ruleChainProcessor)) {
            return false;
        }
        TelemetryCloudProcessor this$telemetryProcessor = this.getTelemetryProcessor();
        TelemetryCloudProcessor other$telemetryProcessor = other.getTelemetryProcessor();
        if (this$telemetryProcessor == null ? other$telemetryProcessor != null : !this$telemetryProcessor.equals(other$telemetryProcessor)) {
            return false;
        }
        TenantCloudProcessor this$tenantProcessor = this.getTenantProcessor();
        TenantCloudProcessor other$tenantProcessor = other.getTenantProcessor();
        if (this$tenantProcessor == null ? other$tenantProcessor != null : !this$tenantProcessor.equals(other$tenantProcessor)) {
            return false;
        }
        TenantProfileCloudProcessor this$tenantProfileProcessor = this.getTenantProfileProcessor();
        TenantProfileCloudProcessor other$tenantProfileProcessor = other.getTenantProfileProcessor();
        if (this$tenantProfileProcessor == null ? other$tenantProfileProcessor != null : !this$tenantProfileProcessor.equals(other$tenantProfileProcessor)) {
            return false;
        }
        UserCloudProcessor this$userProcessor = this.getUserProcessor();
        UserCloudProcessor other$userProcessor = other.getUserProcessor();
        if (this$userProcessor == null ? other$userProcessor != null : !this$userProcessor.equals(other$userProcessor)) {
            return false;
        }
        WidgetBundleCloudProcessor this$widgetsBundleProcessor = this.getWidgetsBundleProcessor();
        WidgetBundleCloudProcessor other$widgetsBundleProcessor = other.getWidgetsBundleProcessor();
        if (this$widgetsBundleProcessor == null ? other$widgetsBundleProcessor != null : !this$widgetsBundleProcessor.equals(other$widgetsBundleProcessor)) {
            return false;
        }
        WidgetTypeCloudProcessor this$widgetTypeProcessor = this.getWidgetTypeProcessor();
        WidgetTypeCloudProcessor other$widgetTypeProcessor = other.getWidgetTypeProcessor();
        if (this$widgetTypeProcessor == null ? other$widgetTypeProcessor != null : !this$widgetTypeProcessor.equals(other$widgetTypeProcessor)) {
            return false;
        }
        AiModelCloudProcessor this$aiModelProcessor = this.getAiModelProcessor();
        AiModelCloudProcessor other$aiModelProcessor = other.getAiModelProcessor();
        if (this$aiModelProcessor == null ? other$aiModelProcessor != null : !this$aiModelProcessor.equals(other$aiModelProcessor)) {
            return false;
        }
        EntityGroupCloudProcessor this$entityGroupProcessor = this.getEntityGroupProcessor();
        EntityGroupCloudProcessor other$entityGroupProcessor = other.getEntityGroupProcessor();
        if (this$entityGroupProcessor == null ? other$entityGroupProcessor != null : !this$entityGroupProcessor.equals(other$entityGroupProcessor)) {
            return false;
        }
        SchedulerEventCloudProcessor this$schedulerEventProcessor = this.getSchedulerEventProcessor();
        SchedulerEventCloudProcessor other$schedulerEventProcessor = other.getSchedulerEventProcessor();
        if (this$schedulerEventProcessor == null ? other$schedulerEventProcessor != null : !this$schedulerEventProcessor.equals(other$schedulerEventProcessor)) {
            return false;
        }
        RoleCloudProcessor this$roleProcessor = this.getRoleProcessor();
        RoleCloudProcessor other$roleProcessor = other.getRoleProcessor();
        if (this$roleProcessor == null ? other$roleProcessor != null : !this$roleProcessor.equals(other$roleProcessor)) {
            return false;
        }
        GroupPermissionCloudProcessor this$groupPermissionProcessor = this.getGroupPermissionProcessor();
        GroupPermissionCloudProcessor other$groupPermissionProcessor = other.getGroupPermissionProcessor();
        if (this$groupPermissionProcessor == null ? other$groupPermissionProcessor != null : !this$groupPermissionProcessor.equals(other$groupPermissionProcessor)) {
            return false;
        }
        CustomTranslationCloudProcessor this$customTranslationProcessor = this.getCustomTranslationProcessor();
        CustomTranslationCloudProcessor other$customTranslationProcessor = other.getCustomTranslationProcessor();
        if (this$customTranslationProcessor == null ? other$customTranslationProcessor != null : !this$customTranslationProcessor.equals(other$customTranslationProcessor)) {
            return false;
        }
        CustomMenuCloudProcessor this$customMenuProcessor = this.getCustomMenuProcessor();
        CustomMenuCloudProcessor other$customMenuProcessor = other.getCustomMenuProcessor();
        if (this$customMenuProcessor == null ? other$customMenuProcessor != null : !this$customMenuProcessor.equals(other$customMenuProcessor)) {
            return false;
        }
        WhiteLabelingCloudProcessor this$whiteLabelingProcessor = this.getWhiteLabelingProcessor();
        WhiteLabelingCloudProcessor other$whiteLabelingProcessor = other.getWhiteLabelingProcessor();
        if (this$whiteLabelingProcessor == null ? other$whiteLabelingProcessor != null : !this$whiteLabelingProcessor.equals(other$whiteLabelingProcessor)) {
            return false;
        }
        ConverterCloudProcessor this$converterProcessor = this.getConverterProcessor();
        ConverterCloudProcessor other$converterProcessor = other.getConverterProcessor();
        if (this$converterProcessor == null ? other$converterProcessor != null : !this$converterProcessor.equals(other$converterProcessor)) {
            return false;
        }
        IntegrationCloudProcessor this$integrationProcessor = this.getIntegrationProcessor();
        IntegrationCloudProcessor other$integrationProcessor = other.getIntegrationProcessor();
        if (this$integrationProcessor == null ? other$integrationProcessor != null : !this$integrationProcessor.equals(other$integrationProcessor)) {
            return false;
        }
        ResourceCloudProcessor this$tbResourceProcessor = this.getTbResourceProcessor();
        ResourceCloudProcessor other$tbResourceProcessor = other.getTbResourceProcessor();
        if (this$tbResourceProcessor == null ? other$tbResourceProcessor != null : !this$tbResourceProcessor.equals(other$tbResourceProcessor)) {
            return false;
        }
        ReportTemplateCloudProcessor this$reportTemplateProcessor = this.getReportTemplateProcessor();
        ReportTemplateCloudProcessor other$reportTemplateProcessor = other.getReportTemplateProcessor();
        if (this$reportTemplateProcessor == null ? other$reportTemplateProcessor != null : !this$reportTemplateProcessor.equals(other$reportTemplateProcessor)) {
            return false;
        }
        SecretCloudProcessor this$secretProcessor = this.getSecretProcessor();
        SecretCloudProcessor other$secretProcessor = other.getSecretProcessor();
        if (this$secretProcessor == null ? other$secretProcessor != null : !this$secretProcessor.equals(other$secretProcessor)) {
            return false;
        }
        EncryptionKeyCloudProcessor this$encryptionKeyCloudProcessor = this.getEncryptionKeyCloudProcessor();
        EncryptionKeyCloudProcessor other$encryptionKeyCloudProcessor = other.getEncryptionKeyCloudProcessor();
        if (this$encryptionKeyCloudProcessor == null ? other$encryptionKeyCloudProcessor != null : !this$encryptionKeyCloudProcessor.equals(other$encryptionKeyCloudProcessor)) {
            return false;
        }
        EdgeSettingsService this$edgeSettingsService = this.getEdgeSettingsService();
        EdgeSettingsService other$edgeSettingsService = other.getEdgeSettingsService();
        if (this$edgeSettingsService == null ? other$edgeSettingsService != null : !this$edgeSettingsService.equals(other$edgeSettingsService)) {
            return false;
        }
        CloudEventStorageSettings this$cloudEventStorageSettings = this.getCloudEventStorageSettings();
        CloudEventStorageSettings other$cloudEventStorageSettings = other.getCloudEventStorageSettings();
        if (this$cloudEventStorageSettings == null ? other$cloudEventStorageSettings != null : !this$cloudEventStorageSettings.equals(other$cloudEventStorageSettings)) {
            return false;
        }
        CalculatedFieldCloudProcessor this$calculatedFieldProcessor = this.getCalculatedFieldProcessor();
        CalculatedFieldCloudProcessor other$calculatedFieldProcessor = other.getCalculatedFieldProcessor();
        if (this$calculatedFieldProcessor == null ? other$calculatedFieldProcessor != null : !this$calculatedFieldProcessor.equals(other$calculatedFieldProcessor)) {
            return false;
        }
        DbCallbackExecutorService this$dbCallbackExecutorService = this.getDbCallbackExecutorService();
        DbCallbackExecutorService other$dbCallbackExecutorService = other.getDbCallbackExecutorService();
        return !(this$dbCallbackExecutorService == null ? other$dbCallbackExecutorService != null : !this$dbCallbackExecutorService.equals(other$dbCallbackExecutorService));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CloudContextComponent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map $processorMap = this.getProcessorMap();
        result = result * 59 + ($processorMap == null ? 43 : ((Object)$processorMap).hashCode());
        AttributesService $attributesService = this.getAttributesService();
        result = result * 59 + ($attributesService == null ? 43 : $attributesService.hashCode());
        CloudEventService $cloudEventService = this.getCloudEventService();
        result = result * 59 + ($cloudEventService == null ? 43 : $cloudEventService.hashCode());
        AdminSettingsCloudProcessor $adminSettingsProcessor = this.getAdminSettingsProcessor();
        result = result * 59 + ($adminSettingsProcessor == null ? 43 : $adminSettingsProcessor.hashCode());
        AlarmCommentCloudProcessor $alarmCommentProcessor = this.getAlarmCommentProcessor();
        result = result * 59 + ($alarmCommentProcessor == null ? 43 : $alarmCommentProcessor.hashCode());
        AlarmCloudProcessor $alarmProcessor = this.getAlarmProcessor();
        result = result * 59 + ($alarmProcessor == null ? 43 : $alarmProcessor.hashCode());
        AssetCloudProcessor $assetProcessor = this.getAssetProcessor();
        result = result * 59 + ($assetProcessor == null ? 43 : $assetProcessor.hashCode());
        AssetProfileCloudProcessor $assetProfileProcessor = this.getAssetProfileProcessor();
        result = result * 59 + ($assetProfileProcessor == null ? 43 : $assetProfileProcessor.hashCode());
        CustomerCloudProcessor $customerProcessor = this.getCustomerProcessor();
        result = result * 59 + ($customerProcessor == null ? 43 : $customerProcessor.hashCode());
        DashboardCloudProcessor $dashboardProcessor = this.getDashboardProcessor();
        result = result * 59 + ($dashboardProcessor == null ? 43 : $dashboardProcessor.hashCode());
        DeviceCloudProcessor $deviceProcessor = this.getDeviceProcessor();
        result = result * 59 + ($deviceProcessor == null ? 43 : $deviceProcessor.hashCode());
        DeviceProfileCloudProcessor $deviceProfileProcessor = this.getDeviceProfileProcessor();
        result = result * 59 + ($deviceProfileProcessor == null ? 43 : $deviceProfileProcessor.hashCode());
        EdgeCloudProcessor $edgeProcessor = this.getEdgeProcessor();
        result = result * 59 + ($edgeProcessor == null ? 43 : $edgeProcessor.hashCode());
        EntityViewCloudProcessor $entityViewProcessor = this.getEntityViewProcessor();
        result = result * 59 + ($entityViewProcessor == null ? 43 : $entityViewProcessor.hashCode());
        NotificationCloudProcessor $notificationProcessor = this.getNotificationProcessor();
        result = result * 59 + ($notificationProcessor == null ? 43 : $notificationProcessor.hashCode());
        OAuth2CloudProcessor $oAuth2Processor = this.getOAuth2Processor();
        result = result * 59 + ($oAuth2Processor == null ? 43 : $oAuth2Processor.hashCode());
        OtaPackageCloudProcessor $otaPackageProcessor = this.getOtaPackageProcessor();
        result = result * 59 + ($otaPackageProcessor == null ? 43 : $otaPackageProcessor.hashCode());
        QueueCloudProcessor $queueProcessor = this.getQueueProcessor();
        result = result * 59 + ($queueProcessor == null ? 43 : $queueProcessor.hashCode());
        RelationCloudProcessor $relationProcessor = this.getRelationProcessor();
        result = result * 59 + ($relationProcessor == null ? 43 : $relationProcessor.hashCode());
        ResourceCloudProcessor $resourceProcessor = this.getResourceProcessor();
        result = result * 59 + ($resourceProcessor == null ? 43 : $resourceProcessor.hashCode());
        RuleChainCloudProcessor $ruleChainProcessor = this.getRuleChainProcessor();
        result = result * 59 + ($ruleChainProcessor == null ? 43 : $ruleChainProcessor.hashCode());
        TelemetryCloudProcessor $telemetryProcessor = this.getTelemetryProcessor();
        result = result * 59 + ($telemetryProcessor == null ? 43 : $telemetryProcessor.hashCode());
        TenantCloudProcessor $tenantProcessor = this.getTenantProcessor();
        result = result * 59 + ($tenantProcessor == null ? 43 : $tenantProcessor.hashCode());
        TenantProfileCloudProcessor $tenantProfileProcessor = this.getTenantProfileProcessor();
        result = result * 59 + ($tenantProfileProcessor == null ? 43 : $tenantProfileProcessor.hashCode());
        UserCloudProcessor $userProcessor = this.getUserProcessor();
        result = result * 59 + ($userProcessor == null ? 43 : $userProcessor.hashCode());
        WidgetBundleCloudProcessor $widgetsBundleProcessor = this.getWidgetsBundleProcessor();
        result = result * 59 + ($widgetsBundleProcessor == null ? 43 : $widgetsBundleProcessor.hashCode());
        WidgetTypeCloudProcessor $widgetTypeProcessor = this.getWidgetTypeProcessor();
        result = result * 59 + ($widgetTypeProcessor == null ? 43 : $widgetTypeProcessor.hashCode());
        AiModelCloudProcessor $aiModelProcessor = this.getAiModelProcessor();
        result = result * 59 + ($aiModelProcessor == null ? 43 : $aiModelProcessor.hashCode());
        EntityGroupCloudProcessor $entityGroupProcessor = this.getEntityGroupProcessor();
        result = result * 59 + ($entityGroupProcessor == null ? 43 : $entityGroupProcessor.hashCode());
        SchedulerEventCloudProcessor $schedulerEventProcessor = this.getSchedulerEventProcessor();
        result = result * 59 + ($schedulerEventProcessor == null ? 43 : $schedulerEventProcessor.hashCode());
        RoleCloudProcessor $roleProcessor = this.getRoleProcessor();
        result = result * 59 + ($roleProcessor == null ? 43 : $roleProcessor.hashCode());
        GroupPermissionCloudProcessor $groupPermissionProcessor = this.getGroupPermissionProcessor();
        result = result * 59 + ($groupPermissionProcessor == null ? 43 : $groupPermissionProcessor.hashCode());
        CustomTranslationCloudProcessor $customTranslationProcessor = this.getCustomTranslationProcessor();
        result = result * 59 + ($customTranslationProcessor == null ? 43 : $customTranslationProcessor.hashCode());
        CustomMenuCloudProcessor $customMenuProcessor = this.getCustomMenuProcessor();
        result = result * 59 + ($customMenuProcessor == null ? 43 : $customMenuProcessor.hashCode());
        WhiteLabelingCloudProcessor $whiteLabelingProcessor = this.getWhiteLabelingProcessor();
        result = result * 59 + ($whiteLabelingProcessor == null ? 43 : $whiteLabelingProcessor.hashCode());
        ConverterCloudProcessor $converterProcessor = this.getConverterProcessor();
        result = result * 59 + ($converterProcessor == null ? 43 : $converterProcessor.hashCode());
        IntegrationCloudProcessor $integrationProcessor = this.getIntegrationProcessor();
        result = result * 59 + ($integrationProcessor == null ? 43 : $integrationProcessor.hashCode());
        ResourceCloudProcessor $tbResourceProcessor = this.getTbResourceProcessor();
        result = result * 59 + ($tbResourceProcessor == null ? 43 : $tbResourceProcessor.hashCode());
        ReportTemplateCloudProcessor $reportTemplateProcessor = this.getReportTemplateProcessor();
        result = result * 59 + ($reportTemplateProcessor == null ? 43 : $reportTemplateProcessor.hashCode());
        SecretCloudProcessor $secretProcessor = this.getSecretProcessor();
        result = result * 59 + ($secretProcessor == null ? 43 : $secretProcessor.hashCode());
        EncryptionKeyCloudProcessor $encryptionKeyCloudProcessor = this.getEncryptionKeyCloudProcessor();
        result = result * 59 + ($encryptionKeyCloudProcessor == null ? 43 : $encryptionKeyCloudProcessor.hashCode());
        EdgeSettingsService $edgeSettingsService = this.getEdgeSettingsService();
        result = result * 59 + ($edgeSettingsService == null ? 43 : $edgeSettingsService.hashCode());
        CloudEventStorageSettings $cloudEventStorageSettings = this.getCloudEventStorageSettings();
        result = result * 59 + ($cloudEventStorageSettings == null ? 43 : $cloudEventStorageSettings.hashCode());
        CalculatedFieldCloudProcessor $calculatedFieldProcessor = this.getCalculatedFieldProcessor();
        result = result * 59 + ($calculatedFieldProcessor == null ? 43 : $calculatedFieldProcessor.hashCode());
        DbCallbackExecutorService $dbCallbackExecutorService = this.getDbCallbackExecutorService();
        result = result * 59 + ($dbCallbackExecutorService == null ? 43 : $dbCallbackExecutorService.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CloudContextComponent(processorMap=" + String.valueOf(this.getProcessorMap()) + ", attributesService=" + String.valueOf(this.getAttributesService()) + ", cloudEventService=" + String.valueOf(this.getCloudEventService()) + ", adminSettingsProcessor=" + String.valueOf(this.getAdminSettingsProcessor()) + ", alarmCommentProcessor=" + String.valueOf(this.getAlarmCommentProcessor()) + ", alarmProcessor=" + String.valueOf(this.getAlarmProcessor()) + ", assetProcessor=" + String.valueOf(this.getAssetProcessor()) + ", assetProfileProcessor=" + String.valueOf(this.getAssetProfileProcessor()) + ", customerProcessor=" + String.valueOf(this.getCustomerProcessor()) + ", dashboardProcessor=" + String.valueOf(this.getDashboardProcessor()) + ", deviceProcessor=" + String.valueOf(this.getDeviceProcessor()) + ", deviceProfileProcessor=" + String.valueOf(this.getDeviceProfileProcessor()) + ", edgeProcessor=" + String.valueOf(this.getEdgeProcessor()) + ", entityViewProcessor=" + String.valueOf(this.getEntityViewProcessor()) + ", notificationProcessor=" + String.valueOf(this.getNotificationProcessor()) + ", oAuth2Processor=" + String.valueOf(this.getOAuth2Processor()) + ", otaPackageProcessor=" + String.valueOf(this.getOtaPackageProcessor()) + ", queueProcessor=" + String.valueOf(this.getQueueProcessor()) + ", relationProcessor=" + String.valueOf(this.getRelationProcessor()) + ", resourceProcessor=" + String.valueOf(this.getResourceProcessor()) + ", ruleChainProcessor=" + String.valueOf(this.getRuleChainProcessor()) + ", telemetryProcessor=" + String.valueOf(this.getTelemetryProcessor()) + ", tenantProcessor=" + String.valueOf(this.getTenantProcessor()) + ", tenantProfileProcessor=" + String.valueOf(this.getTenantProfileProcessor()) + ", userProcessor=" + String.valueOf(this.getUserProcessor()) + ", widgetsBundleProcessor=" + String.valueOf(this.getWidgetsBundleProcessor()) + ", widgetTypeProcessor=" + String.valueOf(this.getWidgetTypeProcessor()) + ", aiModelProcessor=" + String.valueOf(this.getAiModelProcessor()) + ", entityGroupProcessor=" + String.valueOf(this.getEntityGroupProcessor()) + ", schedulerEventProcessor=" + String.valueOf(this.getSchedulerEventProcessor()) + ", roleProcessor=" + String.valueOf(this.getRoleProcessor()) + ", groupPermissionProcessor=" + String.valueOf(this.getGroupPermissionProcessor()) + ", customTranslationProcessor=" + String.valueOf(this.getCustomTranslationProcessor()) + ", customMenuProcessor=" + String.valueOf(this.getCustomMenuProcessor()) + ", whiteLabelingProcessor=" + String.valueOf(this.getWhiteLabelingProcessor()) + ", converterProcessor=" + String.valueOf(this.getConverterProcessor()) + ", integrationProcessor=" + String.valueOf(this.getIntegrationProcessor()) + ", tbResourceProcessor=" + String.valueOf(this.getTbResourceProcessor()) + ", reportTemplateProcessor=" + String.valueOf(this.getReportTemplateProcessor()) + ", secretProcessor=" + String.valueOf(this.getSecretProcessor()) + ", encryptionKeyCloudProcessor=" + String.valueOf(this.getEncryptionKeyCloudProcessor()) + ", edgeSettingsService=" + String.valueOf(this.getEdgeSettingsService()) + ", cloudEventStorageSettings=" + String.valueOf(this.getCloudEventStorageSettings()) + ", calculatedFieldProcessor=" + String.valueOf(this.getCalculatedFieldProcessor()) + ", dbCallbackExecutorService=" + String.valueOf(this.getDbCallbackExecutorService()) + ")";
    }
}

