/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf.ctx.state.geofencing;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.common.util.geo.Coordinates;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.cf.configuration.OutputType;
import org.thingsboard.server.common.data.cf.configuration.geofencing.GeofencingCalculatedFieldConfiguration;
import org.thingsboard.server.common.data.cf.configuration.geofencing.GeofencingPresenceStatus;
import org.thingsboard.server.common.data.cf.configuration.geofencing.GeofencingReportStrategy;
import org.thingsboard.server.common.data.cf.configuration.geofencing.GeofencingTransitionEvent;
import org.thingsboard.server.common.data.cf.configuration.geofencing.ZoneGroupConfiguration;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.service.cf.CalculatedFieldResult;
import org.thingsboard.server.service.cf.TelemetryCalculatedFieldResult;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntryType;
import org.thingsboard.server.service.cf.ctx.state.BaseCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.service.cf.ctx.state.SingleValueArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.geofencing.GeofencingArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.geofencing.GeofencingCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.geofencing.GeofencingEvalResult;
import org.thingsboard.server.service.cf.ctx.state.geofencing.ScheduledRefreshSupported;

public class GeofencingCalculatedFieldState
extends BaseCalculatedFieldState
implements ScheduledRefreshSupported {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GeofencingCalculatedFieldState.class);
    private long lastDynamicArgumentsRefreshTs = -1L;

    public GeofencingCalculatedFieldState(EntityId entityId) {
        super(entityId);
    }

    public CalculatedFieldType getType() {
        return CalculatedFieldType.GEOFENCING;
    }

    protected void validateNewEntry(String key, ArgumentEntry newEntry) {
        switch (key) {
            case "latitude": 
            case "longitude": {
                if (newEntry instanceof SingleValueArgumentEntry) break;
                throw new IllegalArgumentException("Unsupported argument entry type for " + key + " argument: " + String.valueOf(newEntry.getType()) + ". Only SINGLE_VALUE type is allowed.");
            }
            default: {
                if (newEntry instanceof GeofencingArgumentEntry) break;
                throw new IllegalArgumentException("Unsupported argument entry type for " + key + " argument: " + String.valueOf(newEntry.getType()) + ". Only GEOFENCING type is allowed.");
            }
        }
    }

    public ListenableFuture<CalculatedFieldResult> performCalculation(Map<String, ArgumentEntry> updatedArgs, CalculatedFieldCtx ctx) {
        double latitude = (Double)((ArgumentEntry)this.arguments.get("latitude")).getValue();
        double longitude = (Double)((ArgumentEntry)this.arguments.get("longitude")).getValue();
        Coordinates entityCoordinates = new Coordinates(latitude, longitude);
        GeofencingCalculatedFieldConfiguration geofencingCfg = (GeofencingCalculatedFieldConfiguration)ctx.getCalculatedField().getConfiguration();
        Map zoneGroups = geofencingCfg.getZoneGroups();
        ObjectNode valuesNode = JacksonUtil.newObjectNode();
        ArrayList relationFutures = new ArrayList();
        this.getGeofencingArguments().forEach((argumentKey, argumentEntry) -> {
            ZoneGroupConfiguration zoneGroupCfg = (ZoneGroupConfiguration)zoneGroups.get(argumentKey);
            if (zoneGroupCfg == null) {
                throw new RuntimeException("Zone group configuration is missing for the: " + String.valueOf(this.entityId));
            }
            boolean createRelationsWithMatchedZones = zoneGroupCfg.isCreateRelationsWithMatchedZones();
            ArrayList zoneResults = new ArrayList(argumentEntry.getZoneStates().size());
            argumentEntry.getZoneStates().forEach((zoneId, zoneState) -> {
                boolean firstEval = zoneState.getLastPresence() == null;
                GeofencingEvalResult eval = zoneState.evaluate(entityCoordinates);
                zoneResults.add(eval);
                if (!createRelationsWithMatchedZones) {
                    return;
                }
                GeofencingTransitionEvent transitionEvent = eval.transition();
                if (transitionEvent == null) {
                    if (!firstEval) {
                        return;
                    }
                    transitionEvent = eval.status() == GeofencingPresenceStatus.INSIDE ? GeofencingTransitionEvent.ENTERED : GeofencingTransitionEvent.LEFT;
                }
                EntityRelation relation = switch (1.$SwitchMap$org$thingsboard$server$common$data$relation$EntitySearchDirection[zoneGroupCfg.getDirection().ordinal()]) {
                    default -> throw new IncompatibleClassChangeError();
                    case 1 -> new EntityRelation(zoneId, this.entityId, zoneGroupCfg.getRelationType());
                    case 2 -> new EntityRelation(this.entityId, zoneId, zoneGroupCfg.getRelationType());
                };
                ListenableFuture f = switch (1.$SwitchMap$org$thingsboard$server$common$data$cf$configuration$geofencing$GeofencingTransitionEvent[transitionEvent.ordinal()]) {
                    default -> throw new IncompatibleClassChangeError();
                    case 1 -> ctx.getRelationService().saveRelationAsync(ctx.getTenantId(), relation);
                    case 2 -> ctx.getRelationService().deleteRelationAsync(ctx.getTenantId(), relation);
                };
                relationFutures.add(f);
            });
            this.updateValuesNode(argumentKey, zoneResults, zoneGroupCfg.getReportStrategy(), valuesNode);
        });
        OutputType outputType = ctx.getOutput().getType();
        TelemetryCalculatedFieldResult result = TelemetryCalculatedFieldResult.builder().outputStrategy(ctx.getOutput().getStrategy()).type(outputType).scope(ctx.getOutput().getScope()).result((JsonNode)this.toResultNode(valuesNode)).build();
        if (relationFutures.isEmpty()) {
            return Futures.immediateFuture((Object)result);
        }
        return Futures.whenAllComplete(relationFutures).call(() -> result, MoreExecutors.directExecutor());
    }

    public void reset() {
        super.reset();
        this.resetScheduledRefreshTs();
    }

    public void resetScheduledRefreshTs() {
        this.lastDynamicArgumentsRefreshTs = -1L;
    }

    public long getLastScheduledRefreshTs() {
        return this.lastDynamicArgumentsRefreshTs;
    }

    public void updateScheduledRefreshTs() {
        this.lastDynamicArgumentsRefreshTs = System.currentTimeMillis();
    }

    private Map<String, GeofencingArgumentEntry> getGeofencingArguments() {
        return this.arguments.entrySet().stream().filter(entry -> ((ArgumentEntry)entry.getValue()).getType().equals((Object)ArgumentEntryType.GEOFENCING)).collect(Collectors.toMap(Map.Entry::getKey, entry -> (GeofencingArgumentEntry)entry.getValue()));
    }

    private void updateValuesNode(String argumentKey, List<GeofencingEvalResult> zoneResults, GeofencingReportStrategy geofencingReportStrategy, ObjectNode resultNode) {
        GeofencingEvalResult aggregationResult = this.aggregateZoneGroup(zoneResults);
        String eventKey = argumentKey + "Event";
        String statusKey = argumentKey + "Status";
        switch (1.$SwitchMap$org$thingsboard$server$common$data$cf$configuration$geofencing$GeofencingReportStrategy[geofencingReportStrategy.ordinal()]) {
            case 1: {
                this.addTransitionEventIfExists(resultNode, aggregationResult, eventKey);
                break;
            }
            case 2: {
                resultNode.put(statusKey, aggregationResult.status().name());
                break;
            }
            case 3: {
                this.addTransitionEventIfExists(resultNode, aggregationResult, eventKey);
                resultNode.put(statusKey, aggregationResult.status().name());
            }
        }
    }

    private GeofencingEvalResult aggregateZoneGroup(List<GeofencingEvalResult> zoneResults) {
        boolean nowInside = zoneResults.stream().anyMatch(r -> GeofencingPresenceStatus.INSIDE.equals((Object)r.status()));
        boolean prevInside = zoneResults.stream().anyMatch(r -> GeofencingTransitionEvent.LEFT.equals((Object)r.transition()) || r.transition() == null && r.status() == GeofencingPresenceStatus.INSIDE);
        GeofencingTransitionEvent transition = null;
        if (!prevInside && nowInside) {
            transition = GeofencingTransitionEvent.ENTERED;
        } else if (prevInside && !nowInside) {
            transition = GeofencingTransitionEvent.LEFT;
        }
        return new GeofencingEvalResult(transition, nowInside ? GeofencingPresenceStatus.INSIDE : GeofencingPresenceStatus.OUTSIDE);
    }

    private void addTransitionEventIfExists(ObjectNode resultNode, GeofencingEvalResult aggregationResult, String eventKey) {
        if (aggregationResult.transition() != null) {
            resultNode.put(eventKey, aggregationResult.transition().name());
        }
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeofencingCalculatedFieldState)) {
            return false;
        }
        GeofencingCalculatedFieldState other = (GeofencingCalculatedFieldState)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.lastDynamicArgumentsRefreshTs == other.lastDynamicArgumentsRefreshTs;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GeofencingCalculatedFieldState;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $lastDynamicArgumentsRefreshTs = this.lastDynamicArgumentsRefreshTs;
        result = result * 59 + (int)($lastDynamicArgumentsRefreshTs >>> 32 ^ $lastDynamicArgumentsRefreshTs);
        return result;
    }
}

