/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf.ctx.state.alarm;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.concurrent.ScheduledFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.common.util.KvUtil;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.alarm.rule.AlarmRule;
import org.thingsboard.server.common.data.alarm.rule.condition.AlarmCondition;
import org.thingsboard.server.common.data.alarm.rule.condition.AlarmConditionType;
import org.thingsboard.server.common.data.alarm.rule.condition.AlarmConditionValue;
import org.thingsboard.server.common.data.alarm.rule.condition.DurationAlarmCondition;
import org.thingsboard.server.common.data.alarm.rule.condition.RepeatingAlarmCondition;
import org.thingsboard.server.common.data.alarm.rule.condition.expression.AlarmConditionExpression;
import org.thingsboard.server.common.data.alarm.rule.condition.schedule.AlarmSchedule;
import org.thingsboard.server.common.data.alarm.rule.condition.schedule.AlarmScheduleType;
import org.thingsboard.server.common.data.alarm.rule.condition.schedule.AnyTimeSchedule;
import org.thingsboard.server.common.data.alarm.rule.condition.schedule.CustomTimeSchedule;
import org.thingsboard.server.common.data.alarm.rule.condition.schedule.CustomTimeScheduleItem;
import org.thingsboard.server.common.data.alarm.rule.condition.schedule.SpecificTimeSchedule;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.msg.tools.SchedulerUtils;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.service.cf.ctx.state.alarm.AlarmCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.alarm.AlarmEvalResult;
import org.thingsboard.server.service.cf.ctx.state.alarm.AlarmRuleState;

public class AlarmRuleState {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlarmRuleState.class);
    private final AlarmSeverity severity;
    private AlarmRule alarmRule;
    private AlarmCalculatedFieldState state;
    private AlarmCondition condition;
    private long eventCount;
    private long firstEventTs;
    private long lastCheckTs;
    private transient long duration;
    private ScheduledFuture<?> durationCheckFuture;
    private Boolean active;

    public AlarmRuleState(AlarmSeverity severity, AlarmRule alarmRule, AlarmCalculatedFieldState state) {
        this.severity = severity;
        if (alarmRule != null) {
            this.setAlarmRule(alarmRule);
        }
        this.state = state;
    }

    public AlarmEvalResult eval(boolean newEvent, CalculatedFieldCtx ctx) {
        long ts = newEvent ? this.state.getLatestTimestamp() : System.currentTimeMillis();
        this.active = this.isActive(ts);
        if (!this.active.booleanValue()) {
            return AlarmEvalResult.FALSE;
        }
        return this.doEval(newEvent, ctx);
    }

    public AlarmEvalResult reeval(long ts, CalculatedFieldCtx ctx) {
        boolean active = this.isActive(ts);
        switch (1.$SwitchMap$org$thingsboard$server$common$data$alarm$rule$condition$AlarmConditionType[this.condition.getType().ordinal()]) {
            case 1: 
            case 2: {
                boolean activeChanged = this.active == null || active != this.active;
                this.active = active;
                if (!active) {
                    return AlarmEvalResult.EMPTY;
                }
                if ((!this.condition.hasSchedule() || !activeChanged) && !this.condition.getExpression().requiresScheduledReevaluation()) break;
                AlarmEvalResult result = this.doEval(false, ctx);
                if (result.getStatus() == AlarmEvalResult.Status.TRUE) {
                    return result;
                }
                return AlarmEvalResult.EMPTY;
            }
            case 3: {
                if (!active) {
                    return AlarmEvalResult.FALSE;
                }
                long requiredDuration = this.getRequiredDurationInMs();
                if (requiredDuration <= 0L || this.firstEventTs <= 0L || ts <= this.firstEventTs) break;
                this.duration = ts - this.firstEventTs;
                long prevDuration = this.lastCheckTs - this.firstEventTs;
                this.lastCheckTs = ts;
                long leftDuration = requiredDuration - this.duration;
                if (leftDuration <= 0L) {
                    if (prevDuration >= requiredDuration) {
                        return AlarmEvalResult.EMPTY;
                    }
                    return AlarmEvalResult.TRUE;
                }
                return AlarmEvalResult.notYetTrue((long)0L, (long)leftDuration);
            }
        }
        return AlarmEvalResult.EMPTY;
    }

    public AlarmEvalResult doEval(boolean newEvent, CalculatedFieldCtx ctx) {
        return switch (1.$SwitchMap$org$thingsboard$server$common$data$alarm$rule$condition$AlarmConditionType[this.condition.getType().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> this.evalSimple(ctx);
            case 3 -> this.evalDuration(ctx);
            case 2 -> this.evalRepeating(newEvent, ctx);
        };
    }

    private AlarmEvalResult evalSimple(CalculatedFieldCtx ctx) {
        return this.eval(this.condition.getExpression(), ctx) ? AlarmEvalResult.TRUE : AlarmEvalResult.FALSE;
    }

    private AlarmEvalResult evalRepeating(boolean newEvent, CalculatedFieldCtx ctx) {
        if (this.eval(this.condition.getExpression(), ctx)) {
            long requiredRepeats;
            if (newEvent) {
                ++this.eventCount;
            }
            if ((requiredRepeats = (long)this.getIntValue(((RepeatingAlarmCondition)this.condition).getCount()).intValue()) > 0L) {
                long leftRepeats = requiredRepeats - this.eventCount;
                return leftRepeats <= 0L ? AlarmEvalResult.TRUE : AlarmEvalResult.notYetTrue((long)leftRepeats, (long)0L);
            }
            return AlarmEvalResult.NOT_YET_TRUE;
        }
        return AlarmEvalResult.FALSE;
    }

    private AlarmEvalResult evalDuration(CalculatedFieldCtx ctx) {
        if (this.eval(this.condition.getExpression(), ctx)) {
            long ts = System.currentTimeMillis();
            if (this.firstEventTs <= 0L) {
                this.firstEventTs = this.state.getLatestTimestamp();
            }
            this.lastCheckTs = ts;
            long requiredDuration = this.getRequiredDurationInMs();
            if (requiredDuration > 0L && this.firstEventTs > 0L && ts > this.firstEventTs) {
                this.duration = ts - this.firstEventTs;
                long leftDuration = requiredDuration - this.duration;
                if (leftDuration <= 0L) {
                    return AlarmEvalResult.TRUE;
                }
                return AlarmEvalResult.notYetTrue((long)0L, (long)leftDuration);
            }
            return AlarmEvalResult.NOT_YET_TRUE;
        }
        return AlarmEvalResult.FALSE;
    }

    private boolean isActive(long eventTs) {
        if (this.condition.getSchedule() == null) {
            return true;
        }
        AlarmSchedule schedule = (AlarmSchedule)this.state.resolveValue(this.condition.getSchedule(), entry -> Optional.ofNullable(KvUtil.getStringValue((KvEntry)entry)).map(arg_0 -> this.parseSchedule(arg_0)).orElse(null));
        boolean active = switch (1.$SwitchMap$org$thingsboard$server$common$data$alarm$rule$condition$schedule$AlarmScheduleType[schedule.getType().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> true;
            case 2 -> this.isActiveSpecific((SpecificTimeSchedule)schedule, eventTs);
            case 3 -> this.isActiveCustom((CustomTimeSchedule)schedule, eventTs);
        };
        log.trace("Alarm rule active = {} for schedule {}", (Object)active, (Object)schedule);
        return active;
    }

    private boolean isActiveSpecific(SpecificTimeSchedule schedule, long eventTs) {
        long endsOn;
        ZoneId zoneId = SchedulerUtils.getZoneId((String)schedule.getTimezone());
        ZonedDateTime zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(eventTs), zoneId);
        if (schedule.getDaysOfWeek().size() != 7) {
            int dayOfWeek = zdt.getDayOfWeek().getValue();
            if (!schedule.getDaysOfWeek().contains(dayOfWeek)) {
                return false;
            }
        }
        if ((endsOn = schedule.getEndsOn()) == 0L) {
            endsOn = 86400000L;
        }
        return this.isActive(eventTs, zoneId, zdt, schedule.getStartsOn(), endsOn);
    }

    private boolean isActiveCustom(CustomTimeSchedule schedule, long eventTs) {
        ZoneId zoneId = SchedulerUtils.getZoneId((String)schedule.getTimezone());
        ZonedDateTime zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(eventTs), zoneId);
        int dayOfWeek = zdt.toLocalDate().getDayOfWeek().getValue();
        for (CustomTimeScheduleItem item : schedule.getItems()) {
            if (item.getDayOfWeek() != dayOfWeek) continue;
            if (item.isEnabled()) {
                long endsOn = item.getEndsOn();
                if (endsOn == 0L) {
                    endsOn = 86400000L;
                }
                return this.isActive(eventTs, zoneId, zdt, item.getStartsOn(), endsOn);
            }
            return false;
        }
        return false;
    }

    private boolean isActive(long eventTs, ZoneId zoneId, ZonedDateTime zdt, long startsOn, long endsOn) {
        long startOfDay = zdt.toLocalDate().atStartOfDay(zoneId).toInstant().toEpochMilli();
        long msFromStartOfDay = eventTs - startOfDay;
        if (startsOn <= endsOn) {
            return startsOn <= msFromStartOfDay && endsOn > msFromStartOfDay;
        }
        return startsOn < msFromStartOfDay || 0L < msFromStartOfDay && msFromStartOfDay < endsOn;
    }

    public void clear() {
        this.clearRepeatingConditionState();
        this.clearDurationConditionState();
    }

    private void clearRepeatingConditionState() {
        this.eventCount = 0L;
    }

    private void clearDurationConditionState() {
        this.firstEventTs = 0L;
        this.lastCheckTs = 0L;
        this.duration = 0L;
        if (this.durationCheckFuture != null) {
            this.durationCheckFuture.cancel(true);
            this.durationCheckFuture = null;
        }
    }

    public void setDurationCheckFuture(ScheduledFuture<?> durationCheckFuture) {
        if (this.durationCheckFuture != null) {
            log.warn("Setting new duration check future while previous is not null for state {}", (Object)this, (Object)new RuntimeException("stacktrace"));
            this.durationCheckFuture.cancel(true);
        }
        this.durationCheckFuture = durationCheckFuture;
    }

    public boolean isEmpty() {
        return this.eventCount == 0L && this.firstEventTs == 0L && this.lastCheckTs == 0L && this.durationCheckFuture == null;
    }

    private AlarmSchedule parseSchedule(String str) {
        ObjectNode json = (ObjectNode)JacksonUtil.toJsonNode((String)str);
        if (json.isEmpty()) {
            return new AnyTimeSchedule();
        }
        if (!json.hasNonNull("type")) {
            AlarmScheduleType type;
            if (json.hasNonNull("daysOfWeek")) {
                type = AlarmScheduleType.SPECIFIC_TIME;
            } else if (json.hasNonNull("items")) {
                type = AlarmScheduleType.CUSTOM;
            } else {
                throw new IllegalArgumentException("Failed to parse alarm schedule from '" + str + "'");
            }
            json.put("type", type.name());
        }
        return (AlarmSchedule)JacksonUtil.treeToValue((JsonNode)json, AlarmSchedule.class);
    }

    private Integer getIntValue(AlarmConditionValue<Integer> value) {
        return (Integer)this.state.resolveValue(value, entry -> Optional.ofNullable(KvUtil.getLongValue((KvEntry)entry)).map(Long::intValue).orElse(null));
    }

    private long getRequiredDurationInMs() {
        DurationAlarmCondition durationCondition = (DurationAlarmCondition)this.condition;
        return durationCondition.getUnit().toMillis((Long)this.state.resolveValue(durationCondition.getValue(), KvUtil::getLongValue));
    }

    private boolean eval(AlarmConditionExpression expression, CalculatedFieldCtx ctx) {
        return this.state.eval(expression, ctx);
    }

    public void setAlarmRule(AlarmRule alarmRule) {
        this.alarmRule = alarmRule;
        this.condition = alarmRule.getCondition();
        switch (1.$SwitchMap$org$thingsboard$server$common$data$alarm$rule$condition$AlarmConditionType[this.condition.getType().ordinal()]) {
            case 1: {
                this.clearRepeatingConditionState();
                this.clearDurationConditionState();
                break;
            }
            case 2: {
                this.clearDurationConditionState();
                break;
            }
            case 3: {
                this.clearRepeatingConditionState();
            }
        }
    }

    public StateInfo getStateInfo() {
        if (this.condition.getType() == AlarmConditionType.REPEATING) {
            return new StateInfo(Long.valueOf(this.eventCount), null);
        }
        if (this.condition.getType() == AlarmConditionType.DURATION) {
            return new StateInfo(null, Long.valueOf(this.duration));
        }
        return StateInfo.EMPTY;
    }

    public String toString() {
        return "AlarmRuleState{severity=" + String.valueOf(this.severity) + ", condition=" + String.valueOf(this.condition) + ", eventCount=" + this.eventCount + ", firstEventTs=" + this.firstEventTs + ", lastCheckTs=" + this.lastCheckTs + ", duration=" + this.duration + ", durationCheckFuture=" + String.valueOf(this.durationCheckFuture) + "}";
    }

    @Generated
    public AlarmSeverity getSeverity() {
        return this.severity;
    }

    @Generated
    public AlarmRule getAlarmRule() {
        return this.alarmRule;
    }

    @Generated
    public AlarmCalculatedFieldState getState() {
        return this.state;
    }

    @Generated
    public AlarmCondition getCondition() {
        return this.condition;
    }

    @Generated
    public long getEventCount() {
        return this.eventCount;
    }

    @Generated
    public long getFirstEventTs() {
        return this.firstEventTs;
    }

    @Generated
    public long getLastCheckTs() {
        return this.lastCheckTs;
    }

    @Generated
    public long getDuration() {
        return this.duration;
    }

    @Generated
    public ScheduledFuture<?> getDurationCheckFuture() {
        return this.durationCheckFuture;
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public void setState(AlarmCalculatedFieldState state) {
        this.state = state;
    }

    @Generated
    public void setCondition(AlarmCondition condition) {
        this.condition = condition;
    }

    @Generated
    public void setEventCount(long eventCount) {
        this.eventCount = eventCount;
    }

    @Generated
    public void setFirstEventTs(long firstEventTs) {
        this.firstEventTs = firstEventTs;
    }

    @Generated
    public void setLastCheckTs(long lastCheckTs) {
        this.lastCheckTs = lastCheckTs;
    }

    @Generated
    public void setDuration(long duration) {
        this.duration = duration;
    }

    @Generated
    public void setActive(Boolean active) {
        this.active = active;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlarmRuleState)) {
            return false;
        }
        AlarmRuleState other = (AlarmRuleState)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getEventCount() != other.getEventCount()) {
            return false;
        }
        if (this.getFirstEventTs() != other.getFirstEventTs()) {
            return false;
        }
        if (this.getLastCheckTs() != other.getLastCheckTs()) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        AlarmSeverity this$severity = this.getSeverity();
        AlarmSeverity other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !this$severity.equals(other$severity)) {
            return false;
        }
        AlarmRule this$alarmRule = this.getAlarmRule();
        AlarmRule other$alarmRule = other.getAlarmRule();
        if (this$alarmRule == null ? other$alarmRule != null : !this$alarmRule.equals(other$alarmRule)) {
            return false;
        }
        AlarmCalculatedFieldState this$state = this.getState();
        AlarmCalculatedFieldState other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        AlarmCondition this$condition = this.getCondition();
        AlarmCondition other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
            return false;
        }
        ScheduledFuture this$durationCheckFuture = this.getDurationCheckFuture();
        ScheduledFuture other$durationCheckFuture = other.getDurationCheckFuture();
        return !(this$durationCheckFuture == null ? other$durationCheckFuture != null : !this$durationCheckFuture.equals(other$durationCheckFuture));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AlarmRuleState;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $eventCount = this.getEventCount();
        result = result * 59 + (int)($eventCount >>> 32 ^ $eventCount);
        long $firstEventTs = this.getFirstEventTs();
        result = result * 59 + (int)($firstEventTs >>> 32 ^ $firstEventTs);
        long $lastCheckTs = this.getLastCheckTs();
        result = result * 59 + (int)($lastCheckTs >>> 32 ^ $lastCheckTs);
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        AlarmSeverity $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : $severity.hashCode());
        AlarmRule $alarmRule = this.getAlarmRule();
        result = result * 59 + ($alarmRule == null ? 43 : $alarmRule.hashCode());
        AlarmCalculatedFieldState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        AlarmCondition $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        ScheduledFuture $durationCheckFuture = this.getDurationCheckFuture();
        result = result * 59 + ($durationCheckFuture == null ? 43 : $durationCheckFuture.hashCode());
        return result;
    }
}

