/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf.ctx.state.aggregation.single;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.thingsboard.common.util.DebugModeUtil;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.common.util.NumberUtils;
import org.thingsboard.server.actors.TbActorRef;
import org.thingsboard.server.common.data.HasDebugSettings;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.cf.configuration.Argument;
import org.thingsboard.server.common.data.cf.configuration.Output;
import org.thingsboard.server.common.data.cf.configuration.aggregation.AggKeyInput;
import org.thingsboard.server.common.data.cf.configuration.aggregation.AggMetric;
import org.thingsboard.server.common.data.cf.configuration.aggregation.single.EntityAggregationCalculatedFieldConfiguration;
import org.thingsboard.server.common.data.cf.configuration.aggregation.single.interval.AggInterval;
import org.thingsboard.server.common.data.cf.configuration.aggregation.single.interval.Watermark;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.service.cf.CalculatedFieldProcessingService;
import org.thingsboard.server.service.cf.CalculatedFieldResult;
import org.thingsboard.server.service.cf.DefaultCalculatedFieldReprocessingService;
import org.thingsboard.server.service.cf.TelemetryCalculatedFieldResult;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.BaseCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.service.cf.ctx.state.aggregation.single.AggIntervalEntry;
import org.thingsboard.server.service.cf.ctx.state.aggregation.single.AggIntervalEntryStatus;
import org.thingsboard.server.service.cf.ctx.state.aggregation.single.EntityAggregationArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.aggregation.single.EntityAggregationCalculatedFieldState;
import org.thingsboard.server.utils.CalculatedFieldArgumentUtils;

public class EntityAggregationCalculatedFieldState
extends BaseCalculatedFieldState {
    private AggInterval interval;
    private long watermarkDuration;
    private Map<String, AggMetric> metrics;
    private boolean produceIntermediateResult;
    private EntityAggregationDebugArgumentsTracker debugTracker;
    private CalculatedFieldProcessingService cfProcessingService;
    private long now;

    public EntityAggregationCalculatedFieldState(EntityId entityId) {
        super(entityId);
    }

    public void setCtx(CalculatedFieldCtx ctx, TbActorRef actorCtx) {
        super.setCtx(ctx, actorCtx);
        this.cfProcessingService = ctx.getCfProcessingService();
        EntityAggregationCalculatedFieldConfiguration configuration = (EntityAggregationCalculatedFieldConfiguration)ctx.getCalculatedField().getConfiguration();
        Watermark watermark = configuration.getWatermark();
        this.watermarkDuration = watermark == null ? 0L : TimeUnit.SECONDS.toMillis(watermark.getDuration());
        this.interval = configuration.getInterval();
        this.metrics = configuration.getMetrics();
        this.produceIntermediateResult = configuration.isProduceIntermediateResult();
    }

    public void init(boolean restored) {
        super.init(restored);
        if (restored) {
            this.fillMissingIntervals();
        }
    }

    public CalculatedFieldType getType() {
        return CalculatedFieldType.ENTITY_AGGREGATION;
    }

    public ListenableFuture<CalculatedFieldResult> performCalculation(Map<String, ArgumentEntry> updatedArgs, CalculatedFieldCtx ctx) throws Exception {
        this.createIntervalIfNotExist();
        this.now = System.currentTimeMillis();
        if (DebugModeUtil.isDebugFailuresAvailable((HasDebugSettings)ctx.getCalculatedField())) {
            if (this.debugTracker == null) {
                this.debugTracker = new EntityAggregationDebugArgumentsTracker(new HashMap());
            } else {
                this.debugTracker.reset();
            }
            this.debugTracker.recordUpdatedArgs(updatedArgs, this.arguments);
        }
        HashMap results = new HashMap();
        ArrayList expiredIntervals = new ArrayList();
        this.getIntervals().forEach((intervalEntry, argIntervalStatuses) -> this.processInterval(intervalEntry, argIntervalStatuses, expiredIntervals, results));
        this.removeExpiredIntervals(expiredIntervals);
        Output output = ctx.getOutput();
        ArrayNode result = this.toResult(results, output.getDecimalsByDefault());
        if (result.isEmpty()) {
            return Futures.immediateFuture((Object)TelemetryCalculatedFieldResult.EMPTY);
        }
        return Futures.immediateFuture((Object)TelemetryCalculatedFieldResult.builder().outputStrategy(output.getStrategy()).type(output.getType()).scope(output.getScope()).result((JsonNode)result).build());
    }

    public Map<String, ArgumentEntry> update(Map<String, ArgumentEntry> argumentValues, CalculatedFieldCtx ctx) {
        this.createIntervalIfNotExist();
        return super.update(argumentValues, ctx);
    }

    private void removeExpiredIntervals(List<AggIntervalEntry> expiredIntervals) {
        expiredIntervals.forEach(expiredInterval -> this.arguments.values().stream().map(EntityAggregationArgumentEntry.class::cast).forEach(arg -> arg.getAggIntervals().remove(expiredInterval)));
    }

    private void createIntervalIfNotExist() {
        AggIntervalEntry currentInterval = new AggIntervalEntry(Long.valueOf(this.interval.getCurrentIntervalStartTs()), Long.valueOf(this.interval.getCurrentIntervalEndTs()));
        this.arguments.forEach((argName, argumentEntry) -> {
            EntityAggregationArgumentEntry entityAggEntry = (EntityAggregationArgumentEntry)argumentEntry;
            entityAggEntry.getAggIntervals().computeIfAbsent(currentInterval, current -> new AggIntervalEntryStatus());
        });
    }

    private void fillMissingIntervals() {
        long now = System.currentTimeMillis();
        ZoneId zoneId = this.interval.getZoneId();
        long currentIntervalEndTs = this.interval.getCurrentIntervalEndTs();
        long watermarkThresholdTs = now - this.watermarkDuration;
        Map intervals = this.getIntervals();
        AggIntervalEntry lastIntervalEntry = intervals.keySet().stream().max(Comparator.comparing(AggIntervalEntry::getEndTs)).orElse(null);
        if (lastIntervalEntry == null) {
            return;
        }
        ZonedDateTime nextStart = Instant.ofEpochMilli(lastIntervalEntry.getEndTs()).atZone(zoneId);
        ZonedDateTime nextEnd = this.interval.getNextIntervalStart(nextStart);
        while (nextEnd.toInstant().toEpochMilli() <= currentIntervalEndTs) {
            long nextStartTs = nextStart.toInstant().toEpochMilli();
            long nextEndTs = nextEnd.toInstant().toEpochMilli();
            if (nextEndTs < watermarkThresholdTs) {
                nextStart = nextEnd;
                nextEnd = this.interval.getNextIntervalStart(nextStart);
                continue;
            }
            AggIntervalEntry missing = new AggIntervalEntry(Long.valueOf(nextStartTs), Long.valueOf(nextEndTs));
            this.arguments.forEach((argName, argumentEntry) -> {
                EntityAggregationArgumentEntry entityAggEntry = (EntityAggregationArgumentEntry)argumentEntry;
                AggIntervalEntryStatus intervalEntryStatus = new AggIntervalEntryStatus(System.currentTimeMillis());
                entityAggEntry.getAggIntervals().computeIfAbsent(missing, missingInterval -> intervalEntryStatus);
            });
            nextStart = nextEnd;
            nextEnd = this.interval.getNextIntervalStart(nextStart);
        }
    }

    private Map<AggIntervalEntry, Map<String, AggIntervalEntryStatus>> getIntervals() {
        HashMap<AggIntervalEntry, Map<String, AggIntervalEntryStatus>> intervals = new HashMap<AggIntervalEntry, Map<String, AggIntervalEntryStatus>>();
        this.arguments.forEach((argName, entry) -> {
            EntityAggregationArgumentEntry argEntry = (EntityAggregationArgumentEntry)entry;
            argEntry.getAggIntervals().forEach((intervalEntry, status) -> intervals.computeIfAbsent((AggIntervalEntry)intervalEntry, i -> new HashMap()).put(argName, status));
        });
        return intervals;
    }

    private void processInterval(AggIntervalEntry intervalEntry, Map<String, AggIntervalEntryStatus> args, List<AggIntervalEntry> expiredIntervals, Map<AggIntervalEntry, Map<String, ArgumentEntry>> results) {
        long startTs = intervalEntry.getStartTs();
        long endTs = intervalEntry.getEndTs();
        if (this.now - endTs > this.watermarkDuration) {
            this.handleExpiredInterval(intervalEntry, args, results);
            expiredIntervals.add(intervalEntry);
        } else if (this.now - startTs >= intervalEntry.getIntervalDuration()) {
            this.handleActiveInterval(this.ctx.getCfCheckReevaluationIntervalMillis(), intervalEntry, args, results);
            if (this.watermarkDuration == 0L) {
                expiredIntervals.add(intervalEntry);
            }
        } else if (this.produceIntermediateResult) {
            this.handleActiveInterval(this.ctx.getIntermediateAggregationIntervalMillis(), intervalEntry, args, results);
        }
    }

    private void handleExpiredInterval(AggIntervalEntry intervalEntry, Map<String, AggIntervalEntryStatus> args, Map<AggIntervalEntry, Map<String, ArgumentEntry>> results) {
        args.forEach((argName, argEntryIntervalStatus) -> {
            if (argEntryIntervalStatus.getLastArgsRefreshTs() > argEntryIntervalStatus.getLastMetricsEvalTs()) {
                argEntryIntervalStatus.setLastMetricsEvalTs(System.currentTimeMillis());
                this.processArgument(intervalEntry, argName, false, results);
            } else if (argEntryIntervalStatus.getLastMetricsEvalTs() == -1L) {
                argEntryIntervalStatus.setLastMetricsEvalTs(System.currentTimeMillis());
                this.processArgument(intervalEntry, argName, true, results);
            }
        });
    }

    private void handleActiveInterval(long cfCheckInterval, AggIntervalEntry intervalEntry, Map<String, AggIntervalEntryStatus> args, Map<AggIntervalEntry, Map<String, ArgumentEntry>> results) {
        args.forEach((argName, argEntryIntervalStatus) -> {
            if (argEntryIntervalStatus.intervalPassed(cfCheckInterval)) {
                if (argEntryIntervalStatus.argsUpdated()) {
                    argEntryIntervalStatus.setLastMetricsEvalTs(this.now);
                    argEntryIntervalStatus.setLastArgsRefreshTs(-1L);
                    this.processArgument(intervalEntry, argName, false, results);
                } else if (argEntryIntervalStatus.getLastMetricsEvalTs() == -1L) {
                    argEntryIntervalStatus.setLastMetricsEvalTs(this.now);
                    this.processArgument(intervalEntry, argName, true, results);
                }
            }
        });
    }

    private void processArgument(AggIntervalEntry intervalEntry, String argName, boolean useDefault, Map<AggIntervalEntry, Map<String, ArgumentEntry>> results) {
        Set metrics = this.findMetrics(argName);
        if (!metrics.isEmpty()) {
            metrics.forEach(metricName -> {
                ArgumentEntry metricEntry;
                AggMetric metric = (AggMetric)this.metrics.get(metricName);
                String argKey = ((Argument)this.ctx.getArguments().get(argName)).getRefEntityKey().getKey();
                ArgumentEntry argumentEntry = metricEntry = useDefault ? CalculatedFieldArgumentUtils.createDefaultMetricArgumentEntry((String)argKey, (AggMetric)metric) : this.cfProcessingService.fetchMetricDuringInterval(this.ctx.getTenantId(), this.entityId, argKey, metric, intervalEntry);
                if (!metricEntry.isEmpty()) {
                    results.computeIfAbsent(intervalEntry, i -> new HashMap()).put(metricName, metricEntry);
                }
            });
        }
    }

    private Set<String> findMetrics(String argName) {
        return this.metrics.entrySet().stream().filter(e -> ((AggKeyInput)((AggMetric)e.getValue()).getInput()).getKey().equals(argName)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    protected ArrayNode toResult(Map<AggIntervalEntry, Map<String, ArgumentEntry>> results, Integer precision) {
        ArrayNode result = JacksonUtil.newArrayNode();
        results.forEach((interval, args) -> {
            ObjectNode metricsNode = JacksonUtil.newObjectNode();
            for (Map.Entry entry : args.entrySet()) {
                Object object;
                String metricName = (String)entry.getKey();
                ArgumentEntry argumentEntry = (ArgumentEntry)entry.getValue();
                if (argumentEntry.isEmpty()) continue;
                Object patt15121$temp = argumentEntry.getValue();
                if (patt15121$temp instanceof Number) {
                    Number number = (Number)patt15121$temp;
                    object = NumberUtils.roundResult((double)number.doubleValue(), (Integer)precision);
                } else {
                    object = argumentEntry.getValue();
                }
                Object resultValue = object;
                metricsNode.put(metricName, JacksonUtil.toString((Object)resultValue));
            }
            if (!metricsNode.isEmpty()) {
                ObjectNode resultNode = JacksonUtil.newObjectNode();
                resultNode.put("ts", interval.getStartTs());
                resultNode.set("values", (JsonNode)metricsNode);
                result.add((JsonNode)resultNode);
                if (DebugModeUtil.isDebugFailuresAvailable((HasDebugSettings)this.ctx.getCalculatedField()) && this.debugTracker != null) {
                    this.debugTracker.addInterval(interval);
                }
            }
        });
        return result;
    }

    public ListenableFuture<CalculatedFieldResult> performAggregationDuringInterval(DefaultCalculatedFieldReprocessingService.EntityAggCfReprocessingCtx reprocessingCtx) {
        Set argNames = this.ctx.getArguments().keySet();
        AggIntervalEntry aggInterval = reprocessingCtx.getIntervalCursor();
        HashMap results = new HashMap();
        argNames.forEach(argName -> this.processArgument(aggInterval, argName, false, results));
        Output output = this.ctx.getOutput();
        ArrayNode result = this.toResult(results, output.getDecimalsByDefault());
        if (result.isEmpty()) {
            return Futures.immediateFuture((Object)TelemetryCalculatedFieldResult.EMPTY);
        }
        return Futures.immediateFuture((Object)TelemetryCalculatedFieldResult.builder().type(output.getType()).scope(output.getScope()).result((JsonNode)result).build());
    }

    public JsonNode getArgumentsJson() {
        if (this.debugTracker == null) {
            return null;
        }
        EntityAggregationDebugArguments debugArguments = this.debugTracker.toDebugArguments();
        return debugArguments == null ? null : JacksonUtil.valueToTree((Object)debugArguments);
    }

    public boolean isReady() {
        return true;
    }
}

