/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf.ctx.state.aggregation.function;

import java.util.Optional;
import org.thingsboard.server.service.cf.ctx.state.aggregation.function.AggEntry;

public abstract class BaseAggEntry
implements AggEntry {
    private boolean hasResult = false;

    public void update(Object value) {
        this.doUpdate(this.extractDoubleValue(value));
        this.hasResult = true;
    }

    public Optional<Object> result(Integer precision) {
        if (this.hasResult) {
            this.hasResult = false;
            return Optional.of(this.prepareResult(precision));
        }
        return Optional.empty();
    }

    protected abstract void doUpdate(double var1);

    protected abstract Object prepareResult(Integer var1);

    protected double extractDoubleValue(Object value) {
        try {
            if (value instanceof Number) {
                Number number = (Number)value;
                return number.doubleValue();
            }
            return Double.parseDouble(value.toString());
        }
        catch (Exception e) {
            throw new NumberFormatException("Cannot parse value " + value.toString());
        }
    }
}

