/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf.ctx.state.aggregation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.actors.TbActorRef;
import org.thingsboard.server.common.data.EntityInfo;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.cf.configuration.CalculatedFieldConfiguration;
import org.thingsboard.server.common.data.cf.configuration.Output;
import org.thingsboard.server.common.data.cf.configuration.aggregation.AggFunction;
import org.thingsboard.server.common.data.cf.configuration.aggregation.AggFunctionInput;
import org.thingsboard.server.common.data.cf.configuration.aggregation.AggInput;
import org.thingsboard.server.common.data.cf.configuration.aggregation.AggKeyInput;
import org.thingsboard.server.common.data.cf.configuration.aggregation.AggMetric;
import org.thingsboard.server.common.data.cf.configuration.aggregation.RelatedEntitiesAggregationCalculatedFieldConfiguration;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.permission.MergedUserPermissions;
import org.thingsboard.server.common.data.relation.EntitySearchDirection;
import org.thingsboard.server.dao.entity.EntityService;
import org.thingsboard.server.service.cf.CalculatedFieldResult;
import org.thingsboard.server.service.cf.TelemetryCalculatedFieldResult;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntryType;
import org.thingsboard.server.service.cf.ctx.state.BaseCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.aggregation.RelatedEntitiesAggregationCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.aggregation.RelatedEntitiesArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.aggregation.function.AggEntry;
import org.thingsboard.server.service.cf.ctx.state.geofencing.ScheduledRefreshSupported;

public class RelatedEntitiesAggregationCalculatedFieldState
extends BaseCalculatedFieldState
implements ScheduledRefreshSupported {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RelatedEntitiesAggregationCalculatedFieldState.class);
    private long lastArgsRefreshTs = -1L;
    private long lastMetricsEvalTs = -1L;
    private long lastRelatedEntitiesRefreshTs = -1L;
    private long deduplicationIntervalMs = -1L;
    private Map<String, AggMetric> metrics;
    private ScheduledFuture<?> reevaluationFuture;
    private EntityService entityService;

    public RelatedEntitiesAggregationCalculatedFieldState(EntityId entityId) {
        super(entityId);
    }

    public void setCtx(CalculatedFieldCtx ctx, TbActorRef actorCtx) {
        super.setCtx(ctx, actorCtx);
        RelatedEntitiesAggregationCalculatedFieldConfiguration configuration = (RelatedEntitiesAggregationCalculatedFieldConfiguration)ctx.getCalculatedField().getConfiguration();
        this.metrics = configuration.getMetrics();
        this.deduplicationIntervalMs = TimeUnit.SECONDS.toMillis(configuration.getDeduplicationIntervalInSec());
        this.entityService = ctx.getSystemContext().getEntityService();
    }

    public void init(boolean restored) {
        super.init(restored);
        if (restored) {
            this.scheduleReevaluation();
        }
    }

    public void close() {
        super.close();
        if (this.reevaluationFuture != null) {
            this.reevaluationFuture.cancel(true);
            this.reevaluationFuture = null;
        }
    }

    public void reset() {
        super.reset();
        this.resetScheduledRefreshTs();
        this.lastArgsRefreshTs = -1L;
        this.lastMetricsEvalTs = -1L;
        this.metrics = null;
    }

    public void resetScheduledRefreshTs() {
        this.lastRelatedEntitiesRefreshTs = -1L;
    }

    public long getLastScheduledRefreshTs() {
        return this.lastRelatedEntitiesRefreshTs;
    }

    public void updateScheduledRefreshTs() {
        this.lastRelatedEntitiesRefreshTs = System.currentTimeMillis();
    }

    public CalculatedFieldType getType() {
        return CalculatedFieldType.RELATED_ENTITIES_AGGREGATION;
    }

    public Map<String, ArgumentEntry> update(Map<String, ArgumentEntry> argumentValues, CalculatedFieldCtx ctx) {
        this.lastArgsRefreshTs = System.currentTimeMillis();
        return super.update(argumentValues, ctx);
    }

    public List<EntityId> checkRelatedEntities(List<EntityId> relatedEntities) {
        Map entityInputs = this.prepareInputs();
        this.findOutdatedEntities(entityInputs, relatedEntities).forEach(arg_0 -> this.cleanupEntityData(arg_0));
        this.updateScheduledRefreshTs();
        return this.findMissingEntities(entityInputs, relatedEntities);
    }

    private List<EntityId> findMissingEntities(Map<EntityId, Map<String, ArgumentEntry>> entityInputs, List<EntityId> relatedEntities) {
        ArrayList<EntityId> missing = new ArrayList<EntityId>();
        relatedEntities.forEach(entityId -> {
            if (!entityInputs.containsKey(entityId)) {
                missing.add((EntityId)entityId);
                log.warn("[{}] Missing related entity inputs for {}", (Object)this.ctx.getCfId(), entityId);
            }
        });
        return missing;
    }

    private List<EntityId> findOutdatedEntities(Map<EntityId, Map<String, ArgumentEntry>> entityInputs, List<EntityId> relatedEntities) {
        ArrayList<EntityId> outdated = new ArrayList<EntityId>();
        entityInputs.keySet().forEach(entityId -> {
            if (!relatedEntities.contains(entityId)) {
                outdated.add((EntityId)entityId);
                log.warn("[{}] CF state keeps outdated related entity {}", (Object)this.ctx.getCfId(), entityId);
            }
        });
        return outdated;
    }

    public Map<String, ArgumentEntry> updateEntityData(Map<String, ArgumentEntry> fetchedArgs) {
        this.lastMetricsEvalTs = -1L;
        return this.update(fetchedArgs, this.ctx);
    }

    public void cleanupEntityData(EntityId relatedEntityId) {
        this.arguments.values().forEach(argEntry -> {
            RelatedEntitiesArgumentEntry aggEntry = (RelatedEntitiesArgumentEntry)argEntry;
            aggEntry.getEntityInputs().remove(relatedEntityId);
        });
        this.lastMetricsEvalTs = -1L;
        this.lastArgsRefreshTs = System.currentTimeMillis();
        this.readinessStatus = this.checkReadiness();
    }

    public void scheduleReevaluation() {
        ScheduledFuture future = this.ctx.scheduleReevaluation(this.getEnforcedDeduplicationIntervalMillis(), this.actorCtx);
        if (future != null) {
            this.reevaluationFuture = future;
        }
    }

    public ListenableFuture<CalculatedFieldResult> performCalculation(Map<String, ArgumentEntry> updatedArgs, CalculatedFieldCtx ctx) throws Exception {
        boolean cfUpdated;
        boolean bl = cfUpdated = updatedArgs != null && updatedArgs.isEmpty();
        if (this.shouldRecalculate() || cfUpdated) {
            Output output = ctx.getOutput();
            ObjectNode aggResult = this.aggregateMetrics(output);
            this.lastMetricsEvalTs = System.currentTimeMillis();
            this.scheduleReevaluation();
            return Futures.immediateFuture((Object)TelemetryCalculatedFieldResult.builder().outputStrategy(output.getStrategy()).type(output.getType()).scope(output.getScope()).result((JsonNode)this.toResultNode(aggResult)).build());
        }
        return Futures.immediateFuture((Object)TelemetryCalculatedFieldResult.EMPTY);
    }

    private boolean shouldRecalculate() {
        boolean intervalPassed = this.lastMetricsEvalTs <= System.currentTimeMillis() - this.getEnforcedDeduplicationIntervalMillis();
        boolean argsUpdatedDuringInterval = this.lastArgsRefreshTs > this.lastMetricsEvalTs;
        return intervalPassed && argsUpdatedDuringInterval;
    }

    private long getEnforcedDeduplicationIntervalMillis() {
        return Math.max(this.deduplicationIntervalMs, this.ctx.getMinDeduplicationIntervalMillis());
    }

    private Map<EntityId, Map<String, ArgumentEntry>> prepareInputs() {
        HashMap<EntityId, Map<String, ArgumentEntry>> inputs = new HashMap<EntityId, Map<String, ArgumentEntry>>();
        for (Map.Entry argEntry : this.arguments.entrySet()) {
            String key = (String)argEntry.getKey();
            RelatedEntitiesArgumentEntry relatedEntitiesArgumentEntry = (RelatedEntitiesArgumentEntry)argEntry.getValue();
            relatedEntitiesArgumentEntry.getEntityInputs().forEach((entityId, argumentEntry) -> inputs.computeIfAbsent((EntityId)entityId, k -> new HashMap()).put(key, argumentEntry));
        }
        return inputs;
    }

    private ObjectNode aggregateMetrics(Output output) throws Exception {
        ObjectNode aggResult = JacksonUtil.newObjectNode();
        Map inputs = this.prepareInputs();
        for (Map.Entry entry : this.metrics.entrySet()) {
            String metricKey = (String)entry.getKey();
            AggMetric metric = (AggMetric)entry.getValue();
            AggEntry aggMetricEntry = AggEntry.createAggFunction((AggFunction)metric.getFunction());
            this.aggregateMetric(metric, aggMetricEntry, inputs);
            aggMetricEntry.result(output.getDecimalsByDefault()).ifPresent(result -> aggResult.set(metricKey, JacksonUtil.valueToTree((Object)result)));
        }
        return aggResult;
    }

    private void aggregateMetric(AggMetric metric, AggEntry aggEntry, Map<EntityId, Map<String, ArgumentEntry>> inputs) throws Exception {
        for (Map<String, ArgumentEntry> entityInputs : inputs.values()) {
            Object arg;
            if (!this.applyAggregation(metric.getFilter(), entityInputs) || (arg = this.resolveAggregationInput(metric.getInput(), entityInputs)) == null) continue;
            aggEntry.update(arg);
        }
    }

    private boolean applyAggregation(String filter, Map<String, ArgumentEntry> entityInputs) throws Exception {
        Boolean booleanResult;
        if (filter == null || filter.isEmpty()) {
            return true;
        }
        Object filterResult = this.ctx.evaluateTbelExpression(filter, entityInputs, this.getLatestTimestamp()).get();
        return filterResult instanceof Boolean && (booleanResult = (Boolean)filterResult) != false;
    }

    private Object resolveAggregationInput(AggInput aggInput, Map<String, ArgumentEntry> entityInputs) throws Exception {
        if (aggInput instanceof AggFunctionInput) {
            AggFunctionInput functionInput = (AggFunctionInput)aggInput;
            return this.ctx.evaluateTbelExpression(functionInput.getFunction(), entityInputs, this.getLatestTimestamp()).get();
        }
        String inputKey = ((AggKeyInput)aggInput).getKey();
        return entityInputs.get(inputKey).getValue();
    }

    public JsonNode getArgumentsJson() {
        Map inputs = this.prepareInputs();
        Map entityIdEntityInfos = this.entityService.fetchEntityInfos(this.ctx.getTenantId(), null, inputs.keySet(), MergedUserPermissions.ALL);
        ArrayList entitiesArguments = new ArrayList();
        inputs.forEach((entityId, entityArguments) -> {
            EntityInfo entityInfo = (EntityInfo)entityIdEntityInfos.get(entityId);
            if (entityInfo != null) {
                JsonNode entityArgumentsJson = JacksonUtil.valueToTree(entityArguments.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ArgumentEntry)e.getValue()).jsonValue())));
                entitiesArguments.add(new EntityArgument(entityInfo, entityArgumentsJson));
            }
        });
        return JacksonUtil.valueToTree((Object)new RelatedEntitiesArgument(ArgumentEntryType.RELATED_ENTITIES, entitiesArguments));
    }

    protected CalculatedFieldState.ReadinessStatus checkReadiness() {
        if (this.arguments == null) {
            return CalculatedFieldState.ReadinessStatus.notReady((String)"No entities found via 'Aggregation path to related entities'. Verify the configured relation type and direction.");
        }
        for (String requiredArgumentKey : this.requiredArguments) {
            ArgumentEntry argumentEntry = (ArgumentEntry)this.arguments.get(requiredArgumentKey);
            if (argumentEntry == null || argumentEntry.isEmpty()) {
                return CalculatedFieldState.ReadinessStatus.notReady((String)"No entities found via 'Aggregation path to related entities'. Verify the configured relation type and direction.");
            }
            if (!(argumentEntry instanceof RelatedEntitiesArgumentEntry)) continue;
            RelatedEntitiesArgumentEntry relatedEntitiesArgumentEntry = (RelatedEntitiesArgumentEntry)argumentEntry;
            try {
                this.checkConstraintByDirection(relatedEntitiesArgumentEntry);
            }
            catch (Exception e) {
                return CalculatedFieldState.ReadinessStatus.notReady((String)e.getMessage());
            }
        }
        return CalculatedFieldState.ReadinessStatus.READY;
    }

    public void checkConstraintByDirection(RelatedEntitiesArgumentEntry relatedEntitiesArgumentEntry) {
        RelatedEntitiesAggregationCalculatedFieldConfiguration config;
        CalculatedFieldConfiguration calculatedFieldConfiguration = this.ctx.getCalculatedField().getConfiguration();
        if (calculatedFieldConfiguration instanceof RelatedEntitiesAggregationCalculatedFieldConfiguration && EntitySearchDirection.TO == (config = (RelatedEntitiesAggregationCalculatedFieldConfiguration)calculatedFieldConfiguration).getRelation().direction() && relatedEntitiesArgumentEntry.getEntityInputs().size() > 1) {
            throw new IllegalArgumentException("More than one related entity is not supported for relation direction 'TO'. Found: " + relatedEntitiesArgumentEntry.getEntityInputs().size() + ".");
        }
    }

    @Generated
    public void setLastArgsRefreshTs(long lastArgsRefreshTs) {
        this.lastArgsRefreshTs = lastArgsRefreshTs;
    }

    @Generated
    public long getLastArgsRefreshTs() {
        return this.lastArgsRefreshTs;
    }

    @Generated
    public void setLastMetricsEvalTs(long lastMetricsEvalTs) {
        this.lastMetricsEvalTs = lastMetricsEvalTs;
    }

    @Generated
    public long getLastMetricsEvalTs() {
        return this.lastMetricsEvalTs;
    }
}

