/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf.ctx.state;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.lang.Nullable;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.script.api.tbel.TbelCfArg;
import org.thingsboard.script.api.tbel.TbelCfSingleValueArg;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.BasicKvEntry;
import org.thingsboard.server.common.data.kv.JsonDataEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.util.ProtoUtils;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntryType;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;

public class SingleValueArgumentEntry
implements ArgumentEntry {
    public static final Long DEFAULT_VERSION = -1L;
    @Nullable
    protected EntityId entityId;
    protected long ts;
    protected BasicKvEntry kvEntryValue;
    protected Long version;
    protected boolean forceResetPrevious;

    public SingleValueArgumentEntry() {
        this.ts = -1L;
        this.version = DEFAULT_VERSION;
    }

    public SingleValueArgumentEntry(EntityId entityId, ArgumentEntry entry) {
        this(entry);
        this.entityId = entityId;
    }

    public SingleValueArgumentEntry(ArgumentEntry entry) {
        if (entry instanceof SingleValueArgumentEntry) {
            SingleValueArgumentEntry singleValueArgumentEntry = (SingleValueArgumentEntry)entry;
            this.ts = singleValueArgumentEntry.ts;
            this.kvEntryValue = singleValueArgumentEntry.kvEntryValue;
            this.version = singleValueArgumentEntry.version;
            this.forceResetPrevious = singleValueArgumentEntry.forceResetPrevious;
        }
    }

    public SingleValueArgumentEntry(EntityId entityId, TransportProtos.TsKvProto entry) {
        this(entry);
        this.entityId = entityId;
    }

    public SingleValueArgumentEntry(TransportProtos.TsKvProto entry) {
        this.ts = entry.getTs();
        if (entry.hasVersion()) {
            this.version = entry.getVersion();
        }
        this.kvEntryValue = ProtoUtils.fromProto((TransportProtos.KeyValueProto)entry.getKv());
    }

    public SingleValueArgumentEntry(EntityId entityId, TransportProtos.AttributeValueProto entry) {
        this(entry);
        this.entityId = entityId;
    }

    public SingleValueArgumentEntry(TransportProtos.AttributeValueProto entry) {
        this.ts = entry.getLastUpdateTs();
        if (entry.hasVersion()) {
            this.version = entry.getVersion();
        }
        this.kvEntryValue = ProtoUtils.basicKvEntryFromProto((TransportProtos.AttributeValueProto)entry);
    }

    public SingleValueArgumentEntry(EntityId entityId, KvEntry entry) {
        this(entry);
        this.entityId = entityId;
    }

    public SingleValueArgumentEntry(KvEntry entry) {
        if (entry instanceof TsKvEntry) {
            TsKvEntry tsKvEntry = (TsKvEntry)entry;
            this.ts = tsKvEntry.getTs();
            this.version = tsKvEntry.getVersion();
        } else if (entry instanceof AttributeKvEntry) {
            AttributeKvEntry attributeKvEntry = (AttributeKvEntry)entry;
            this.ts = attributeKvEntry.getLastUpdateTs();
            this.version = attributeKvEntry.getVersion();
        }
        this.kvEntryValue = ProtoUtils.basicKvEntryFromKvEntry((KvEntry)entry);
    }

    public SingleValueArgumentEntry(EntityId entityId, long ts, BasicKvEntry kvEntryValue, Long version) {
        this(ts, kvEntryValue, version);
        this.entityId = entityId;
    }

    public SingleValueArgumentEntry(long ts, BasicKvEntry kvEntryValue, Long version) {
        this.ts = ts;
        this.kvEntryValue = kvEntryValue;
        this.version = version;
    }

    public ArgumentEntryType getType() {
        return ArgumentEntryType.SINGLE_VALUE;
    }

    public boolean isEmpty() {
        return this.kvEntryValue == null;
    }

    @JsonIgnore
    public Object getValue() {
        return this.isEmpty() ? null : this.kvEntryValue.getValue();
    }

    public TbelCfArg toTbelCfArg() {
        Long longValue;
        if (this.isEmpty()) {
            return new TbelCfSingleValueArg(this.ts, null);
        }
        Object value = this.kvEntryValue.getValue();
        if (this.kvEntryValue instanceof JsonDataEntry) {
            try {
                value = JacksonUtil.readValue((String)this.kvEntryValue.getValueAsString(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (value instanceof Long && (longValue = (Long)value) >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE) {
            value = longValue.intValue();
        }
        return new TbelCfSingleValueArg(this.ts, value);
    }

    public boolean updateEntry(ArgumentEntry entry, CalculatedFieldCtx ctx) {
        if (entry instanceof SingleValueArgumentEntry) {
            SingleValueArgumentEntry singleValueEntry = (SingleValueArgumentEntry)entry;
            if (singleValueEntry.getTs() < this.ts) {
                return false;
            }
            Long newVersion = singleValueEntry.getVersion();
            if (newVersion == null || this.version == null || newVersion > this.version) {
                this.ts = singleValueEntry.getTs();
                this.version = newVersion;
                this.kvEntryValue = singleValueEntry.getKvEntryValue();
                return true;
            }
        } else {
            throw new IllegalArgumentException("Unsupported argument entry type for single value argument entry: " + String.valueOf(entry.getType()));
        }
        return false;
    }

    public boolean isDefaultValue() {
        return DEFAULT_VERSION.equals(this.version);
    }

    @Nullable
    @Generated
    public EntityId getEntityId() {
        return this.entityId;
    }

    @Generated
    public long getTs() {
        return this.ts;
    }

    @Generated
    public BasicKvEntry getKvEntryValue() {
        return this.kvEntryValue;
    }

    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Generated
    public boolean isForceResetPrevious() {
        return this.forceResetPrevious;
    }

    @Generated
    public void setEntityId(@Nullable EntityId entityId) {
        this.entityId = entityId;
    }

    @Generated
    public void setTs(long ts) {
        this.ts = ts;
    }

    @Generated
    public void setKvEntryValue(BasicKvEntry kvEntryValue) {
        this.kvEntryValue = kvEntryValue;
    }

    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }

    @Generated
    public void setForceResetPrevious(boolean forceResetPrevious) {
        this.forceResetPrevious = forceResetPrevious;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SingleValueArgumentEntry)) {
            return false;
        }
        SingleValueArgumentEntry other = (SingleValueArgumentEntry)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getTs() != other.getTs()) {
            return false;
        }
        if (this.isForceResetPrevious() != other.isForceResetPrevious()) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        EntityId this$entityId = this.getEntityId();
        EntityId other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        BasicKvEntry this$kvEntryValue = this.getKvEntryValue();
        BasicKvEntry other$kvEntryValue = other.getKvEntryValue();
        return !(this$kvEntryValue == null ? other$kvEntryValue != null : !this$kvEntryValue.equals(other$kvEntryValue));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SingleValueArgumentEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $ts = this.getTs();
        result = result * 59 + (int)($ts >>> 32 ^ $ts);
        result = result * 59 + (this.isForceResetPrevious() ? 79 : 97);
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        EntityId $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        BasicKvEntry $kvEntryValue = this.getKvEntryValue();
        result = result * 59 + ($kvEntryValue == null ? 43 : $kvEntryValue.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SingleValueArgumentEntry(entityId=" + String.valueOf(this.getEntityId()) + ", ts=" + this.getTs() + ", kvEntryValue=" + String.valueOf(this.getKvEntryValue()) + ", version=" + this.getVersion() + ", forceResetPrevious=" + this.isForceResetPrevious() + ")";
    }

    @ConstructorProperties(value={"entityId", "ts", "kvEntryValue", "version", "forceResetPrevious"})
    @Generated
    public SingleValueArgumentEntry(@Nullable EntityId entityId, long ts, BasicKvEntry kvEntryValue, Long version, boolean forceResetPrevious) {
        this.entityId = entityId;
        this.ts = ts;
        this.kvEntryValue = kvEntryValue;
        this.version = version;
        this.forceResetPrevious = forceResetPrevious;
    }
}

