/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf.ctx.state;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.actors.TbActorRef;
import org.thingsboard.server.common.data.cf.configuration.OutputType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.service.cf.ctx.CalculatedFieldEntityCtxId;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.HasLatestTs;
import org.thingsboard.server.service.cf.ctx.state.SingleValueArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.aggregation.RelatedEntitiesArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.aggregation.single.EntityAggregationArgumentEntry;
import org.thingsboard.server.utils.CalculatedFieldUtils;

public abstract class BaseCalculatedFieldState
implements CalculatedFieldState,
Closeable {
    public static final long DEFAULT_LAST_UPDATE_TS = -1L;
    protected final EntityId entityId;
    protected CalculatedFieldCtx ctx;
    protected TbActorRef actorCtx;
    protected List<String> requiredArguments;
    protected Map<String, ArgumentEntry> arguments = new HashMap();
    protected boolean sizeExceedsLimit;
    protected CalculatedFieldState.ReadinessStatus readinessStatus;
    private TopicPartitionInfo partition;

    public BaseCalculatedFieldState(EntityId entityId) {
        this.entityId = entityId;
    }

    public void setCtx(CalculatedFieldCtx ctx, TbActorRef actorCtx) {
        this.ctx = ctx;
        this.actorCtx = actorCtx;
        this.requiredArguments = ctx.getArgNames();
        this.readinessStatus = this.checkReadiness();
    }

    public void init(boolean restored) {
    }

    public Map<String, ArgumentEntry> update(Map<String, ArgumentEntry> argumentValues, CalculatedFieldCtx ctx) {
        HashMap<String, ArgumentEntry> updatedArguments = null;
        for (Map.Entry<String, ArgumentEntry> entry : argumentValues.entrySet()) {
            boolean entryUpdated;
            String key = entry.getKey();
            ArgumentEntry newEntry = entry.getValue();
            this.checkArgumentSize(key, newEntry, ctx);
            ArgumentEntry existingEntry = (ArgumentEntry)this.arguments.get(key);
            if (existingEntry == null || newEntry.isForceResetPrevious()) {
                this.validateNewEntry(key, newEntry);
                if (existingEntry instanceof RelatedEntitiesArgumentEntry || existingEntry instanceof EntityAggregationArgumentEntry) {
                    this.updateEntry(existingEntry, newEntry, ctx);
                } else {
                    this.arguments.put(key, newEntry);
                }
                entryUpdated = true;
            } else {
                entryUpdated = this.updateEntry(existingEntry, newEntry, ctx);
            }
            if (!entryUpdated) continue;
            if (updatedArguments == null) {
                updatedArguments = new HashMap<String, ArgumentEntry>(argumentValues.size());
            }
            updatedArguments.put(key, newEntry);
        }
        if (updatedArguments == null) {
            return Collections.emptyMap();
        }
        this.readinessStatus = this.checkReadiness();
        return updatedArguments;
    }

    protected boolean updateEntry(ArgumentEntry existingEntry, ArgumentEntry newEntry, CalculatedFieldCtx ctx) {
        return existingEntry.updateEntry(newEntry, ctx);
    }

    public void reset() {
        this.requiredArguments = null;
        this.arguments.clear();
        this.sizeExceedsLimit = false;
    }

    public boolean isReady() {
        return this.readinessStatus.ready();
    }

    public void checkStateSize(CalculatedFieldEntityCtxId ctxId, long maxStateSize) {
        if (!this.sizeExceedsLimit && maxStateSize > 0L && (long)CalculatedFieldUtils.toProto((CalculatedFieldEntityCtxId)ctxId, (CalculatedFieldState)this).getSerializedSize() > maxStateSize) {
            this.arguments.clear();
            this.sizeExceedsLimit = true;
        }
    }

    @Override
    public void close() {
    }

    protected void validateNewEntry(String key, ArgumentEntry newEntry) {
    }

    protected ObjectNode toResultNode(ObjectNode valuesNode) {
        if (this.ctx.getOutput().getType() == OutputType.ATTRIBUTES || !this.ctx.isUseLatestTs()) {
            return valuesNode;
        }
        long latestTs = this.getLatestTimestamp();
        if (latestTs == -1L) {
            return valuesNode;
        }
        ObjectNode resultNode = JacksonUtil.newObjectNode();
        resultNode.put("ts", latestTs);
        resultNode.set("values", (JsonNode)valuesNode);
        return resultNode;
    }

    public long getLatestTimestamp() {
        long latestTs = -1L;
        boolean allDefault = this.arguments.values().stream().allMatch(entry -> {
            if (entry instanceof SingleValueArgumentEntry) {
                SingleValueArgumentEntry single = (SingleValueArgumentEntry)entry;
                return single.isDefaultValue();
            }
            return false;
        });
        for (ArgumentEntry entry2 : this.arguments.values()) {
            if (entry2 instanceof SingleValueArgumentEntry) {
                SingleValueArgumentEntry single = (SingleValueArgumentEntry)entry2;
                if (allDefault) {
                    latestTs = Math.max(latestTs, single.getTs());
                    continue;
                }
                if (single.isDefaultValue()) continue;
                latestTs = Math.max(latestTs, single.getTs());
                continue;
            }
            if (!(entry2 instanceof HasLatestTs)) continue;
            HasLatestTs hasLatestTsEntry = (HasLatestTs)entry2;
            latestTs = Math.max(latestTs, hasLatestTsEntry.getLatestTs());
        }
        return latestTs;
    }

    protected CalculatedFieldState.ReadinessStatus checkReadiness() {
        if (this.arguments == null) {
            return CalculatedFieldState.ReadinessStatus.from((List)this.requiredArguments);
        }
        ArrayList<String> emptyArguments = null;
        for (String requiredArgumentKey : this.requiredArguments) {
            ArgumentEntry argumentEntry = (ArgumentEntry)this.arguments.get(requiredArgumentKey);
            if (argumentEntry != null && !argumentEntry.isEmpty()) continue;
            if (emptyArguments == null) {
                emptyArguments = new ArrayList<String>();
            }
            emptyArguments.add(requiredArgumentKey);
        }
        return CalculatedFieldState.ReadinessStatus.from(emptyArguments);
    }

    public JsonNode getArgumentsJson() {
        return JacksonUtil.valueToTree(this.arguments.entrySet().stream().filter(entry -> !((ArgumentEntry)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, e -> ((ArgumentEntry)e.getValue()).jsonValue())));
    }

    @Generated
    public EntityId getEntityId() {
        return this.entityId;
    }

    @Generated
    public CalculatedFieldCtx getCtx() {
        return this.ctx;
    }

    @Generated
    public TbActorRef getActorCtx() {
        return this.actorCtx;
    }

    @Generated
    public List<String> getRequiredArguments() {
        return this.requiredArguments;
    }

    @Generated
    public Map<String, ArgumentEntry> getArguments() {
        return this.arguments;
    }

    @Generated
    public boolean isSizeExceedsLimit() {
        return this.sizeExceedsLimit;
    }

    @Generated
    public CalculatedFieldState.ReadinessStatus getReadinessStatus() {
        return this.readinessStatus;
    }

    @Generated
    public TopicPartitionInfo getPartition() {
        return this.partition;
    }

    @Generated
    public void setPartition(TopicPartitionInfo partition) {
        this.partition = partition;
    }
}

