/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf.ctx.state;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.Map;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.script.api.tbel.TbelCfArg;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntryType;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.service.cf.ctx.state.SingleValueArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.TsRollingArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.aggregation.RelatedEntitiesArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.aggregation.single.EntityAggregationArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.geofencing.GeofencingArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.propagation.PropagationArgumentEntry;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=SingleValueArgumentEntry.class, name="SINGLE_VALUE"), @JsonSubTypes.Type(value=TsRollingArgumentEntry.class, name="TS_ROLLING"), @JsonSubTypes.Type(value=GeofencingArgumentEntry.class, name="GEOFENCING"), @JsonSubTypes.Type(value=PropagationArgumentEntry.class, name="PROPAGATION"), @JsonSubTypes.Type(value=RelatedEntitiesArgumentEntry.class, name="RELATED_ENTITIES"), @JsonSubTypes.Type(value=EntityAggregationArgumentEntry.class, name="ENTITY_AGGREGATION")})
public interface ArgumentEntry {
    @JsonIgnore
    public ArgumentEntryType getType();

    public Object getValue();

    public boolean updateEntry(ArgumentEntry var1, CalculatedFieldCtx var2);

    public boolean isEmpty();

    default public JsonNode jsonValue() {
        return JacksonUtil.valueToTree((Object)this.toTbelCfArg());
    }

    public TbelCfArg toTbelCfArg();

    public boolean isForceResetPrevious();

    public void setForceResetPrevious(boolean var1);

    public static ArgumentEntry createSingleValueArgument(KvEntry kvEntry) {
        return new SingleValueArgumentEntry(kvEntry);
    }

    public static ArgumentEntry createSingleValueArgument(EntityId entityId, ArgumentEntry argumentEntry) {
        return new SingleValueArgumentEntry(entityId, argumentEntry);
    }

    public static ArgumentEntry createTsRollingArgument(List<TsKvEntry> kvEntries, int limit, long timeWindow) {
        if (kvEntries == null) {
            return new TsRollingArgumentEntry(limit, timeWindow);
        }
        return new TsRollingArgumentEntry(kvEntries, limit, timeWindow);
    }

    public static ArgumentEntry createGeofencingValueArgument(Map<EntityId, KvEntry> entityIdkvEntryMap) {
        return new GeofencingArgumentEntry(entityIdkvEntryMap);
    }

    public static ArgumentEntry createPropagationArgument(List<EntityId> entityIds) {
        return new PropagationArgumentEntry(entityIds);
    }

    public static ArgumentEntry createAggArgument(Map<EntityId, ArgumentEntry> entityIdkvEntryMap) {
        return new RelatedEntitiesArgumentEntry(entityIdkvEntryMap, false);
    }
}

