/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.cf.configuration.OutputStrategy;
import org.thingsboard.server.common.data.cf.configuration.OutputType;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.service.cf.CalculatedFieldResult;
import org.thingsboard.server.service.cf.TelemetryCalculatedFieldResult;

public final class TelemetryCalculatedFieldResult
implements CalculatedFieldResult {
    private final OutputType type;
    private final AttributeScope scope;
    private final OutputStrategy outputStrategy;
    private final JsonNode result;
    public static final TelemetryCalculatedFieldResult EMPTY = TelemetryCalculatedFieldResult.builder().result(null).build();

    public TbMsg toTbMsg(EntityId entityId, String cfName, List<CalculatedFieldId> cfIds) {
        TbMsgType msgType = switch (1.$SwitchMap$org$thingsboard$server$common$data$cf$configuration$OutputType[this.type.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> TbMsgType.POST_ATTRIBUTES_REQUEST;
            case 2 -> TbMsgType.POST_TELEMETRY_REQUEST;
        };
        TbMsgMetaData metaData = new TbMsgMetaData();
        metaData.putValue("calculatedFieldName", cfName);
        if (OutputType.ATTRIBUTES == this.type) {
            metaData.putValue("scope", this.scope.name());
        }
        return TbMsg.newMsg().type(msgType).originator(entityId).previousCalculatedFieldIds(cfIds).data(this.stringValue()).metaData(metaData).build();
    }

    public String stringValue() {
        return this.result == null ? null : this.result.toString();
    }

    public boolean isEmpty() {
        return this.result == null || this.result.isMissingNode() || this.result.isNull() || this.result.isObject() && this.result.isEmpty() || this.result.isArray() && this.result.isEmpty() || this.result.isTextual() && this.result.asText().isEmpty();
    }

    @ConstructorProperties(value={"type", "scope", "outputStrategy", "result"})
    @Generated
    TelemetryCalculatedFieldResult(OutputType type, AttributeScope scope, OutputStrategy outputStrategy, JsonNode result) {
        this.type = type;
        this.scope = scope;
        this.outputStrategy = outputStrategy;
        this.result = result;
    }

    @Generated
    public static TelemetryCalculatedFieldResultBuilder builder() {
        return new TelemetryCalculatedFieldResultBuilder();
    }

    @Generated
    public OutputType getType() {
        return this.type;
    }

    @Generated
    public AttributeScope getScope() {
        return this.scope;
    }

    @Generated
    public OutputStrategy getOutputStrategy() {
        return this.outputStrategy;
    }

    @Generated
    public JsonNode getResult() {
        return this.result;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TelemetryCalculatedFieldResult)) {
            return false;
        }
        TelemetryCalculatedFieldResult other = (TelemetryCalculatedFieldResult)o;
        OutputType this$type = this.getType();
        OutputType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        AttributeScope this$scope = this.getScope();
        AttributeScope other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        OutputStrategy this$outputStrategy = this.getOutputStrategy();
        OutputStrategy other$outputStrategy = other.getOutputStrategy();
        if (this$outputStrategy == null ? other$outputStrategy != null : !this$outputStrategy.equals(other$outputStrategy)) {
            return false;
        }
        JsonNode this$result = this.getResult();
        JsonNode other$result = other.getResult();
        return !(this$result == null ? other$result != null : !this$result.equals(other$result));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OutputType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        AttributeScope $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        OutputStrategy $outputStrategy = this.getOutputStrategy();
        result = result * 59 + ($outputStrategy == null ? 43 : $outputStrategy.hashCode());
        JsonNode $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TelemetryCalculatedFieldResult(type=" + String.valueOf(this.getType()) + ", scope=" + String.valueOf(this.getScope()) + ", outputStrategy=" + String.valueOf(this.getOutputStrategy()) + ", result=" + String.valueOf(this.getResult()) + ")";
    }
}

